CREATE TABLE [rtd].[tos_stock_quotes_ticks] (
    [id] [bigint] IDENTITY(1,1) NOT NULL,
    [symbol] [varchar](50) NULL,
    [datetime] [datetime] NULL,
    [date] [date] NULL,
    [time] [time](0) NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [int] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [int] NULL,
    [ask_size] [int] NULL,
    [bid_ask_size] [nvarchar](255) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [strength_meter] [nvarchar](255) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [bigint] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [vol_index] [float] NULL,
    [front_vol] [float] NULL,
    [back_vol] [float] NULL,
    [weighted_back_vol] [float] NULL,
    [vol_diff] [float] NULL,
    [put_call_ratio] [float] NULL,
    [call_volume_index] [float] NULL,
    [put_volume_index] [float] NULL,
    [option_volume_index] [float] NULL,
    [front_expected_move] [float] NULL,
    [back_expected_move] [float] NULL,
    [expected_move_diff] [float] NULL,
    [beta] [float] NULL,
    [high52] [smallmoney] NULL,
    [low52] [smallmoney] NULL,
    [pe] [float] NULL,
    [eps] [float] NULL,
    [market_cap] [nvarchar](255) NULL,
    [shares] [bigint] NULL,
    [dividend_yield] [float] NULL,
    [dividend_share] [float] NULL,
  CONSTRAINT [pk_tos_stock_quotes_ticks_rtd] PRIMARY KEY ([id])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'SELECT symbol FROM rtd.tos_stock_list', 1, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'id');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'symbol');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'time', '=Time()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'last', '=RTD("tos.rtd",,"LAST",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'last_x', '=RTD("tos.rtd",,"LX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'mark', '=RTD("tos.rtd",,"MARK",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid', '=RTD("tos.rtd",,"BID",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'ask', '=RTD("tos.rtd",,"ASK",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid_x', '=RTD("tos.rtd",,"BX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'ask_x', '=RTD("tos.rtd",,"AX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'open', '=RTD("tos.rtd",,"OPEN",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'high', '=RTD("tos.rtd",,"HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'low', '=RTD("tos.rtd",,"LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'close', '=RTD("tos.rtd",,"CLOSE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'volume', '=RTD("tos.rtd",,"VOLUME",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'beta', '=RTD("tos.rtd",,"BETA",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'high52', '=RTD("tos.rtd",,"52HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'low52', '=RTD("tos.rtd",,"52LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'pe', '=RTD("tos.rtd",,"PE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'eps', '=RTD("tos.rtd",,"EPS",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'shares', '=RTD("tos.rtd",,"SHARES",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'dividend_share', '=RTD("tos.rtd",,"DIV",[symbol])', NULL);

