CREATE TABLE [rtd].[tos_option_data_ticks] (
    [id] [int] IDENTITY(1,1) NOT NULL,
    [code] [varchar](50) NULL,
    [datetime] [datetime] NULL,
    [date] [date] NULL,
    [time] [time](0) NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [smallint] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [smallint] NULL,
    [ask_size] [smallint] NULL,
    [bid_ask_size] [varchar](50) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [int] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [delta] [float] NULL,
    [gamma] [float] NULL,
    [theta] [float] NULL,
    [vega] [float] NULL,
    [rho] [float] NULL,
    [extrinsic] [smallmoney] NULL,
    [intrinsic] [smallmoney] NULL,
    [probability_itm] [float] NULL,
    [probability_otm] [float] NULL,
    [probability_touch] [float] NULL,
    [covered_return] [float] NULL,
    [max_covered_return] [float] NULL,
  CONSTRAINT [pk_tos_option_data_ticks_rtd] PRIMARY KEY ([id])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_option_data_ticks', 'SELECT code FROM rtd.tos_option_list', 1, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_option_data_ticks', 'id');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_option_data_ticks', 'code');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'time', '=Time()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'last', '=RTD("tos.rtd",,"LAST",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'last_x', '=RTD("tos.rtd",,"LX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'mark', '=RTD("tos.rtd",,"MARK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'bid', '=RTD("tos.rtd",,"BID",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'ask', '=RTD("tos.rtd",,"ASK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'bid_x', '=RTD("tos.rtd",,"BX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'ask_x', '=RTD("tos.rtd",,"AX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'open', '=RTD("tos.rtd",,"OPEN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'high', '=RTD("tos.rtd",,"HIGH",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'low', '=RTD("tos.rtd",,"LOW",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'close', '=RTD("tos.rtd",,"CLOSE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'volume', '=RTD("tos.rtd",,"VOLUME",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'delta', '=RTD("tos.rtd",,"DELTA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'gamma', '=RTD("tos.rtd",,"GAMMA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'theta', '=RTD("tos.rtd",,"THETA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'vega', '=RTD("tos.rtd",,"VEGA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'rho', '=RTD("tos.rtd",,"RHO",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[code])', 1);

