CREATE TABLE [rtd].[tos_last_stock_quotes] (
    [symbol] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NULL,
    [time] [time](0) NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [int] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [int] NULL,
    [ask_size] [int] NULL,
    [bid_ask_size] [nvarchar](255) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [strength_meter] [nvarchar](255) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [bigint] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [vol_index] [float] NULL,
    [front_vol] [float] NULL,
    [back_vol] [float] NULL,
    [weighted_back_vol] [float] NULL,
    [vol_diff] [float] NULL,
    [put_call_ratio] [float] NULL,
    [call_volume_index] [float] NULL,
    [put_volume_index] [float] NULL,
    [option_volume_index] [float] NULL,
    [front_expected_move] [float] NULL,
    [back_expected_move] [float] NULL,
    [expected_move_diff] [float] NULL,
    [beta] [float] NULL,
    [high52] [smallmoney] NULL,
    [low52] [smallmoney] NULL,
    [pe] [float] NULL,
    [eps] [float] NULL,
    [market_cap] [nvarchar](255) NULL,
    [shares] [bigint] NULL,
    [dividend_yield] [float] NULL,
    [dividend_share] [float] NULL,
    [last_update_timestamp] [timestamp] NULL,
  CONSTRAINT [pk_tos_last_stock_quotes_rtd] PRIMARY KEY ([symbol])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_last_stock_quotes', 'SELECT symbol FROM rtd.tos_stock_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_last_stock_quotes', 'symbol');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'time', '=Time()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'last', '=RTD("tos.rtd",,"LAST",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'last_x', '=RTD("tos.rtd",,"LX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'mark', '=RTD("tos.rtd",,"MARK",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'bid', '=RTD("tos.rtd",,"BID",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'ask', '=RTD("tos.rtd",,"ASK",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'bid_x', '=RTD("tos.rtd",,"BX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'ask_x', '=RTD("tos.rtd",,"AX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'open', '=RTD("tos.rtd",,"OPEN",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'high', '=RTD("tos.rtd",,"HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'low', '=RTD("tos.rtd",,"LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'close', '=RTD("tos.rtd",,"CLOSE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'volume', '=RTD("tos.rtd",,"VOLUME",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'beta', '=RTD("tos.rtd",,"BETA",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'high52', '=RTD("tos.rtd",,"52HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'low52', '=RTD("tos.rtd",,"52LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'pe', '=RTD("tos.rtd",,"PE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'eps', '=RTD("tos.rtd",,"EPS",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'shares', '=RTD("tos.rtd",,"SHARES",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'dividend_share', '=RTD("tos.rtd",,"DIV",[symbol])', NULL);

