IF SCHEMA_ID('rtd') IS NULL
EXEC('CREATE SCHEMA [rtd]');

IF OBJECT_ID('[rtd].[real_time_formulas]') IS NULL
CREATE TABLE [rtd].[real_time_formulas] (
    [id] [int] IDENTITY(1,1) NOT NULL,
    [table_schema] [nvarchar](128) NOT NULL,
    [table_name] [nvarchar](128) NOT NULL,
    [column_name] [nvarchar](128) NOT NULL,
    [rtd_formula] [nvarchar](255) NULL,
    [is_disabled] [tinyint] NULL,
  CONSTRAINT [pk_real_time_formulas_rtd] PRIMARY KEY ([id]),
  CONSTRAINT [ix_real_time_formulas_schema_name_columnname_rtd] UNIQUE ([table_schema], [table_name], [column_name])
);

IF OBJECT_ID('[rtd].[real_time_tables]') IS NULL
CREATE TABLE [rtd].[real_time_tables] (
    [id] [int] IDENTITY(1,1) NOT NULL,
    [table_schema] [nvarchar](128) NOT NULL,
    [table_name] [nvarchar](128) NOT NULL,
    [load_code] [nvarchar](2000) NULL,
    [is_history] [tinyint] NULL,
    [is_disabled] [tinyint] NULL,
    [time_zone] [nvarchar](50) NULL,
    [rtd_instance_name] [nvarchar](50) NULL,
  CONSTRAINT [pk_real_time_tables_rtd] PRIMARY KEY ([id]),
  CONSTRAINT [ix_real_time_tables_schema_name_rtd] UNIQUE ([table_schema], [table_name])
);

CREATE TABLE [rtd].[tos_historical_option_data] (
    [code] [varchar](50) NOT NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [smallint] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [smallint] NULL,
    [ask_size] [smallint] NULL,
    [bid_ask_size] [varchar](50) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [int] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [delta] [float] NULL,
    [gamma] [float] NULL,
    [theta] [float] NULL,
    [vega] [float] NULL,
    [rho] [float] NULL,
    [extrinsic] [smallmoney] NULL,
    [intrinsic] [smallmoney] NULL,
    [probability_itm] [float] NULL,
    [probability_otm] [float] NULL,
    [probability_touch] [float] NULL,
    [covered_return] [float] NULL,
    [max_covered_return] [float] NULL,
    [last_update_timestamp] [timestamp] NULL,
  CONSTRAINT [pk_tos_historical_option_data_rtd] PRIMARY KEY ([code], [date])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_historical_option_data', 'SELECT code FROM rtd.tos_option_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_historical_option_data', 'code');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'time', '=Time()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'last', '=RTD("tos.rtd",,"LAST",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'last_x', '=RTD("tos.rtd",,"LX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'mark', '=RTD("tos.rtd",,"MARK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'bid', '=RTD("tos.rtd",,"BID",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'ask', '=RTD("tos.rtd",,"ASK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'bid_x', '=RTD("tos.rtd",,"BX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'ask_x', '=RTD("tos.rtd",,"AX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'open', '=RTD("tos.rtd",,"OPEN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'high', '=RTD("tos.rtd",,"HIGH",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'low', '=RTD("tos.rtd",,"LOW",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'close', '=RTD("tos.rtd",,"CLOSE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'volume', '=RTD("tos.rtd",,"VOLUME",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'delta', '=RTD("tos.rtd",,"DELTA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'gamma', '=RTD("tos.rtd",,"GAMMA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'theta', '=RTD("tos.rtd",,"THETA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'vega', '=RTD("tos.rtd",,"VEGA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'rho', '=RTD("tos.rtd",,"RHO",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[code])', 1);

CREATE TABLE [rtd].[tos_historical_prices] (
    [symbol] [varchar](50) NOT NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [int] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [int] NULL,
    [ask_size] [int] NULL,
    [bid_ask_size] [nvarchar](255) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [strength_meter] [nvarchar](255) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [bigint] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [vol_index] [float] NULL,
    [front_vol] [float] NULL,
    [back_vol] [float] NULL,
    [weighted_back_vol] [float] NULL,
    [vol_diff] [float] NULL,
    [put_call_ratio] [float] NULL,
    [call_volume_index] [float] NULL,
    [put_volume_index] [float] NULL,
    [option_volume_index] [float] NULL,
    [front_expected_move] [float] NULL,
    [back_expected_move] [float] NULL,
    [expected_move_diff] [float] NULL,
    [beta] [float] NULL,
    [high52] [smallmoney] NULL,
    [low52] [smallmoney] NULL,
    [pe] [float] NULL,
    [eps] [float] NULL,
    [market_cap] [nvarchar](255) NULL,
    [shares] [bigint] NULL,
    [dividend_yield] [float] NULL,
    [dividend_share] [float] NULL,
    [last_update_timestamp] [timestamp] NOT NULL,
  CONSTRAINT [pk_tos_historical_prices_rtd] PRIMARY KEY ([symbol], [date])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_historical_prices', 'SELECT symbol FROM rtd.tos_stock_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_historical_prices', 'symbol');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'time', '=Time()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'last', '=RTD("tos.rtd",,"LAST",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'last_x', '=RTD("tos.rtd",,"LX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'mark', '=RTD("tos.rtd",,"MARK",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'bid', '=RTD("tos.rtd",,"BID",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'ask', '=RTD("tos.rtd",,"ASK",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'bid_x', '=RTD("tos.rtd",,"BX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'ask_x', '=RTD("tos.rtd",,"AX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'open', '=RTD("tos.rtd",,"OPEN",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'high', '=RTD("tos.rtd",,"HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'low', '=RTD("tos.rtd",,"LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'close', '=RTD("tos.rtd",,"CLOSE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'volume', '=RTD("tos.rtd",,"VOLUME",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'beta', '=RTD("tos.rtd",,"BETA",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'high52', '=RTD("tos.rtd",,"52HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'low52', '=RTD("tos.rtd",,"52LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'pe', '=RTD("tos.rtd",,"PE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'eps', '=RTD("tos.rtd",,"EPS",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'shares', '=RTD("tos.rtd",,"SHARES",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'dividend_share', '=RTD("tos.rtd",,"DIV",[symbol])', NULL);

CREATE TABLE [rtd].[tos_last_option_data] (
    [code] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NULL,
    [time] [time](0) NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [smallint] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [smallint] NULL,
    [ask_size] [smallint] NULL,
    [bid_ask_size] [varchar](50) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [int] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [delta] [float] NULL,
    [gamma] [float] NULL,
    [theta] [float] NULL,
    [vega] [float] NULL,
    [rho] [float] NULL,
    [extrinsic] [smallmoney] NULL,
    [intrinsic] [smallmoney] NULL,
    [probability_itm] [float] NULL,
    [probability_otm] [float] NULL,
    [probability_touch] [float] NULL,
    [covered_return] [float] NULL,
    [max_covered_return] [float] NULL,
    [last_update_timestamp] [timestamp] NULL,
  CONSTRAINT [pk_tos_last_option_data_rtd] PRIMARY KEY ([code])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_last_option_data', 'SELECT code FROM rtd.tos_option_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_last_option_data', 'code');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'time', '=Time()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'last', '=RTD("tos.rtd",,"LAST",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'last_x', '=RTD("tos.rtd",,"LX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'mark', '=RTD("tos.rtd",,"MARK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'bid', '=RTD("tos.rtd",,"BID",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'ask', '=RTD("tos.rtd",,"ASK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'bid_x', '=RTD("tos.rtd",,"BX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'ask_x', '=RTD("tos.rtd",,"AX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'open', '=RTD("tos.rtd",,"OPEN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'high', '=RTD("tos.rtd",,"HIGH",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'low', '=RTD("tos.rtd",,"LOW",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'close', '=RTD("tos.rtd",,"CLOSE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'volume', '=RTD("tos.rtd",,"VOLUME",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'delta', '=RTD("tos.rtd",,"DELTA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'gamma', '=RTD("tos.rtd",,"GAMMA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'theta', '=RTD("tos.rtd",,"THETA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'vega', '=RTD("tos.rtd",,"VEGA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'rho', '=RTD("tos.rtd",,"RHO",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[code])', 1);

CREATE TABLE [rtd].[tos_last_stock_quotes] (
    [symbol] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NULL,
    [time] [time](0) NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [int] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [int] NULL,
    [ask_size] [int] NULL,
    [bid_ask_size] [nvarchar](255) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [strength_meter] [nvarchar](255) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [bigint] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [vol_index] [float] NULL,
    [front_vol] [float] NULL,
    [back_vol] [float] NULL,
    [weighted_back_vol] [float] NULL,
    [vol_diff] [float] NULL,
    [put_call_ratio] [float] NULL,
    [call_volume_index] [float] NULL,
    [put_volume_index] [float] NULL,
    [option_volume_index] [float] NULL,
    [front_expected_move] [float] NULL,
    [back_expected_move] [float] NULL,
    [expected_move_diff] [float] NULL,
    [beta] [float] NULL,
    [high52] [smallmoney] NULL,
    [low52] [smallmoney] NULL,
    [pe] [float] NULL,
    [eps] [float] NULL,
    [market_cap] [nvarchar](255) NULL,
    [shares] [bigint] NULL,
    [dividend_yield] [float] NULL,
    [dividend_share] [float] NULL,
    [last_update_timestamp] [timestamp] NULL,
  CONSTRAINT [pk_tos_last_stock_quotes_rtd] PRIMARY KEY ([symbol])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_last_stock_quotes', 'SELECT symbol FROM rtd.tos_stock_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_last_stock_quotes', 'symbol');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'time', '=Time()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'last', '=RTD("tos.rtd",,"LAST",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'last_x', '=RTD("tos.rtd",,"LX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'mark', '=RTD("tos.rtd",,"MARK",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'bid', '=RTD("tos.rtd",,"BID",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'ask', '=RTD("tos.rtd",,"ASK",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'bid_x', '=RTD("tos.rtd",,"BX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'ask_x', '=RTD("tos.rtd",,"AX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'open', '=RTD("tos.rtd",,"OPEN",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'high', '=RTD("tos.rtd",,"HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'low', '=RTD("tos.rtd",,"LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'close', '=RTD("tos.rtd",,"CLOSE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'volume', '=RTD("tos.rtd",,"VOLUME",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'beta', '=RTD("tos.rtd",,"BETA",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'high52', '=RTD("tos.rtd",,"52HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'low52', '=RTD("tos.rtd",,"52LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'pe', '=RTD("tos.rtd",,"PE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'eps', '=RTD("tos.rtd",,"EPS",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'shares', '=RTD("tos.rtd",,"SHARES",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'dividend_share', '=RTD("tos.rtd",,"DIV",[symbol])', NULL);

CREATE TABLE [rtd].[tos_option_data_s] (
    [code] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [smallint] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [smallint] NULL,
    [ask_size] [smallint] NULL,
    [bid_ask_size] [varchar](50) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [int] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [delta] [float] NULL,
    [gamma] [float] NULL,
    [theta] [float] NULL,
    [vega] [float] NULL,
    [rho] [float] NULL,
    [extrinsic] [smallmoney] NULL,
    [intrinsic] [smallmoney] NULL,
    [probability_itm] [float] NULL,
    [probability_otm] [float] NULL,
    [probability_touch] [float] NULL,
    [covered_return] [float] NULL,
    [max_covered_return] [float] NULL,
    [last_update_timestamp] [timestamp] NULL,
  CONSTRAINT [pk_Option1MinuteHistoryTOS_rtd] PRIMARY KEY ([code], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_option_data_s', 'SELECT code FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_option_data_s', 'code');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'time', '=Time0()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'last', '=RTD("tos.rtd",,"LAST",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'last_x', '=RTD("tos.rtd",,"LX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'mark', '=RTD("tos.rtd",,"MARK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'bid', '=RTD("tos.rtd",,"BID",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'ask', '=RTD("tos.rtd",,"ASK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'bid_x', '=RTD("tos.rtd",,"BX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'ask_x', '=RTD("tos.rtd",,"AX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'open', '=RTD("tos.rtd",,"OPEN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'high', '=RTD("tos.rtd",,"HIGH",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'low', '=RTD("tos.rtd",,"LOW",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'close', '=RTD("tos.rtd",,"CLOSE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'volume', '=RTD("tos.rtd",,"VOLUME",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'delta', '=RTD("tos.rtd",,"DELTA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'gamma', '=RTD("tos.rtd",,"GAMMA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'theta', '=RTD("tos.rtd",,"THETA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'vega', '=RTD("tos.rtd",,"VEGA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'rho', '=RTD("tos.rtd",,"RHO",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[code])', 1);

CREATE TABLE [rtd].[tos_option_list] (
    [code] [varchar](50) NOT NULL,
  CONSTRAINT [pk_tos_option_list_rtd] PRIMARY KEY ([code])
);

CREATE TABLE [rtd].[tos_stock_list] (
    [symbol] [varchar](50) NOT NULL,
  CONSTRAINT [pk_tos_stock_list_rtd] PRIMARY KEY ([symbol])
);

INSERT INTO [rtd].[tos_stock_list] ([symbol]) VALUES ('SPY');

CREATE TABLE [rtd].[tos_stock_quotes_s] (
    [symbol] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [int] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [int] NULL,
    [ask_size] [int] NULL,
    [bid_ask_size] [nvarchar](255) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [strength_meter] [nvarchar](255) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [bigint] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [vol_index] [float] NULL,
    [front_vol] [float] NULL,
    [back_vol] [float] NULL,
    [weighted_back_vol] [float] NULL,
    [vol_diff] [float] NULL,
    [put_call_ratio] [float] NULL,
    [call_volume_index] [float] NULL,
    [put_volume_index] [float] NULL,
    [option_volume_index] [float] NULL,
    [front_expected_move] [float] NULL,
    [back_expected_move] [float] NULL,
    [expected_move_diff] [float] NULL,
    [beta] [float] NULL,
    [high52] [smallmoney] NULL,
    [low52] [smallmoney] NULL,
    [pe] [float] NULL,
    [eps] [float] NULL,
    [market_cap] [nvarchar](255) NULL,
    [shares] [bigint] NULL,
    [dividend_yield] [float] NULL,
    [dividend_share] [float] NULL,
    [last_update_timestamp] [timestamp] NOT NULL,
  CONSTRAINT [pk_Quote1MinuteHistoryTOS_rtd] PRIMARY KEY ([symbol], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_stock_quotes_s', 'SELECT symbol FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_stock_quotes_s', 'symbol');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'time', '=Time0()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'last', '=RTD("tos.rtd",,"LAST",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'last_x', '=RTD("tos.rtd",,"LX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'mark', '=RTD("tos.rtd",,"MARK",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'bid', '=RTD("tos.rtd",,"BID",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'ask', '=RTD("tos.rtd",,"ASK",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'bid_x', '=RTD("tos.rtd",,"BX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'ask_x', '=RTD("tos.rtd",,"AX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'open', '=RTD("tos.rtd",,"OPEN",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'high', '=RTD("tos.rtd",,"HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'low', '=RTD("tos.rtd",,"LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'close', '=RTD("tos.rtd",,"CLOSE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'volume', '=RTD("tos.rtd",,"VOLUME",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'beta', '=RTD("tos.rtd",,"BETA",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'high52', '=RTD("tos.rtd",,"52HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'low52', '=RTD("tos.rtd",,"52LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'pe', '=RTD("tos.rtd",,"PE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'eps', '=RTD("tos.rtd",,"EPS",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'shares', '=RTD("tos.rtd",,"SHARES",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'dividend_share', '=RTD("tos.rtd",,"DIV",[symbol])', NULL);

