IF SCHEMA_ID('rtd') IS NULL
EXEC('CREATE SCHEMA [rtd]');

IF OBJECT_ID('[rtd].[real_time_formulas]') IS NULL
CREATE TABLE [rtd].[real_time_formulas] (
    [id] [int] IDENTITY(1,1) NOT NULL,
    [table_schema] [nvarchar](128) NOT NULL,
    [table_name] [nvarchar](128) NOT NULL,
    [column_name] [nvarchar](128) NOT NULL,
    [rtd_formula] [nvarchar](255) NULL,
    [is_disabled] [tinyint] NULL,
  CONSTRAINT [pk_real_time_formulas_rtd] PRIMARY KEY ([id]),
  CONSTRAINT [ix_real_time_formulas_schema_name_columnname_rtd] UNIQUE ([table_schema], [table_name], [column_name])
);

IF OBJECT_ID('[rtd].[real_time_tables]') IS NULL
CREATE TABLE [rtd].[real_time_tables] (
    [id] [int] IDENTITY(1,1) NOT NULL,
    [table_schema] [nvarchar](128) NOT NULL,
    [table_name] [nvarchar](128) NOT NULL,
    [load_code] [nvarchar](2000) NULL,
    [is_history] [tinyint] NULL,
    [is_disabled] [tinyint] NULL,
    [time_zone] [nvarchar](50) NULL,
    [rtd_instance_name] [nvarchar](50) NULL,
  CONSTRAINT [pk_real_time_tables_rtd] PRIMARY KEY ([id]),
  CONSTRAINT [ix_real_time_tables_schema_name_rtd] UNIQUE ([table_schema], [table_name])
);

CREATE TABLE [rtd].[tos_stock_list] (
    [symbol] [varchar](50) NOT NULL,
  CONSTRAINT [pk_tos_stock_list_rtd] PRIMARY KEY ([symbol])
);

INSERT INTO [rtd].[tos_stock_list] ([symbol]) VALUES ('SPY');

CREATE TABLE [rtd].[tos_option_list] (
    [code] [varchar](50) NOT NULL,
  CONSTRAINT [pk_tos_option_list_rtd] PRIMARY KEY ([code])
);

CREATE TABLE [rtd].[tos_historical_option_data] (
    [code] [varchar](50) NOT NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [smallint] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [smallint] NULL,
    [ask_size] [smallint] NULL,
    [bid_ask_size] [varchar](50) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [int] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [delta] [float] NULL,
    [gamma] [float] NULL,
    [theta] [float] NULL,
    [vega] [float] NULL,
    [rho] [float] NULL,
    [extrinsic] [smallmoney] NULL,
    [intrinsic] [smallmoney] NULL,
    [probability_itm] [float] NULL,
    [probability_otm] [float] NULL,
    [probability_touch] [float] NULL,
    [covered_return] [float] NULL,
    [max_covered_return] [float] NULL,
    [last_update_timestamp] [timestamp] NULL,
  CONSTRAINT [pk_tos_historical_option_data_rtd] PRIMARY KEY ([code], [date])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_historical_option_data', 'SELECT code FROM rtd.tos_option_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_historical_option_data', 'code');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'time', '=Time()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'last', '=RTD("tos.rtd",,"LAST",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'last_x', '=RTD("tos.rtd",,"LX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'mark', '=RTD("tos.rtd",,"MARK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'bid', '=RTD("tos.rtd",,"BID",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'ask', '=RTD("tos.rtd",,"ASK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'bid_x', '=RTD("tos.rtd",,"BX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'ask_x', '=RTD("tos.rtd",,"AX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'open', '=RTD("tos.rtd",,"OPEN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'high', '=RTD("tos.rtd",,"HIGH",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'low', '=RTD("tos.rtd",,"LOW",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'close', '=RTD("tos.rtd",,"CLOSE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'volume', '=RTD("tos.rtd",,"VOLUME",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'delta', '=RTD("tos.rtd",,"DELTA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'gamma', '=RTD("tos.rtd",,"GAMMA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'theta', '=RTD("tos.rtd",,"THETA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'vega', '=RTD("tos.rtd",,"VEGA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'rho', '=RTD("tos.rtd",,"RHO",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[code])', 1);

CREATE TABLE [rtd].[tos_historical_prices] (
    [symbol] [varchar](50) NOT NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [int] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [int] NULL,
    [ask_size] [int] NULL,
    [bid_ask_size] [nvarchar](255) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [strength_meter] [nvarchar](255) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [bigint] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [vol_index] [float] NULL,
    [front_vol] [float] NULL,
    [back_vol] [float] NULL,
    [weighted_back_vol] [float] NULL,
    [vol_diff] [float] NULL,
    [put_call_ratio] [float] NULL,
    [call_volume_index] [float] NULL,
    [put_volume_index] [float] NULL,
    [option_volume_index] [float] NULL,
    [front_expected_move] [float] NULL,
    [back_expected_move] [float] NULL,
    [expected_move_diff] [float] NULL,
    [beta] [float] NULL,
    [high52] [smallmoney] NULL,
    [low52] [smallmoney] NULL,
    [pe] [float] NULL,
    [eps] [float] NULL,
    [market_cap] [nvarchar](255) NULL,
    [shares] [bigint] NULL,
    [dividend_yield] [float] NULL,
    [dividend_share] [float] NULL,
    [last_update_timestamp] [timestamp] NOT NULL,
  CONSTRAINT [pk_tos_historical_prices_rtd] PRIMARY KEY ([symbol], [date])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_historical_prices', 'SELECT symbol FROM rtd.tos_stock_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_historical_prices', 'symbol');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'time', '=Time()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'last', '=RTD("tos.rtd",,"LAST",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'last_x', '=RTD("tos.rtd",,"LX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'mark', '=RTD("tos.rtd",,"MARK",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'bid', '=RTD("tos.rtd",,"BID",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'ask', '=RTD("tos.rtd",,"ASK",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'bid_x', '=RTD("tos.rtd",,"BX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'ask_x', '=RTD("tos.rtd",,"AX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'open', '=RTD("tos.rtd",,"OPEN",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'high', '=RTD("tos.rtd",,"HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'low', '=RTD("tos.rtd",,"LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'close', '=RTD("tos.rtd",,"CLOSE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'volume', '=RTD("tos.rtd",,"VOLUME",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'beta', '=RTD("tos.rtd",,"BETA",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'high52', '=RTD("tos.rtd",,"52HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'low52', '=RTD("tos.rtd",,"52LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'pe', '=RTD("tos.rtd",,"PE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'eps', '=RTD("tos.rtd",,"EPS",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'shares', '=RTD("tos.rtd",,"SHARES",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_prices', 'dividend_share', '=RTD("tos.rtd",,"DIV",[symbol])', NULL);

CREATE TABLE [rtd].[tos_last_option_data] (
    [code] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NULL,
    [time] [time](0) NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [smallint] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [smallint] NULL,
    [ask_size] [smallint] NULL,
    [bid_ask_size] [varchar](50) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [int] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [delta] [float] NULL,
    [gamma] [float] NULL,
    [theta] [float] NULL,
    [vega] [float] NULL,
    [rho] [float] NULL,
    [extrinsic] [smallmoney] NULL,
    [intrinsic] [smallmoney] NULL,
    [probability_itm] [float] NULL,
    [probability_otm] [float] NULL,
    [probability_touch] [float] NULL,
    [covered_return] [float] NULL,
    [max_covered_return] [float] NULL,
    [last_update_timestamp] [timestamp] NULL,
  CONSTRAINT [pk_tos_last_option_data_rtd] PRIMARY KEY ([code])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_last_option_data', 'SELECT code FROM rtd.tos_option_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_last_option_data', 'code');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'time', '=Time()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'last', '=RTD("tos.rtd",,"LAST",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'last_x', '=RTD("tos.rtd",,"LX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'mark', '=RTD("tos.rtd",,"MARK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'bid', '=RTD("tos.rtd",,"BID",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'ask', '=RTD("tos.rtd",,"ASK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'bid_x', '=RTD("tos.rtd",,"BX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'ask_x', '=RTD("tos.rtd",,"AX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'open', '=RTD("tos.rtd",,"OPEN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'high', '=RTD("tos.rtd",,"HIGH",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'low', '=RTD("tos.rtd",,"LOW",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'close', '=RTD("tos.rtd",,"CLOSE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'volume', '=RTD("tos.rtd",,"VOLUME",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'delta', '=RTD("tos.rtd",,"DELTA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'gamma', '=RTD("tos.rtd",,"GAMMA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'theta', '=RTD("tos.rtd",,"THETA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'vega', '=RTD("tos.rtd",,"VEGA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'rho', '=RTD("tos.rtd",,"RHO",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_option_data', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[code])', 1);

CREATE TABLE [rtd].[tos_last_stock_quotes] (
    [symbol] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NULL,
    [time] [time](0) NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [int] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [int] NULL,
    [ask_size] [int] NULL,
    [bid_ask_size] [nvarchar](255) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [strength_meter] [nvarchar](255) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [bigint] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [vol_index] [float] NULL,
    [front_vol] [float] NULL,
    [back_vol] [float] NULL,
    [weighted_back_vol] [float] NULL,
    [vol_diff] [float] NULL,
    [put_call_ratio] [float] NULL,
    [call_volume_index] [float] NULL,
    [put_volume_index] [float] NULL,
    [option_volume_index] [float] NULL,
    [front_expected_move] [float] NULL,
    [back_expected_move] [float] NULL,
    [expected_move_diff] [float] NULL,
    [beta] [float] NULL,
    [high52] [smallmoney] NULL,
    [low52] [smallmoney] NULL,
    [pe] [float] NULL,
    [eps] [float] NULL,
    [market_cap] [nvarchar](255) NULL,
    [shares] [bigint] NULL,
    [dividend_yield] [float] NULL,
    [dividend_share] [float] NULL,
    [last_update_timestamp] [timestamp] NULL,
  CONSTRAINT [pk_tos_last_stock_quotes_rtd] PRIMARY KEY ([symbol])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_last_stock_quotes', 'SELECT symbol FROM rtd.tos_stock_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_last_stock_quotes', 'symbol');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'time', '=Time()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'last', '=RTD("tos.rtd",,"LAST",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'last_x', '=RTD("tos.rtd",,"LX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'mark', '=RTD("tos.rtd",,"MARK",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'bid', '=RTD("tos.rtd",,"BID",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'ask', '=RTD("tos.rtd",,"ASK",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'bid_x', '=RTD("tos.rtd",,"BX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'ask_x', '=RTD("tos.rtd",,"AX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'open', '=RTD("tos.rtd",,"OPEN",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'high', '=RTD("tos.rtd",,"HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'low', '=RTD("tos.rtd",,"LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'close', '=RTD("tos.rtd",,"CLOSE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'volume', '=RTD("tos.rtd",,"VOLUME",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'beta', '=RTD("tos.rtd",,"BETA",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'high52', '=RTD("tos.rtd",,"52HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'low52', '=RTD("tos.rtd",,"52LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'pe', '=RTD("tos.rtd",,"PE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'eps', '=RTD("tos.rtd",,"EPS",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'shares', '=RTD("tos.rtd",,"SHARES",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_last_stock_quotes', 'dividend_share', '=RTD("tos.rtd",,"DIV",[symbol])', NULL);

CREATE TABLE [rtd].[tos_option_data_01m] (
    [code] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [smallint] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [smallint] NULL,
    [ask_size] [smallint] NULL,
    [bid_ask_size] [varchar](50) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [int] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [delta] [float] NULL,
    [gamma] [float] NULL,
    [theta] [float] NULL,
    [vega] [float] NULL,
    [rho] [float] NULL,
    [extrinsic] [smallmoney] NULL,
    [intrinsic] [smallmoney] NULL,
    [probability_itm] [float] NULL,
    [probability_otm] [float] NULL,
    [probability_touch] [float] NULL,
    [covered_return] [float] NULL,
    [max_covered_return] [float] NULL,
    [last_update_timestamp] [timestamp] NULL,
  CONSTRAINT [pk_tos_option_data_01m_rtd] PRIMARY KEY ([code], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_option_data_01m', 'SELECT code FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_option_data_01m', 'code');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'time', '=Time1()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'last', '=RTD("tos.rtd",,"LAST",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'last_x', '=RTD("tos.rtd",,"LX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'mark', '=RTD("tos.rtd",,"MARK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'bid', '=RTD("tos.rtd",,"BID",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'ask', '=RTD("tos.rtd",,"ASK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'bid_x', '=RTD("tos.rtd",,"BX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'ask_x', '=RTD("tos.rtd",,"AX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'open', '=RTD("tos.rtd",,"OPEN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'high', '=RTD("tos.rtd",,"HIGH",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'low', '=RTD("tos.rtd",,"LOW",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'close', '=RTD("tos.rtd",,"CLOSE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'volume', '=RTD("tos.rtd",,"VOLUME",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'delta', '=RTD("tos.rtd",,"DELTA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'gamma', '=RTD("tos.rtd",,"GAMMA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'theta', '=RTD("tos.rtd",,"THETA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'vega', '=RTD("tos.rtd",,"VEGA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'rho', '=RTD("tos.rtd",,"RHO",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_01m', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[code])', 1);

CREATE TABLE [rtd].[tos_option_data_05m] (
    [code] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [smallint] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [smallint] NULL,
    [ask_size] [smallint] NULL,
    [bid_ask_size] [varchar](50) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [int] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [delta] [float] NULL,
    [gamma] [float] NULL,
    [theta] [float] NULL,
    [vega] [float] NULL,
    [rho] [float] NULL,
    [extrinsic] [smallmoney] NULL,
    [intrinsic] [smallmoney] NULL,
    [probability_itm] [float] NULL,
    [probability_otm] [float] NULL,
    [probability_touch] [float] NULL,
    [covered_return] [float] NULL,
    [max_covered_return] [float] NULL,
    [last_update_timestamp] [timestamp] NULL,
  CONSTRAINT [pk_tos_option_data_05m_rtd] PRIMARY KEY ([code], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_option_data_05m', 'SELECT code FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_option_data_05m', 'code');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'time', '=Time5()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'last', '=RTD("tos.rtd",,"LAST",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'last_x', '=RTD("tos.rtd",,"LX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'mark', '=RTD("tos.rtd",,"MARK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'bid', '=RTD("tos.rtd",,"BID",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'ask', '=RTD("tos.rtd",,"ASK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'bid_x', '=RTD("tos.rtd",,"BX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'ask_x', '=RTD("tos.rtd",,"AX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'open', '=RTD("tos.rtd",,"OPEN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'high', '=RTD("tos.rtd",,"HIGH",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'low', '=RTD("tos.rtd",,"LOW",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'close', '=RTD("tos.rtd",,"CLOSE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'volume', '=RTD("tos.rtd",,"VOLUME",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'delta', '=RTD("tos.rtd",,"DELTA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'gamma', '=RTD("tos.rtd",,"GAMMA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'theta', '=RTD("tos.rtd",,"THETA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'vega', '=RTD("tos.rtd",,"VEGA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'rho', '=RTD("tos.rtd",,"RHO",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_05m', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[code])', 1);

CREATE TABLE [rtd].[tos_option_data_10m] (
    [code] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [smallint] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [smallint] NULL,
    [ask_size] [smallint] NULL,
    [bid_ask_size] [varchar](50) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [int] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [delta] [float] NULL,
    [gamma] [float] NULL,
    [theta] [float] NULL,
    [vega] [float] NULL,
    [rho] [float] NULL,
    [extrinsic] [smallmoney] NULL,
    [intrinsic] [smallmoney] NULL,
    [probability_itm] [float] NULL,
    [probability_otm] [float] NULL,
    [probability_touch] [float] NULL,
    [covered_return] [float] NULL,
    [max_covered_return] [float] NULL,
    [last_update_timestamp] [timestamp] NULL,
  CONSTRAINT [pk_tos_option_data_10m_rtd] PRIMARY KEY ([code], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_option_data_10m', 'SELECT code FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_option_data_10m', 'code');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'time', '=Time10()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'last', '=RTD("tos.rtd",,"LAST",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'last_x', '=RTD("tos.rtd",,"LX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'mark', '=RTD("tos.rtd",,"MARK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'bid', '=RTD("tos.rtd",,"BID",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'ask', '=RTD("tos.rtd",,"ASK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'bid_x', '=RTD("tos.rtd",,"BX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'ask_x', '=RTD("tos.rtd",,"AX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'open', '=RTD("tos.rtd",,"OPEN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'high', '=RTD("tos.rtd",,"HIGH",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'low', '=RTD("tos.rtd",,"LOW",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'close', '=RTD("tos.rtd",,"CLOSE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'volume', '=RTD("tos.rtd",,"VOLUME",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'delta', '=RTD("tos.rtd",,"DELTA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'gamma', '=RTD("tos.rtd",,"GAMMA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'theta', '=RTD("tos.rtd",,"THETA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'vega', '=RTD("tos.rtd",,"VEGA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'rho', '=RTD("tos.rtd",,"RHO",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_10m', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[code])', 1);

CREATE TABLE [rtd].[tos_option_data_15m] (
    [code] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [smallint] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [smallint] NULL,
    [ask_size] [smallint] NULL,
    [bid_ask_size] [varchar](50) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [int] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [delta] [float] NULL,
    [gamma] [float] NULL,
    [theta] [float] NULL,
    [vega] [float] NULL,
    [rho] [float] NULL,
    [extrinsic] [smallmoney] NULL,
    [intrinsic] [smallmoney] NULL,
    [probability_itm] [float] NULL,
    [probability_otm] [float] NULL,
    [probability_touch] [float] NULL,
    [covered_return] [float] NULL,
    [max_covered_return] [float] NULL,
    [last_update_timestamp] [timestamp] NULL,
  CONSTRAINT [pk_tos_option_data_15m_rtd] PRIMARY KEY ([code], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_option_data_15m', 'SELECT code FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_option_data_15m', 'code');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'time', '=Time15()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'last', '=RTD("tos.rtd",,"LAST",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'last_x', '=RTD("tos.rtd",,"LX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'mark', '=RTD("tos.rtd",,"MARK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'bid', '=RTD("tos.rtd",,"BID",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'ask', '=RTD("tos.rtd",,"ASK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'bid_x', '=RTD("tos.rtd",,"BX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'ask_x', '=RTD("tos.rtd",,"AX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'open', '=RTD("tos.rtd",,"OPEN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'high', '=RTD("tos.rtd",,"HIGH",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'low', '=RTD("tos.rtd",,"LOW",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'close', '=RTD("tos.rtd",,"CLOSE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'volume', '=RTD("tos.rtd",,"VOLUME",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'delta', '=RTD("tos.rtd",,"DELTA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'gamma', '=RTD("tos.rtd",,"GAMMA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'theta', '=RTD("tos.rtd",,"THETA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'vega', '=RTD("tos.rtd",,"VEGA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'rho', '=RTD("tos.rtd",,"RHO",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[code])', 1);

CREATE TABLE [rtd].[tos_option_data_20m] (
    [code] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [smallint] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [smallint] NULL,
    [ask_size] [smallint] NULL,
    [bid_ask_size] [varchar](50) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [int] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [delta] [float] NULL,
    [gamma] [float] NULL,
    [theta] [float] NULL,
    [vega] [float] NULL,
    [rho] [float] NULL,
    [extrinsic] [smallmoney] NULL,
    [intrinsic] [smallmoney] NULL,
    [probability_itm] [float] NULL,
    [probability_otm] [float] NULL,
    [probability_touch] [float] NULL,
    [covered_return] [float] NULL,
    [max_covered_return] [float] NULL,
    [last_update_timestamp] [timestamp] NULL,
  CONSTRAINT [pk_tos_option_data_20m_rtd] PRIMARY KEY ([code], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_option_data_20m', 'SELECT code FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_option_data_20m', 'code');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'time', '=Time20()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'last', '=RTD("tos.rtd",,"LAST",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'last_x', '=RTD("tos.rtd",,"LX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'mark', '=RTD("tos.rtd",,"MARK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'bid', '=RTD("tos.rtd",,"BID",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'ask', '=RTD("tos.rtd",,"ASK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'bid_x', '=RTD("tos.rtd",,"BX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'ask_x', '=RTD("tos.rtd",,"AX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'open', '=RTD("tos.rtd",,"OPEN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'high', '=RTD("tos.rtd",,"HIGH",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'low', '=RTD("tos.rtd",,"LOW",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'close', '=RTD("tos.rtd",,"CLOSE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'volume', '=RTD("tos.rtd",,"VOLUME",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'delta', '=RTD("tos.rtd",,"DELTA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'gamma', '=RTD("tos.rtd",,"GAMMA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'theta', '=RTD("tos.rtd",,"THETA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'vega', '=RTD("tos.rtd",,"VEGA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'rho', '=RTD("tos.rtd",,"RHO",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_20m', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[code])', 1);

CREATE TABLE [rtd].[tos_option_data_30m] (
    [code] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [smallint] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [smallint] NULL,
    [ask_size] [smallint] NULL,
    [bid_ask_size] [varchar](50) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [int] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [delta] [float] NULL,
    [gamma] [float] NULL,
    [theta] [float] NULL,
    [vega] [float] NULL,
    [rho] [float] NULL,
    [extrinsic] [smallmoney] NULL,
    [intrinsic] [smallmoney] NULL,
    [probability_itm] [float] NULL,
    [probability_otm] [float] NULL,
    [probability_touch] [float] NULL,
    [covered_return] [float] NULL,
    [max_covered_return] [float] NULL,
    [last_update_timestamp] [timestamp] NULL,
  CONSTRAINT [pk_tos_option_data_30m_rtd] PRIMARY KEY ([code], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_option_data_30m', 'SELECT code FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_option_data_30m', 'code');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'time', '=Time30()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'last', '=RTD("tos.rtd",,"LAST",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'last_x', '=RTD("tos.rtd",,"LX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'mark', '=RTD("tos.rtd",,"MARK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'bid', '=RTD("tos.rtd",,"BID",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'ask', '=RTD("tos.rtd",,"ASK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'bid_x', '=RTD("tos.rtd",,"BX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'ask_x', '=RTD("tos.rtd",,"AX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'open', '=RTD("tos.rtd",,"OPEN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'high', '=RTD("tos.rtd",,"HIGH",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'low', '=RTD("tos.rtd",,"LOW",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'close', '=RTD("tos.rtd",,"CLOSE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'volume', '=RTD("tos.rtd",,"VOLUME",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'delta', '=RTD("tos.rtd",,"DELTA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'gamma', '=RTD("tos.rtd",,"GAMMA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'theta', '=RTD("tos.rtd",,"THETA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'vega', '=RTD("tos.rtd",,"VEGA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'rho', '=RTD("tos.rtd",,"RHO",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_30m', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[code])', 1);

CREATE TABLE [rtd].[tos_option_data_60m] (
    [code] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [smallint] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [smallint] NULL,
    [ask_size] [smallint] NULL,
    [bid_ask_size] [varchar](50) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [int] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [delta] [float] NULL,
    [gamma] [float] NULL,
    [theta] [float] NULL,
    [vega] [float] NULL,
    [rho] [float] NULL,
    [extrinsic] [smallmoney] NULL,
    [intrinsic] [smallmoney] NULL,
    [probability_itm] [float] NULL,
    [probability_otm] [float] NULL,
    [probability_touch] [float] NULL,
    [covered_return] [float] NULL,
    [max_covered_return] [float] NULL,
    [last_update_timestamp] [timestamp] NULL,
  CONSTRAINT [pk_tos_option_data_60m_rtd] PRIMARY KEY ([code], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_option_data_60m', 'SELECT code FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_option_data_60m', 'code');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'time', '=Time60()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'last', '=RTD("tos.rtd",,"LAST",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'last_x', '=RTD("tos.rtd",,"LX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'mark', '=RTD("tos.rtd",,"MARK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'bid', '=RTD("tos.rtd",,"BID",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'ask', '=RTD("tos.rtd",,"ASK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'bid_x', '=RTD("tos.rtd",,"BX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'ask_x', '=RTD("tos.rtd",,"AX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'open', '=RTD("tos.rtd",,"OPEN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'high', '=RTD("tos.rtd",,"HIGH",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'low', '=RTD("tos.rtd",,"LOW",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'close', '=RTD("tos.rtd",,"CLOSE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'volume', '=RTD("tos.rtd",,"VOLUME",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'delta', '=RTD("tos.rtd",,"DELTA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'gamma', '=RTD("tos.rtd",,"GAMMA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'theta', '=RTD("tos.rtd",,"THETA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'vega', '=RTD("tos.rtd",,"VEGA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'rho', '=RTD("tos.rtd",,"RHO",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_60m', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[code])', 1);

CREATE TABLE [rtd].[tos_option_data_s] (
    [code] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [smallint] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [smallint] NULL,
    [ask_size] [smallint] NULL,
    [bid_ask_size] [varchar](50) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [int] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [delta] [float] NULL,
    [gamma] [float] NULL,
    [theta] [float] NULL,
    [vega] [float] NULL,
    [rho] [float] NULL,
    [extrinsic] [smallmoney] NULL,
    [intrinsic] [smallmoney] NULL,
    [probability_itm] [float] NULL,
    [probability_otm] [float] NULL,
    [probability_touch] [float] NULL,
    [covered_return] [float] NULL,
    [max_covered_return] [float] NULL,
    [last_update_timestamp] [timestamp] NULL,
  CONSTRAINT [pk_Option1MinuteHistoryTOS_rtd] PRIMARY KEY ([code], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_option_data_s', 'SELECT code FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_option_data_s', 'code');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'time', '=Time0()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'last', '=RTD("tos.rtd",,"LAST",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'last_x', '=RTD("tos.rtd",,"LX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'mark', '=RTD("tos.rtd",,"MARK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'bid', '=RTD("tos.rtd",,"BID",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'ask', '=RTD("tos.rtd",,"ASK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'bid_x', '=RTD("tos.rtd",,"BX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'ask_x', '=RTD("tos.rtd",,"AX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'open', '=RTD("tos.rtd",,"OPEN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'high', '=RTD("tos.rtd",,"HIGH",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'low', '=RTD("tos.rtd",,"LOW",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'close', '=RTD("tos.rtd",,"CLOSE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'volume', '=RTD("tos.rtd",,"VOLUME",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'delta', '=RTD("tos.rtd",,"DELTA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'gamma', '=RTD("tos.rtd",,"GAMMA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'theta', '=RTD("tos.rtd",,"THETA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'vega', '=RTD("tos.rtd",,"VEGA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'rho', '=RTD("tos.rtd",,"RHO",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_s', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[code])', 1);

CREATE TABLE [rtd].[tos_option_data_ticks] (
    [id] [int] IDENTITY(1,1) NOT NULL,
    [code] [varchar](50) NULL,
    [datetime] [datetime] NULL,
    [date] [date] NULL,
    [time] [time](0) NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [smallint] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [smallint] NULL,
    [ask_size] [smallint] NULL,
    [bid_ask_size] [varchar](50) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [int] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [delta] [float] NULL,
    [gamma] [float] NULL,
    [theta] [float] NULL,
    [vega] [float] NULL,
    [rho] [float] NULL,
    [extrinsic] [smallmoney] NULL,
    [intrinsic] [smallmoney] NULL,
    [probability_itm] [float] NULL,
    [probability_otm] [float] NULL,
    [probability_touch] [float] NULL,
    [covered_return] [float] NULL,
    [max_covered_return] [float] NULL,
  CONSTRAINT [pk_tos_option_data_ticks_rtd] PRIMARY KEY ([id])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_option_data_ticks', 'SELECT code FROM rtd.tos_option_list', 1, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_option_data_ticks', 'id');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_option_data_ticks', 'code');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'time', '=Time()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'last', '=RTD("tos.rtd",,"LAST",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'last_x', '=RTD("tos.rtd",,"LX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'mark', '=RTD("tos.rtd",,"MARK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'bid', '=RTD("tos.rtd",,"BID",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'ask', '=RTD("tos.rtd",,"ASK",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'bid_x', '=RTD("tos.rtd",,"BX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'ask_x', '=RTD("tos.rtd",,"AX",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'open', '=RTD("tos.rtd",,"OPEN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'high', '=RTD("tos.rtd",,"HIGH",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'low', '=RTD("tos.rtd",,"LOW",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'close', '=RTD("tos.rtd",,"CLOSE",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'volume', '=RTD("tos.rtd",,"VOLUME",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'delta', '=RTD("tos.rtd",,"DELTA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'gamma', '=RTD("tos.rtd",,"GAMMA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'theta', '=RTD("tos.rtd",,"THETA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'vega', '=RTD("tos.rtd",,"VEGA",[code])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'rho', '=RTD("tos.rtd",,"RHO",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[code])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[code])', 1);

CREATE TABLE [rtd].[tos_stock_quotes_01m] (
    [symbol] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [int] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [int] NULL,
    [ask_size] [int] NULL,
    [bid_ask_size] [nvarchar](255) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [strength_meter] [nvarchar](255) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [bigint] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [vol_index] [float] NULL,
    [front_vol] [float] NULL,
    [back_vol] [float] NULL,
    [weighted_back_vol] [float] NULL,
    [vol_diff] [float] NULL,
    [put_call_ratio] [float] NULL,
    [call_volume_index] [float] NULL,
    [put_volume_index] [float] NULL,
    [option_volume_index] [float] NULL,
    [front_expected_move] [float] NULL,
    [back_expected_move] [float] NULL,
    [expected_move_diff] [float] NULL,
    [beta] [float] NULL,
    [high52] [smallmoney] NULL,
    [low52] [smallmoney] NULL,
    [pe] [float] NULL,
    [eps] [float] NULL,
    [market_cap] [nvarchar](255) NULL,
    [shares] [bigint] NULL,
    [dividend_yield] [float] NULL,
    [dividend_share] [float] NULL,
    [last_update_timestamp] [timestamp] NOT NULL,
  CONSTRAINT [pk_tos_stock_quotes_01m_rtd] PRIMARY KEY ([symbol], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_stock_quotes_01m', 'SELECT symbol FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_stock_quotes_01m', 'symbol');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'time', '=Time1()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'last', '=RTD("tos.rtd",,"LAST",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'last_x', '=RTD("tos.rtd",,"LX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'mark', '=RTD("tos.rtd",,"MARK",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'bid', '=RTD("tos.rtd",,"BID",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'ask', '=RTD("tos.rtd",,"ASK",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'bid_x', '=RTD("tos.rtd",,"BX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'ask_x', '=RTD("tos.rtd",,"AX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'open', '=RTD("tos.rtd",,"OPEN",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'high', '=RTD("tos.rtd",,"HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'low', '=RTD("tos.rtd",,"LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'close', '=RTD("tos.rtd",,"CLOSE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'volume', '=RTD("tos.rtd",,"VOLUME",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'beta', '=RTD("tos.rtd",,"BETA",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'high52', '=RTD("tos.rtd",,"52HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'low52', '=RTD("tos.rtd",,"52LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'pe', '=RTD("tos.rtd",,"PE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'eps', '=RTD("tos.rtd",,"EPS",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'shares', '=RTD("tos.rtd",,"SHARES",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_01m', 'dividend_share', '=RTD("tos.rtd",,"DIV",[symbol])', NULL);

CREATE TABLE [rtd].[tos_stock_quotes_05m] (
    [symbol] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [int] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [int] NULL,
    [ask_size] [int] NULL,
    [bid_ask_size] [nvarchar](255) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [strength_meter] [nvarchar](255) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [bigint] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [vol_index] [float] NULL,
    [front_vol] [float] NULL,
    [back_vol] [float] NULL,
    [weighted_back_vol] [float] NULL,
    [vol_diff] [float] NULL,
    [put_call_ratio] [float] NULL,
    [call_volume_index] [float] NULL,
    [put_volume_index] [float] NULL,
    [option_volume_index] [float] NULL,
    [front_expected_move] [float] NULL,
    [back_expected_move] [float] NULL,
    [expected_move_diff] [float] NULL,
    [beta] [float] NULL,
    [high52] [smallmoney] NULL,
    [low52] [smallmoney] NULL,
    [pe] [float] NULL,
    [eps] [float] NULL,
    [market_cap] [nvarchar](255) NULL,
    [shares] [bigint] NULL,
    [dividend_yield] [float] NULL,
    [dividend_share] [float] NULL,
    [last_update_timestamp] [timestamp] NOT NULL,
  CONSTRAINT [pk_tos_stock_quotes_05m_rtd] PRIMARY KEY ([symbol], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_stock_quotes_05m', 'SELECT symbol FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_stock_quotes_05m', 'symbol');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'time', '=Time5()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'last', '=RTD("tos.rtd",,"LAST",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'last_x', '=RTD("tos.rtd",,"LX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'mark', '=RTD("tos.rtd",,"MARK",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'bid', '=RTD("tos.rtd",,"BID",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'ask', '=RTD("tos.rtd",,"ASK",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'bid_x', '=RTD("tos.rtd",,"BX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'ask_x', '=RTD("tos.rtd",,"AX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'open', '=RTD("tos.rtd",,"OPEN",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'high', '=RTD("tos.rtd",,"HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'low', '=RTD("tos.rtd",,"LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'close', '=RTD("tos.rtd",,"CLOSE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'volume', '=RTD("tos.rtd",,"VOLUME",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'beta', '=RTD("tos.rtd",,"BETA",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'high52', '=RTD("tos.rtd",,"52HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'low52', '=RTD("tos.rtd",,"52LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'pe', '=RTD("tos.rtd",,"PE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'eps', '=RTD("tos.rtd",,"EPS",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'shares', '=RTD("tos.rtd",,"SHARES",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_05m', 'dividend_share', '=RTD("tos.rtd",,"DIV",[symbol])', NULL);

CREATE TABLE [rtd].[tos_stock_quotes_10m] (
    [symbol] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [int] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [int] NULL,
    [ask_size] [int] NULL,
    [bid_ask_size] [nvarchar](255) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [strength_meter] [nvarchar](255) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [bigint] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [vol_index] [float] NULL,
    [front_vol] [float] NULL,
    [back_vol] [float] NULL,
    [weighted_back_vol] [float] NULL,
    [vol_diff] [float] NULL,
    [put_call_ratio] [float] NULL,
    [call_volume_index] [float] NULL,
    [put_volume_index] [float] NULL,
    [option_volume_index] [float] NULL,
    [front_expected_move] [float] NULL,
    [back_expected_move] [float] NULL,
    [expected_move_diff] [float] NULL,
    [beta] [float] NULL,
    [high52] [smallmoney] NULL,
    [low52] [smallmoney] NULL,
    [pe] [float] NULL,
    [eps] [float] NULL,
    [market_cap] [nvarchar](255) NULL,
    [shares] [bigint] NULL,
    [dividend_yield] [float] NULL,
    [dividend_share] [float] NULL,
    [last_update_timestamp] [timestamp] NOT NULL,
  CONSTRAINT [pk_tos_stock_quotes_10m_rtd] PRIMARY KEY ([symbol], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_stock_quotes_10m', 'SELECT symbol FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_stock_quotes_10m', 'symbol');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'time', '=Time10()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'last', '=RTD("tos.rtd",,"LAST",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'last_x', '=RTD("tos.rtd",,"LX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'mark', '=RTD("tos.rtd",,"MARK",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'bid', '=RTD("tos.rtd",,"BID",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'ask', '=RTD("tos.rtd",,"ASK",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'bid_x', '=RTD("tos.rtd",,"BX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'ask_x', '=RTD("tos.rtd",,"AX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'open', '=RTD("tos.rtd",,"OPEN",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'high', '=RTD("tos.rtd",,"HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'low', '=RTD("tos.rtd",,"LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'close', '=RTD("tos.rtd",,"CLOSE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'volume', '=RTD("tos.rtd",,"VOLUME",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'beta', '=RTD("tos.rtd",,"BETA",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'high52', '=RTD("tos.rtd",,"52HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'low52', '=RTD("tos.rtd",,"52LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'pe', '=RTD("tos.rtd",,"PE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'eps', '=RTD("tos.rtd",,"EPS",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'shares', '=RTD("tos.rtd",,"SHARES",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_10m', 'dividend_share', '=RTD("tos.rtd",,"DIV",[symbol])', NULL);

CREATE TABLE [rtd].[tos_stock_quotes_15m] (
    [symbol] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [int] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [int] NULL,
    [ask_size] [int] NULL,
    [bid_ask_size] [nvarchar](255) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [strength_meter] [nvarchar](255) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [bigint] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [vol_index] [float] NULL,
    [front_vol] [float] NULL,
    [back_vol] [float] NULL,
    [weighted_back_vol] [float] NULL,
    [vol_diff] [float] NULL,
    [put_call_ratio] [float] NULL,
    [call_volume_index] [float] NULL,
    [put_volume_index] [float] NULL,
    [option_volume_index] [float] NULL,
    [front_expected_move] [float] NULL,
    [back_expected_move] [float] NULL,
    [expected_move_diff] [float] NULL,
    [beta] [float] NULL,
    [high52] [smallmoney] NULL,
    [low52] [smallmoney] NULL,
    [pe] [float] NULL,
    [eps] [float] NULL,
    [market_cap] [nvarchar](255) NULL,
    [shares] [bigint] NULL,
    [dividend_yield] [float] NULL,
    [dividend_share] [float] NULL,
    [last_update_timestamp] [timestamp] NOT NULL,
  CONSTRAINT [pk_tos_stock_quotes_15m_rtd] PRIMARY KEY ([symbol], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_stock_quotes_15m', 'SELECT symbol FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_stock_quotes_15m', 'symbol');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'time', '=Time15()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'last', '=RTD("tos.rtd",,"LAST",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'last_x', '=RTD("tos.rtd",,"LX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'mark', '=RTD("tos.rtd",,"MARK",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'bid', '=RTD("tos.rtd",,"BID",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'ask', '=RTD("tos.rtd",,"ASK",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'bid_x', '=RTD("tos.rtd",,"BX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'ask_x', '=RTD("tos.rtd",,"AX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'open', '=RTD("tos.rtd",,"OPEN",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'high', '=RTD("tos.rtd",,"HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'low', '=RTD("tos.rtd",,"LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'close', '=RTD("tos.rtd",,"CLOSE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'volume', '=RTD("tos.rtd",,"VOLUME",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'beta', '=RTD("tos.rtd",,"BETA",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'high52', '=RTD("tos.rtd",,"52HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'low52', '=RTD("tos.rtd",,"52LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'pe', '=RTD("tos.rtd",,"PE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'eps', '=RTD("tos.rtd",,"EPS",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'shares', '=RTD("tos.rtd",,"SHARES",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_15m', 'dividend_share', '=RTD("tos.rtd",,"DIV",[symbol])', NULL);

CREATE TABLE [rtd].[tos_stock_quotes_20m] (
    [symbol] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [int] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [int] NULL,
    [ask_size] [int] NULL,
    [bid_ask_size] [nvarchar](255) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [strength_meter] [nvarchar](255) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [bigint] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [vol_index] [float] NULL,
    [front_vol] [float] NULL,
    [back_vol] [float] NULL,
    [weighted_back_vol] [float] NULL,
    [vol_diff] [float] NULL,
    [put_call_ratio] [float] NULL,
    [call_volume_index] [float] NULL,
    [put_volume_index] [float] NULL,
    [option_volume_index] [float] NULL,
    [front_expected_move] [float] NULL,
    [back_expected_move] [float] NULL,
    [expected_move_diff] [float] NULL,
    [beta] [float] NULL,
    [high52] [smallmoney] NULL,
    [low52] [smallmoney] NULL,
    [pe] [float] NULL,
    [eps] [float] NULL,
    [market_cap] [nvarchar](255) NULL,
    [shares] [bigint] NULL,
    [dividend_yield] [float] NULL,
    [dividend_share] [float] NULL,
    [last_update_timestamp] [timestamp] NOT NULL,
  CONSTRAINT [pk_tos_stock_quotes_20m_rtd] PRIMARY KEY ([symbol], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_stock_quotes_20m', 'SELECT symbol FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_stock_quotes_20m', 'symbol');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'time', '=Time20()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'last', '=RTD("tos.rtd",,"LAST",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'last_x', '=RTD("tos.rtd",,"LX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'mark', '=RTD("tos.rtd",,"MARK",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'bid', '=RTD("tos.rtd",,"BID",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'ask', '=RTD("tos.rtd",,"ASK",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'bid_x', '=RTD("tos.rtd",,"BX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'ask_x', '=RTD("tos.rtd",,"AX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'open', '=RTD("tos.rtd",,"OPEN",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'high', '=RTD("tos.rtd",,"HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'low', '=RTD("tos.rtd",,"LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'close', '=RTD("tos.rtd",,"CLOSE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'volume', '=RTD("tos.rtd",,"VOLUME",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'beta', '=RTD("tos.rtd",,"BETA",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'high52', '=RTD("tos.rtd",,"52HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'low52', '=RTD("tos.rtd",,"52LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'pe', '=RTD("tos.rtd",,"PE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'eps', '=RTD("tos.rtd",,"EPS",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'shares', '=RTD("tos.rtd",,"SHARES",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_20m', 'dividend_share', '=RTD("tos.rtd",,"DIV",[symbol])', NULL);

CREATE TABLE [rtd].[tos_stock_quotes_30m] (
    [symbol] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [int] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [int] NULL,
    [ask_size] [int] NULL,
    [bid_ask_size] [nvarchar](255) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [strength_meter] [nvarchar](255) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [bigint] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [vol_index] [float] NULL,
    [front_vol] [float] NULL,
    [back_vol] [float] NULL,
    [weighted_back_vol] [float] NULL,
    [vol_diff] [float] NULL,
    [put_call_ratio] [float] NULL,
    [call_volume_index] [float] NULL,
    [put_volume_index] [float] NULL,
    [option_volume_index] [float] NULL,
    [front_expected_move] [float] NULL,
    [back_expected_move] [float] NULL,
    [expected_move_diff] [float] NULL,
    [beta] [float] NULL,
    [high52] [smallmoney] NULL,
    [low52] [smallmoney] NULL,
    [pe] [float] NULL,
    [eps] [float] NULL,
    [market_cap] [nvarchar](255) NULL,
    [shares] [bigint] NULL,
    [dividend_yield] [float] NULL,
    [dividend_share] [float] NULL,
    [last_update_timestamp] [timestamp] NOT NULL,
  CONSTRAINT [pk_tos_stock_quotes_30m_rtd] PRIMARY KEY ([symbol], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_stock_quotes_30m', 'SELECT symbol FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_stock_quotes_30m', 'symbol');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'time', '=Time30()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'last', '=RTD("tos.rtd",,"LAST",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'last_x', '=RTD("tos.rtd",,"LX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'mark', '=RTD("tos.rtd",,"MARK",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'bid', '=RTD("tos.rtd",,"BID",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'ask', '=RTD("tos.rtd",,"ASK",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'bid_x', '=RTD("tos.rtd",,"BX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'ask_x', '=RTD("tos.rtd",,"AX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'open', '=RTD("tos.rtd",,"OPEN",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'high', '=RTD("tos.rtd",,"HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'low', '=RTD("tos.rtd",,"LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'close', '=RTD("tos.rtd",,"CLOSE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'volume', '=RTD("tos.rtd",,"VOLUME",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'beta', '=RTD("tos.rtd",,"BETA",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'high52', '=RTD("tos.rtd",,"52HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'low52', '=RTD("tos.rtd",,"52LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'pe', '=RTD("tos.rtd",,"PE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'eps', '=RTD("tos.rtd",,"EPS",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'shares', '=RTD("tos.rtd",,"SHARES",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_30m', 'dividend_share', '=RTD("tos.rtd",,"DIV",[symbol])', NULL);

CREATE TABLE [rtd].[tos_stock_quotes_60m] (
    [symbol] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [int] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [int] NULL,
    [ask_size] [int] NULL,
    [bid_ask_size] [nvarchar](255) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [strength_meter] [nvarchar](255) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [bigint] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [vol_index] [float] NULL,
    [front_vol] [float] NULL,
    [back_vol] [float] NULL,
    [weighted_back_vol] [float] NULL,
    [vol_diff] [float] NULL,
    [put_call_ratio] [float] NULL,
    [call_volume_index] [float] NULL,
    [put_volume_index] [float] NULL,
    [option_volume_index] [float] NULL,
    [front_expected_move] [float] NULL,
    [back_expected_move] [float] NULL,
    [expected_move_diff] [float] NULL,
    [beta] [float] NULL,
    [high52] [smallmoney] NULL,
    [low52] [smallmoney] NULL,
    [pe] [float] NULL,
    [eps] [float] NULL,
    [market_cap] [nvarchar](255) NULL,
    [shares] [bigint] NULL,
    [dividend_yield] [float] NULL,
    [dividend_share] [float] NULL,
    [last_update_timestamp] [timestamp] NOT NULL,
  CONSTRAINT [pk_tos_stock_quotes_60m_rtd] PRIMARY KEY ([symbol], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_stock_quotes_60m', 'SELECT symbol FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_stock_quotes_60m', 'symbol');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'time', '=Time60()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'last', '=RTD("tos.rtd",,"LAST",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'last_x', '=RTD("tos.rtd",,"LX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'mark', '=RTD("tos.rtd",,"MARK",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'bid', '=RTD("tos.rtd",,"BID",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'ask', '=RTD("tos.rtd",,"ASK",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'bid_x', '=RTD("tos.rtd",,"BX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'ask_x', '=RTD("tos.rtd",,"AX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'open', '=RTD("tos.rtd",,"OPEN",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'high', '=RTD("tos.rtd",,"HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'low', '=RTD("tos.rtd",,"LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'close', '=RTD("tos.rtd",,"CLOSE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'volume', '=RTD("tos.rtd",,"VOLUME",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'beta', '=RTD("tos.rtd",,"BETA",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'high52', '=RTD("tos.rtd",,"52HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'low52', '=RTD("tos.rtd",,"52LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'pe', '=RTD("tos.rtd",,"PE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'eps', '=RTD("tos.rtd",,"EPS",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'shares', '=RTD("tos.rtd",,"SHARES",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_60m', 'dividend_share', '=RTD("tos.rtd",,"DIV",[symbol])', NULL);

CREATE TABLE [rtd].[tos_stock_quotes_s] (
    [symbol] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [int] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [int] NULL,
    [ask_size] [int] NULL,
    [bid_ask_size] [nvarchar](255) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [strength_meter] [nvarchar](255) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [bigint] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [vol_index] [float] NULL,
    [front_vol] [float] NULL,
    [back_vol] [float] NULL,
    [weighted_back_vol] [float] NULL,
    [vol_diff] [float] NULL,
    [put_call_ratio] [float] NULL,
    [call_volume_index] [float] NULL,
    [put_volume_index] [float] NULL,
    [option_volume_index] [float] NULL,
    [front_expected_move] [float] NULL,
    [back_expected_move] [float] NULL,
    [expected_move_diff] [float] NULL,
    [beta] [float] NULL,
    [high52] [smallmoney] NULL,
    [low52] [smallmoney] NULL,
    [pe] [float] NULL,
    [eps] [float] NULL,
    [market_cap] [nvarchar](255) NULL,
    [shares] [bigint] NULL,
    [dividend_yield] [float] NULL,
    [dividend_share] [float] NULL,
    [last_update_timestamp] [timestamp] NOT NULL,
  CONSTRAINT [pk_Quote1MinuteHistoryTOS_rtd] PRIMARY KEY ([symbol], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_stock_quotes_s', 'SELECT symbol FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_stock_quotes_s', 'symbol');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'time', '=Time0()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'last', '=RTD("tos.rtd",,"LAST",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'last_x', '=RTD("tos.rtd",,"LX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'mark', '=RTD("tos.rtd",,"MARK",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'bid', '=RTD("tos.rtd",,"BID",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'ask', '=RTD("tos.rtd",,"ASK",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'bid_x', '=RTD("tos.rtd",,"BX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'ask_x', '=RTD("tos.rtd",,"AX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'open', '=RTD("tos.rtd",,"OPEN",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'high', '=RTD("tos.rtd",,"HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'low', '=RTD("tos.rtd",,"LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'close', '=RTD("tos.rtd",,"CLOSE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'volume', '=RTD("tos.rtd",,"VOLUME",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'beta', '=RTD("tos.rtd",,"BETA",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'high52', '=RTD("tos.rtd",,"52HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'low52', '=RTD("tos.rtd",,"52LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'pe', '=RTD("tos.rtd",,"PE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'eps', '=RTD("tos.rtd",,"EPS",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'shares', '=RTD("tos.rtd",,"SHARES",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_s', 'dividend_share', '=RTD("tos.rtd",,"DIV",[symbol])', NULL);

CREATE TABLE [rtd].[tos_stock_quotes_ticks] (
    [id] [bigint] IDENTITY(1,1) NOT NULL,
    [symbol] [varchar](50) NULL,
    [datetime] [datetime] NULL,
    [date] [date] NULL,
    [time] [time](0) NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [int] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [int] NULL,
    [ask_size] [int] NULL,
    [bid_ask_size] [nvarchar](255) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [strength_meter] [nvarchar](255) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [bigint] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [vol_index] [float] NULL,
    [front_vol] [float] NULL,
    [back_vol] [float] NULL,
    [weighted_back_vol] [float] NULL,
    [vol_diff] [float] NULL,
    [put_call_ratio] [float] NULL,
    [call_volume_index] [float] NULL,
    [put_volume_index] [float] NULL,
    [option_volume_index] [float] NULL,
    [front_expected_move] [float] NULL,
    [back_expected_move] [float] NULL,
    [expected_move_diff] [float] NULL,
    [beta] [float] NULL,
    [high52] [smallmoney] NULL,
    [low52] [smallmoney] NULL,
    [pe] [float] NULL,
    [eps] [float] NULL,
    [market_cap] [nvarchar](255) NULL,
    [shares] [bigint] NULL,
    [dividend_yield] [float] NULL,
    [dividend_share] [float] NULL,
  CONSTRAINT [pk_tos_stock_quotes_ticks_rtd] PRIMARY KEY ([id])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'SELECT symbol FROM rtd.tos_stock_list', 1, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'id');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'symbol');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'time', '=Time()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'last', '=RTD("tos.rtd",,"LAST",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'last_x', '=RTD("tos.rtd",,"LX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'mark', '=RTD("tos.rtd",,"MARK",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid', '=RTD("tos.rtd",,"BID",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'ask', '=RTD("tos.rtd",,"ASK",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid_x', '=RTD("tos.rtd",,"BX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'ask_x', '=RTD("tos.rtd",,"AX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'open', '=RTD("tos.rtd",,"OPEN",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'high', '=RTD("tos.rtd",,"HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'low', '=RTD("tos.rtd",,"LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'close', '=RTD("tos.rtd",,"CLOSE",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'volume', '=RTD("tos.rtd",,"VOLUME",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'beta', '=RTD("tos.rtd",,"BETA",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'high52', '=RTD("tos.rtd",,"52HIGH",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'low52', '=RTD("tos.rtd",,"52LOW",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'pe', '=RTD("tos.rtd",,"PE",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'eps', '=RTD("tos.rtd",,"EPS",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'shares', '=RTD("tos.rtd",,"SHARES",[symbol])', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[symbol])', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'dividend_share', '=RTD("tos.rtd",,"DIV",[symbol])', NULL);

