CREATE TABLE [rtd].[tos_stock_quotes_ticks] (
    [id] [bigint] IDENTITY(1,1) NOT NULL,
    [symbol] [varchar](50) NULL,
    [datetime] [datetime] NULL,
    [date] [date] NULL,
    [time] [time](0) NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [int] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [int] NULL,
    [ask_size] [int] NULL,
    [bid_ask_size] [nvarchar](255) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [strength_meter] [nvarchar](255) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [bigint] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [vol_index] [float] NULL,
    [front_vol] [float] NULL,
    [back_vol] [float] NULL,
    [weighted_back_vol] [float] NULL,
    [vol_diff] [float] NULL,
    [put_call_ratio] [float] NULL,
    [call_volume_index] [float] NULL,
    [put_volume_index] [float] NULL,
    [option_volume_index] [float] NULL,
    [front_expected_move] [float] NULL,
    [back_expected_move] [float] NULL,
    [expected_move_diff] [float] NULL,
    [beta] [float] NULL,
    [high52] [smallmoney] NULL,
    [low52] [smallmoney] NULL,
    [pe] [float] NULL,
    [eps] [float] NULL,
    [market_cap] [nvarchar](255) NULL,
    [shares] [bigint] NULL,
    [dividend_yield] [float] NULL,
    [dividend_share] [float] NULL,
  CONSTRAINT [pk_tos_stock_quotes_ticks_rtd] PRIMARY KEY ([id])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'SELECT symbol FROM rtd.tos_stock_list', 1, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'id');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'symbol');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'time', '=Time()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'description', '=TOS|DESCRIPTION![symbol]', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'last', '=TOS|LAST![symbol]', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'change', '=TOS|NET_CHANGE![symbol]', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'percent_change', '=TOS|PERCENT_CHANGE![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'last_size', '=TOS|LAST_SIZE![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'last_x', '=TOS|LX![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'mark', '=TOS|MARK![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'mark_change', '=TOS|MARK_CHANGE![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid', '=TOS|BID![symbol]', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'ask', '=TOS|ASK![symbol]', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid_size', '=TOS|BID_SIZE![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'ask_size', '=TOS|ASK_SIZE![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid_ask_size', '=TOS|BA_SIZE![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid_x', '=TOS|BX![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'ask_x', '=TOS|AX![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'strength_meter', '=TOS|STRENGTH_METER![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'open', '=TOS|OPEN![symbol]', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'high', '=TOS|HIGH![symbol]', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'low', '=TOS|LOW![symbol]', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'close', '=TOS|CLOSE![symbol]', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'volume', '=TOS|VOLUME![symbol]', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'open_int', '=TOS|OPEN_INT![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'implied_vol', '=TOS|IMPL_VOL![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'vol_index', '=TOS|VOL_INDEX![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'front_vol', '=TOS|FRONT_VOL![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'back_vol', '=TOS|BACK_VOL![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'vol_diff', '=TOS|VOL_DIFF![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'front_expected_move', '=TOS|FRONT_EX_MOVE![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'back_expected_move', '=TOS|BACK_EX_MOVE![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'beta', '=TOS|BETA![symbol]', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'high52', '=TOS|''52HIGH''![symbol]', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'low52', '=TOS|''52LOW''![symbol]', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'pe', '=TOS|PE![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'eps', '=TOS|EPS![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'market_cap', '=TOS|MARKET_CAP![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'shares', '=TOS|SHARES![symbol]', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'dividend_yield', '=TOS|YIELD![symbol]', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_stock_quotes_ticks', 'dividend_share', '=TOS|DIV![symbol]', NULL);

