CREATE TABLE [rtd].[tos_option_data_ticks] (
    [id] [int] IDENTITY(1,1) NOT NULL,
    [code] [varchar](50) NULL,
    [datetime] [datetime] NULL,
    [date] [date] NULL,
    [time] [time](0) NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [smallint] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [smallint] NULL,
    [ask_size] [smallint] NULL,
    [bid_ask_size] [varchar](50) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [int] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [delta] [float] NULL,
    [gamma] [float] NULL,
    [theta] [float] NULL,
    [vega] [float] NULL,
    [rho] [float] NULL,
    [extrinsic] [smallmoney] NULL,
    [intrinsic] [smallmoney] NULL,
    [probability_itm] [float] NULL,
    [probability_otm] [float] NULL,
    [probability_touch] [float] NULL,
    [covered_return] [float] NULL,
    [max_covered_return] [float] NULL,
  CONSTRAINT [pk_tos_option_data_ticks_rtd] PRIMARY KEY ([id])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_option_data_ticks', 'SELECT code FROM rtd.tos_option_list', 1, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_option_data_ticks', 'id');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_option_data_ticks', 'code');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'time', '=Time()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'description', '=TOS|DESCRIPTION!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'last', '=TOS|LAST!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'change', '=TOS|NET_CHANGE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'percent_change', '=TOS|PERCENT_CHANGE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'last_size', '=TOS|LAST_SIZE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'last_x', '=TOS|LX!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'mark', '=TOS|MARK!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'mark_change', '=TOS|MARK_CHANGE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'bid', '=TOS|BID!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'ask', '=TOS|ASK!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'bid_size', '=TOS|BID_SIZE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'ask_size', '=TOS|ASK_SIZE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'bid_ask_size', '=TOS|BA_SIZE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'bid_x', '=TOS|BX!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'ask_x', '=TOS|AX!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'open', '=TOS|OPEN!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'high', '=TOS|HIGH!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'low', '=TOS|LOW!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'close', '=TOS|Close!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'volume', '=TOS|VOLUME!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'open_int', '=TOS|OPEN_INT!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'implied_vol', '=TOS|IMPL_VOL!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'delta', '=TOS|DELTA!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'gamma', '=TOS|GAMMA!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'theta', '=TOS|THETA!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'vega', '=TOS|VEGA!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'rho', '=TOS|RHO!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'extrinsic', '=TOS|EXTRINSIC!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'intrinsic', '=TOS|INTRINSIC!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'probability_otm', '=TOS|PROB_OTM!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'covered_return', '=TOS|COVERED_RETURN!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_ticks', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[code]''', 1);

