CREATE TABLE [rtd].[tos_option_data_15m] (
    [code] [varchar](50) NOT NULL,
    [datetime] [datetime] NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NOT NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [smallint] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [smallint] NULL,
    [ask_size] [smallint] NULL,
    [bid_ask_size] [varchar](50) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [int] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [delta] [float] NULL,
    [gamma] [float] NULL,
    [theta] [float] NULL,
    [vega] [float] NULL,
    [rho] [float] NULL,
    [extrinsic] [smallmoney] NULL,
    [intrinsic] [smallmoney] NULL,
    [probability_itm] [float] NULL,
    [probability_otm] [float] NULL,
    [probability_touch] [float] NULL,
    [covered_return] [float] NULL,
    [max_covered_return] [float] NULL,
    [last_update_timestamp] [timestamp] NULL,
  CONSTRAINT [pk_tos_option_data_15m_rtd] PRIMARY KEY ([code], [date], [time])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_option_data_15m', 'SELECT code FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_option_data_15m', 'code');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'datetime', '=DateTime()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'time', '=Time15()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'description', '=TOS|DESCRIPTION!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'last', '=TOS|LAST!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'change', '=TOS|NET_CHANGE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'percent_change', '=TOS|PERCENT_CHANGE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'last_size', '=TOS|LAST_SIZE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'last_x', '=TOS|LX!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'mark', '=TOS|MARK!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'mark_change', '=TOS|MARK_CHANGE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'bid', '=TOS|BID!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'ask', '=TOS|ASK!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'bid_size', '=TOS|BID_SIZE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'ask_size', '=TOS|ASK_SIZE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'bid_ask_size', '=TOS|BA_SIZE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'bid_x', '=TOS|BX!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'ask_x', '=TOS|AX!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'open', '=TOS|OPEN!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'high', '=TOS|HIGH!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'low', '=TOS|LOW!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'close', '=TOS|Close!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'volume', '=TOS|VOLUME!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'open_int', '=TOS|OPEN_INT!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'implied_vol', '=TOS|IMPL_VOL!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'delta', '=TOS|DELTA!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'gamma', '=TOS|GAMMA!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'theta', '=TOS|THETA!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'vega', '=TOS|VEGA!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'rho', '=TOS|RHO!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'extrinsic', '=TOS|EXTRINSIC!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'intrinsic', '=TOS|INTRINSIC!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'probability_otm', '=TOS|PROB_OTM!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'covered_return', '=TOS|COVERED_RETURN!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_option_data_15m', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[code]''', 1);

