CREATE TABLE [rtd].[tos_historical_option_data] (
    [code] [varchar](50) NOT NULL,
    [date] [date] NOT NULL,
    [time] [time](0) NULL,
    [description] [nvarchar](255) NULL,
    [last] [smallmoney] NULL,
    [change] [smallmoney] NULL,
    [percent_change] [float] NULL,
    [last_size] [smallint] NULL,
    [last_x] [char](1) NULL,
    [mark] [smallmoney] NULL,
    [mark_change] [smallmoney] NULL,
    [mark_percent_change] [float] NULL,
    [bid] [smallmoney] NULL,
    [ask] [smallmoney] NULL,
    [bid_size] [smallint] NULL,
    [ask_size] [smallint] NULL,
    [bid_ask_size] [varchar](50) NULL,
    [bid_x] [char](1) NULL,
    [ask_x] [char](1) NULL,
    [open] [smallmoney] NULL,
    [high] [smallmoney] NULL,
    [low] [smallmoney] NULL,
    [close] [smallmoney] NULL,
    [volume] [int] NULL,
    [open_int] [int] NULL,
    [implied_vol] [float] NULL,
    [delta] [float] NULL,
    [gamma] [float] NULL,
    [theta] [float] NULL,
    [vega] [float] NULL,
    [rho] [float] NULL,
    [extrinsic] [smallmoney] NULL,
    [intrinsic] [smallmoney] NULL,
    [probability_itm] [float] NULL,
    [probability_otm] [float] NULL,
    [probability_touch] [float] NULL,
    [covered_return] [float] NULL,
    [max_covered_return] [float] NULL,
    [last_update_timestamp] [timestamp] NULL,
  CONSTRAINT [pk_tos_historical_option_data_rtd] PRIMARY KEY ([code], [date])
);

INSERT INTO [rtd].[real_time_tables] ([table_schema], [table_name], [load_code], [is_history], [is_disabled], [time_zone], [rtd_instance_name]) VALUES ('rtd', 'tos_historical_option_data', 'SELECT code FROM rtd.tos_option_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name]) VALUES ('rtd', 'tos_historical_option_data', 'code');
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'date', '=Date()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'time', '=Time()', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'description', '=TOS|DESCRIPTION!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'last', '=TOS|LAST!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'change', '=TOS|NET_CHANGE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'percent_change', '=TOS|PERCENT_CHANGE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'last_size', '=TOS|LAST_SIZE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'last_x', '=TOS|LX!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'mark', '=TOS|MARK!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'mark_change', '=TOS|MARK_CHANGE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'bid', '=TOS|BID!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'ask', '=TOS|ASK!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'bid_size', '=TOS|BID_SIZE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'ask_size', '=TOS|ASK_SIZE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'bid_ask_size', '=TOS|BA_SIZE!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'bid_x', '=TOS|BX!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'ask_x', '=TOS|AX!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'open', '=TOS|OPEN!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'high', '=TOS|HIGH!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'low', '=TOS|LOW!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'close', '=TOS|Close!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'volume', '=TOS|VOLUME!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'open_int', '=TOS|OPEN_INT!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'implied_vol', '=TOS|IMPL_VOL!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'delta', '=TOS|DELTA!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'gamma', '=TOS|GAMMA!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'theta', '=TOS|THETA!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'vega', '=TOS|VEGA!''[code]''', NULL);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'rho', '=TOS|RHO!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'extrinsic', '=TOS|EXTRINSIC!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'intrinsic', '=TOS|INTRINSIC!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'probability_otm', '=TOS|PROB_OTM!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'covered_return', '=TOS|COVERED_RETURN!''[code]''', 1);
INSERT INTO [rtd].[real_time_formulas] ([table_schema], [table_name], [column_name], [rtd_formula], [is_disabled]) VALUES ('rtd', 'tos_historical_option_data', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[code]''', 1);

