IF SCHEMA_ID('rtd') IS NULL
EXEC('CREATE SCHEMA [rtd]');

IF OBJECT_ID('[rtd].[real_time_formulas]') IS NULL
CREATE TABLE [rtd].[real_time_formulas] (
    [id] [int] IDENTITY(1,1) NOT NULL,
    [table_schema] [nvarchar](128) NOT NULL,
    [table_name] [nvarchar](128) NOT NULL,
    [column_name] [nvarchar](128) NOT NULL,
    [rtd_formula] [nvarchar](255) NULL,
    [is_disabled] [tinyint] NULL,
  CONSTRAINT [pk_real_time_formulas_rtd] PRIMARY KEY ([id]),
  CONSTRAINT [ix_real_time_formulas_schema_name_columnname_rtd] UNIQUE ([table_schema], [table_name], [column_name])
);

IF OBJECT_ID('[rtd].[real_time_tables]') IS NULL
CREATE TABLE [rtd].[real_time_tables] (
    [id] [int] IDENTITY(1,1) NOT NULL,
    [table_schema] [nvarchar](128) NOT NULL,
    [table_name] [nvarchar](128) NOT NULL,
    [load_code] [nvarchar](2000) NULL,
    [is_history] [tinyint] NULL,
    [is_disabled] [tinyint] NULL,
    [time_zone] [nvarchar](50) NULL,
    [rtd_instance_name] [nvarchar](50) NULL,
  CONSTRAINT [pk_real_time_tables_rtd] PRIMARY KEY ([id]),
  CONSTRAINT [ix_real_time_tables_schema_name_rtd] UNIQUE ([table_schema], [table_name])
);

