CREATE TABLE IF NOT EXISTS tos_option_data_s (
    code varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size smallint NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size smallint NULL,
    ask_size smallint NULL,
    bid_ask_size varchar(50) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume integer NULL,
    open_int integer NULL,
    implied_vol double NULL,
    delta double NULL,
    gamma double NULL,
    theta double NULL,
    vega double NULL,
    rho double NULL,
    extrinsic double NULL,
    intrinsic double NULL,
    probability_itm double NULL,
    probability_otm double NULL,
    probability_touch double NULL,
    covered_return double NULL,
    max_covered_return double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (code, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_option_data_s', 'SELECT code FROM tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_option_data_s', 'code');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'time', '=Time0()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'last', '=RTD("tos.rtd",,"LAST",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'last_x', '=RTD("tos.rtd",,"LX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'mark', '=RTD("tos.rtd",,"MARK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'bid', '=RTD("tos.rtd",,"BID",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'ask', '=RTD("tos.rtd",,"ASK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'bid_x', '=RTD("tos.rtd",,"BX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'ask_x', '=RTD("tos.rtd",,"AX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'open', '=RTD("tos.rtd",,"OPEN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'high', '=RTD("tos.rtd",,"HIGH",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'low', '=RTD("tos.rtd",,"LOW",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'close', '=RTD("tos.rtd",,"CLOSE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'volume', '=RTD("tos.rtd",,"VOLUME",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'delta', '=RTD("tos.rtd",,"DELTA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'gamma', '=RTD("tos.rtd",,"GAMMA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'theta', '=RTD("tos.rtd",,"THETA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'vega', '=RTD("tos.rtd",,"VEGA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'rho', '=RTD("tos.rtd",,"RHO",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[CODE])', 1);

