CREATE TABLE IF NOT EXISTS tos_historical_option_data (
    code varchar(50) NOT NULL,
    date date NOT NULL,
    time time NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size smallint NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size smallint NULL,
    ask_size smallint NULL,
    bid_ask_size varchar(50) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume integer NULL,
    open_int integer NULL,
    implied_vol double NULL,
    delta double NULL,
    gamma double NULL,
    theta double NULL,
    vega double NULL,
    rho double NULL,
    extrinsic double NULL,
    intrinsic double NULL,
    probability_itm double NULL,
    probability_otm double NULL,
    probability_touch double NULL,
    covered_return double NULL,
    max_covered_return double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (code, date)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_historical_option_data', 'SELECT code FROM tos_option_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_historical_option_data', 'code');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'time', '=Time()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'last', '=RTD("tos.rtd",,"LAST",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'last_x', '=RTD("tos.rtd",,"LX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'mark', '=RTD("tos.rtd",,"MARK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'bid', '=RTD("tos.rtd",,"BID",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'ask', '=RTD("tos.rtd",,"ASK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'bid_x', '=RTD("tos.rtd",,"BX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'ask_x', '=RTD("tos.rtd",,"AX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'open', '=RTD("tos.rtd",,"OPEN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'high', '=RTD("tos.rtd",,"HIGH",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'low', '=RTD("tos.rtd",,"LOW",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'close', '=RTD("tos.rtd",,"CLOSE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'volume', '=RTD("tos.rtd",,"VOLUME",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'delta', '=RTD("tos.rtd",,"DELTA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'gamma', '=RTD("tos.rtd",,"GAMMA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'theta', '=RTD("tos.rtd",,"THETA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'vega', '=RTD("tos.rtd",,"VEGA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'rho', '=RTD("tos.rtd",,"RHO",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[CODE])', 1);

