CREATE TABLE IF NOT EXISTS real_time_formulas (
    id integer NOT NULL PRIMARY KEY AUTOINCREMENT,
    table_schema varchar(128) NULL,
    table_name varchar(128) NOT NULL,
    column_name varchar(128) NOT NULL,
    rtd_formula varchar(255) NULL,
    is_disabled smallint NULL
);

CREATE UNIQUE INDEX ix_real_time_formulas_schema_name_column_name ON real_time_formulas (table_name, column_name);


CREATE TABLE IF NOT EXISTS real_time_tables (
    id integer NOT NULL PRIMARY KEY AUTOINCREMENT,
    table_schema varchar(128) NULL,
    table_name varchar(128) NOT NULL,
    load_code varchar(2000) NULL,
    is_history smallint NULL,
    is_disabled smallint NULL,
    time_zone varchar(50) NULL,
    rtd_instance_name varchar(50) NULL
);

CREATE UNIQUE INDEX ix_realtimetables_schema_name ON real_time_tables (table_name);

CREATE TABLE IF NOT EXISTS tos_stock_list (
    symbol varchar(50) NOT NULL,
  PRIMARY KEY (symbol)
);

INSERT INTO [tos_stock_list] ([symbol]) VALUES ('SPY');

CREATE TABLE IF NOT EXISTS tos_option_list (
    code varchar(50) NOT NULL,
  PRIMARY KEY (code)
);


CREATE TABLE IF NOT EXISTS tos_historical_option_data (
    code varchar(50) NOT NULL,
    date date NOT NULL,
    time time NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size smallint NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size smallint NULL,
    ask_size smallint NULL,
    bid_ask_size varchar(50) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume integer NULL,
    open_int integer NULL,
    implied_vol double NULL,
    delta double NULL,
    gamma double NULL,
    theta double NULL,
    vega double NULL,
    rho double NULL,
    extrinsic double NULL,
    intrinsic double NULL,
    probability_itm double NULL,
    probability_otm double NULL,
    probability_touch double NULL,
    covered_return double NULL,
    max_covered_return double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (code, date)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_historical_option_data', 'SELECT code FROM tos_option_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_historical_option_data', 'code');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'time', '=Time()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'last', '=RTD("tos.rtd",,"LAST",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'last_x', '=RTD("tos.rtd",,"LX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'mark', '=RTD("tos.rtd",,"MARK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'bid', '=RTD("tos.rtd",,"BID",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'ask', '=RTD("tos.rtd",,"ASK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'bid_x', '=RTD("tos.rtd",,"BX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'ask_x', '=RTD("tos.rtd",,"AX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'open', '=RTD("tos.rtd",,"OPEN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'high', '=RTD("tos.rtd",,"HIGH",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'low', '=RTD("tos.rtd",,"LOW",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'close', '=RTD("tos.rtd",,"CLOSE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'volume', '=RTD("tos.rtd",,"VOLUME",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'delta', '=RTD("tos.rtd",,"DELTA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'gamma', '=RTD("tos.rtd",,"GAMMA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'theta', '=RTD("tos.rtd",,"THETA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'vega', '=RTD("tos.rtd",,"VEGA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'rho', '=RTD("tos.rtd",,"RHO",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_option_data', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[CODE])', 1);

CREATE TABLE IF NOT EXISTS tos_historical_prices (
    symbol varchar(50) NOT NULL,
    date date NOT NULL,
    time time NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size integer NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size integer NULL,
    ask_size integer NULL,
    bid_ask_size varchar(255) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    strength_meter varchar(255) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume bigint NULL,
    open_int integer NULL,
    implied_vol double NULL,
    vol_index double NULL,
    front_vol double NULL,
    back_vol double NULL,
    weighted_back_vol double NULL,
    vol_diff double NULL,
    put_call_ratio double NULL,
    call_volume_index double NULL,
    put_volume_index double NULL,
    option_volume_index double NULL,
    front_expected_move double NULL,
    back_expected_move double NULL,
    expected_move_diff double NULL,
    beta double NULL,
    high52 double NULL,
    low52 double NULL,
    pe double NULL,
    eps double NULL,
    market_cap varchar(255) NULL,
    shares bigint NULL,
    dividend_yield double NULL,
    dividend_share double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (symbol, date)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_historical_prices', 'SELECT symbol FROM tos_stock_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_historical_prices', 'symbol');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'time', '=Time()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'last', '=RTD("tos.rtd",,"LAST",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'last_x', '=RTD("tos.rtd",,"LX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'mark', '=RTD("tos.rtd",,"MARK",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'bid', '=RTD("tos.rtd",,"BID",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'ask', '=RTD("tos.rtd",,"ASK",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'bid_x', '=RTD("tos.rtd",,"BX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'ask_x', '=RTD("tos.rtd",,"AX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'open', '=RTD("tos.rtd",,"OPEN",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'high', '=RTD("tos.rtd",,"HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'low', '=RTD("tos.rtd",,"LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'close', '=RTD("tos.rtd",,"CLOSE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'volume', '=RTD("tos.rtd",,"VOLUME",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'beta', '=RTD("tos.rtd",,"BETA",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'high52', '=RTD("tos.rtd",,"52HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'low52', '=RTD("tos.rtd",,"52LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'pe', '=RTD("tos.rtd",,"PE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'eps', '=RTD("tos.rtd",,"EPS",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'shares', '=RTD("tos.rtd",,"SHARES",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'dividend_share', '=RTD("tos.rtd",,"DIV",[SYMBOL])', NULL);

CREATE TABLE IF NOT EXISTS tos_last_option_data (
    code varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NULL,
    time time NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size smallint NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size smallint NULL,
    ask_size smallint NULL,
    bid_ask_size varchar(50) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume integer NULL,
    open_int integer NULL,
    implied_vol double NULL,
    delta double NULL,
    gamma double NULL,
    theta double NULL,
    vega double NULL,
    rho double NULL,
    extrinsic double NULL,
    intrinsic double NULL,
    probability_itm double NULL,
    probability_otm double NULL,
    probability_touch double NULL,
    covered_return double NULL,
    max_covered_return double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (code)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_last_option_data', 'SELECT code FROM tos_option_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_last_option_data', 'code');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'time', '=Time()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'last', '=RTD("tos.rtd",,"LAST",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'last_x', '=RTD("tos.rtd",,"LX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'mark', '=RTD("tos.rtd",,"MARK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'bid', '=RTD("tos.rtd",,"BID",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'ask', '=RTD("tos.rtd",,"ASK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'bid_x', '=RTD("tos.rtd",,"BX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'ask_x', '=RTD("tos.rtd",,"AX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'open', '=RTD("tos.rtd",,"OPEN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'high', '=RTD("tos.rtd",,"HIGH",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'low', '=RTD("tos.rtd",,"LOW",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'close', '=RTD("tos.rtd",,"CLOSE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'volume', '=RTD("tos.rtd",,"VOLUME",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'delta', '=RTD("tos.rtd",,"DELTA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'gamma', '=RTD("tos.rtd",,"GAMMA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'theta', '=RTD("tos.rtd",,"THETA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'vega', '=RTD("tos.rtd",,"VEGA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'rho', '=RTD("tos.rtd",,"RHO",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_option_data', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[CODE])', 1);

CREATE TABLE IF NOT EXISTS tos_last_stock_quotes (
    symbol varchar(50) NOT NULL,
    datetime timestamp NOT NULL,
    date date NULL,
    time time NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size integer NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size integer NULL,
    ask_size integer NULL,
    bid_ask_size varchar(255) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    strength_meter varchar(255) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume bigint NULL,
    open_int integer NULL,
    implied_vol double NULL,
    vol_index double NULL,
    front_vol double NULL,
    back_vol double NULL,
    weighted_back_vol double NULL,
    vol_diff double NULL,
    put_call_ratio double NULL,
    call_volume_index double NULL,
    put_volume_index double NULL,
    option_volume_index double NULL,
    front_expected_move double NULL,
    back_expected_move double NULL,
    expected_move_diff double NULL,
    beta double NULL,
    high52 double NULL,
    low52 double NULL,
    pe double NULL,
    eps double NULL,
    market_cap varchar(255) NULL,
    shares bigint NULL,
    dividend_yield double NULL,
    dividend_share double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (symbol)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_last_stock_quotes', 'SELECT symbol FROM tos_stock_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_last_stock_quotes', 'symbol');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'time', '=Time()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'last', '=RTD("tos.rtd",,"LAST",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'last_x', '=RTD("tos.rtd",,"LX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'mark', '=RTD("tos.rtd",,"MARK",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'bid', '=RTD("tos.rtd",,"BID",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'ask', '=RTD("tos.rtd",,"ASK",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'bid_x', '=RTD("tos.rtd",,"BX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'ask_x', '=RTD("tos.rtd",,"AX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'open', '=RTD("tos.rtd",,"OPEN",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'high', '=RTD("tos.rtd",,"HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'low', '=RTD("tos.rtd",,"LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'close', '=RTD("tos.rtd",,"CLOSE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'volume', '=RTD("tos.rtd",,"VOLUME",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'beta', '=RTD("tos.rtd",,"BETA",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'high52', '=RTD("tos.rtd",,"52HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'low52', '=RTD("tos.rtd",,"52LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'pe', '=RTD("tos.rtd",,"PE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'eps', '=RTD("tos.rtd",,"EPS",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'shares', '=RTD("tos.rtd",,"SHARES",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_last_stock_quotes', 'dividend_share', '=RTD("tos.rtd",,"DIV",[SYMBOL])', NULL);

CREATE TABLE IF NOT EXISTS tos_option_data_01m (
    code varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size smallint NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size smallint NULL,
    ask_size smallint NULL,
    bid_ask_size varchar(50) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume integer NULL,
    open_int integer NULL,
    implied_vol double NULL,
    delta double NULL,
    gamma double NULL,
    theta double NULL,
    vega double NULL,
    rho double NULL,
    extrinsic double NULL,
    intrinsic double NULL,
    probability_itm double NULL,
    probability_otm double NULL,
    probability_touch double NULL,
    covered_return double NULL,
    max_covered_return double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (code, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_option_data_01m', 'SELECT code FROM tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_option_data_01m', 'code');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'time', '=Time1()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'last', '=RTD("tos.rtd",,"LAST",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'last_x', '=RTD("tos.rtd",,"LX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'mark', '=RTD("tos.rtd",,"MARK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'bid', '=RTD("tos.rtd",,"BID",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'ask', '=RTD("tos.rtd",,"ASK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'bid_x', '=RTD("tos.rtd",,"BX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'ask_x', '=RTD("tos.rtd",,"AX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'open', '=RTD("tos.rtd",,"OPEN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'high', '=RTD("tos.rtd",,"HIGH",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'low', '=RTD("tos.rtd",,"LOW",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'close', '=RTD("tos.rtd",,"CLOSE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'volume', '=RTD("tos.rtd",,"VOLUME",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'delta', '=RTD("tos.rtd",,"DELTA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'gamma', '=RTD("tos.rtd",,"GAMMA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'theta', '=RTD("tos.rtd",,"THETA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'vega', '=RTD("tos.rtd",,"VEGA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'rho', '=RTD("tos.rtd",,"RHO",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_01m', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[CODE])', 1);

CREATE TABLE IF NOT EXISTS tos_option_data_05m (
    code varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size smallint NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size smallint NULL,
    ask_size smallint NULL,
    bid_ask_size varchar(50) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume integer NULL,
    open_int integer NULL,
    implied_vol double NULL,
    delta double NULL,
    gamma double NULL,
    theta double NULL,
    vega double NULL,
    rho double NULL,
    extrinsic double NULL,
    intrinsic double NULL,
    probability_itm double NULL,
    probability_otm double NULL,
    probability_touch double NULL,
    covered_return double NULL,
    max_covered_return double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (code, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_option_data_05m', 'SELECT code FROM tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_option_data_05m', 'code');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'time', '=Time5()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'last', '=RTD("tos.rtd",,"LAST",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'last_x', '=RTD("tos.rtd",,"LX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'mark', '=RTD("tos.rtd",,"MARK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'bid', '=RTD("tos.rtd",,"BID",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'ask', '=RTD("tos.rtd",,"ASK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'bid_x', '=RTD("tos.rtd",,"BX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'ask_x', '=RTD("tos.rtd",,"AX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'open', '=RTD("tos.rtd",,"OPEN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'high', '=RTD("tos.rtd",,"HIGH",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'low', '=RTD("tos.rtd",,"LOW",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'close', '=RTD("tos.rtd",,"CLOSE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'volume', '=RTD("tos.rtd",,"VOLUME",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'delta', '=RTD("tos.rtd",,"DELTA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'gamma', '=RTD("tos.rtd",,"GAMMA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'theta', '=RTD("tos.rtd",,"THETA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'vega', '=RTD("tos.rtd",,"VEGA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'rho', '=RTD("tos.rtd",,"RHO",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_05m', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[CODE])', 1);

CREATE TABLE IF NOT EXISTS tos_option_data_10m (
    code varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size smallint NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size smallint NULL,
    ask_size smallint NULL,
    bid_ask_size varchar(50) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume integer NULL,
    open_int integer NULL,
    implied_vol double NULL,
    delta double NULL,
    gamma double NULL,
    theta double NULL,
    vega double NULL,
    rho double NULL,
    extrinsic double NULL,
    intrinsic double NULL,
    probability_itm double NULL,
    probability_otm double NULL,
    probability_touch double NULL,
    covered_return double NULL,
    max_covered_return double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (code, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_option_data_10m', 'SELECT code FROM tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_option_data_10m', 'code');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'time', '=Time10()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'last', '=RTD("tos.rtd",,"LAST",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'last_x', '=RTD("tos.rtd",,"LX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'mark', '=RTD("tos.rtd",,"MARK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'bid', '=RTD("tos.rtd",,"BID",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'ask', '=RTD("tos.rtd",,"ASK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'bid_x', '=RTD("tos.rtd",,"BX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'ask_x', '=RTD("tos.rtd",,"AX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'open', '=RTD("tos.rtd",,"OPEN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'high', '=RTD("tos.rtd",,"HIGH",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'low', '=RTD("tos.rtd",,"LOW",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'close', '=RTD("tos.rtd",,"CLOSE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'volume', '=RTD("tos.rtd",,"VOLUME",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'delta', '=RTD("tos.rtd",,"DELTA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'gamma', '=RTD("tos.rtd",,"GAMMA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'theta', '=RTD("tos.rtd",,"THETA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'vega', '=RTD("tos.rtd",,"VEGA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'rho', '=RTD("tos.rtd",,"RHO",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[CODE])', 1);

CREATE TABLE IF NOT EXISTS tos_option_data_15m (
    code varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size smallint NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size smallint NULL,
    ask_size smallint NULL,
    bid_ask_size varchar(50) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume integer NULL,
    open_int integer NULL,
    implied_vol double NULL,
    delta double NULL,
    gamma double NULL,
    theta double NULL,
    vega double NULL,
    rho double NULL,
    extrinsic double NULL,
    intrinsic double NULL,
    probability_itm double NULL,
    probability_otm double NULL,
    probability_touch double NULL,
    covered_return double NULL,
    max_covered_return double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (code, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_option_data_15m', 'SELECT code FROM tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_option_data_15m', 'code');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'time', '=Time15()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'last', '=RTD("tos.rtd",,"LAST",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'last_x', '=RTD("tos.rtd",,"LX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'mark', '=RTD("tos.rtd",,"MARK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'bid', '=RTD("tos.rtd",,"BID",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'ask', '=RTD("tos.rtd",,"ASK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'bid_x', '=RTD("tos.rtd",,"BX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'ask_x', '=RTD("tos.rtd",,"AX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'open', '=RTD("tos.rtd",,"OPEN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'high', '=RTD("tos.rtd",,"HIGH",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'low', '=RTD("tos.rtd",,"LOW",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'close', '=RTD("tos.rtd",,"CLOSE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'volume', '=RTD("tos.rtd",,"VOLUME",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'delta', '=RTD("tos.rtd",,"DELTA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'gamma', '=RTD("tos.rtd",,"GAMMA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'theta', '=RTD("tos.rtd",,"THETA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'vega', '=RTD("tos.rtd",,"VEGA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'rho', '=RTD("tos.rtd",,"RHO",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_15m', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[CODE])', 1);

CREATE TABLE IF NOT EXISTS tos_option_data_20m (
    code varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size smallint NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size smallint NULL,
    ask_size smallint NULL,
    bid_ask_size varchar(50) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume integer NULL,
    open_int integer NULL,
    implied_vol double NULL,
    delta double NULL,
    gamma double NULL,
    theta double NULL,
    vega double NULL,
    rho double NULL,
    extrinsic double NULL,
    intrinsic double NULL,
    probability_itm double NULL,
    probability_otm double NULL,
    probability_touch double NULL,
    covered_return double NULL,
    max_covered_return double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (code, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_option_data_20m', 'SELECT code FROM tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_option_data_20m', 'code');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'time', '=Time20()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'last', '=RTD("tos.rtd",,"LAST",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'last_x', '=RTD("tos.rtd",,"LX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'mark', '=RTD("tos.rtd",,"MARK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'bid', '=RTD("tos.rtd",,"BID",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'ask', '=RTD("tos.rtd",,"ASK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'bid_x', '=RTD("tos.rtd",,"BX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'ask_x', '=RTD("tos.rtd",,"AX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'open', '=RTD("tos.rtd",,"OPEN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'high', '=RTD("tos.rtd",,"HIGH",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'low', '=RTD("tos.rtd",,"LOW",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'close', '=RTD("tos.rtd",,"CLOSE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'volume', '=RTD("tos.rtd",,"VOLUME",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'delta', '=RTD("tos.rtd",,"DELTA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'gamma', '=RTD("tos.rtd",,"GAMMA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'theta', '=RTD("tos.rtd",,"THETA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'vega', '=RTD("tos.rtd",,"VEGA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'rho', '=RTD("tos.rtd",,"RHO",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_20m', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[CODE])', 1);

CREATE TABLE IF NOT EXISTS tos_option_data_30m (
    code varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size smallint NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size smallint NULL,
    ask_size smallint NULL,
    bid_ask_size varchar(50) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume integer NULL,
    open_int integer NULL,
    implied_vol double NULL,
    delta double NULL,
    gamma double NULL,
    theta double NULL,
    vega double NULL,
    rho double NULL,
    extrinsic double NULL,
    intrinsic double NULL,
    probability_itm double NULL,
    probability_otm double NULL,
    probability_touch double NULL,
    covered_return double NULL,
    max_covered_return double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (code, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_option_data_30m', 'SELECT code FROM tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_option_data_30m', 'code');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'time', '=Time30()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'last', '=RTD("tos.rtd",,"LAST",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'last_x', '=RTD("tos.rtd",,"LX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'mark', '=RTD("tos.rtd",,"MARK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'bid', '=RTD("tos.rtd",,"BID",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'ask', '=RTD("tos.rtd",,"ASK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'bid_x', '=RTD("tos.rtd",,"BX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'ask_x', '=RTD("tos.rtd",,"AX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'open', '=RTD("tos.rtd",,"OPEN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'high', '=RTD("tos.rtd",,"HIGH",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'low', '=RTD("tos.rtd",,"LOW",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'close', '=RTD("tos.rtd",,"CLOSE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'volume', '=RTD("tos.rtd",,"VOLUME",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'delta', '=RTD("tos.rtd",,"DELTA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'gamma', '=RTD("tos.rtd",,"GAMMA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'theta', '=RTD("tos.rtd",,"THETA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'vega', '=RTD("tos.rtd",,"VEGA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'rho', '=RTD("tos.rtd",,"RHO",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_30m', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[CODE])', 1);

CREATE TABLE IF NOT EXISTS tos_option_data_60m (
    code varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size smallint NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size smallint NULL,
    ask_size smallint NULL,
    bid_ask_size varchar(50) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume integer NULL,
    open_int integer NULL,
    implied_vol double NULL,
    delta double NULL,
    gamma double NULL,
    theta double NULL,
    vega double NULL,
    rho double NULL,
    extrinsic double NULL,
    intrinsic double NULL,
    probability_itm double NULL,
    probability_otm double NULL,
    probability_touch double NULL,
    covered_return double NULL,
    max_covered_return double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (code, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_option_data_60m', 'SELECT code FROM tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_option_data_60m', 'code');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'time', '=Time60()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'last', '=RTD("tos.rtd",,"LAST",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'last_x', '=RTD("tos.rtd",,"LX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'mark', '=RTD("tos.rtd",,"MARK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'bid', '=RTD("tos.rtd",,"BID",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'ask', '=RTD("tos.rtd",,"ASK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'bid_x', '=RTD("tos.rtd",,"BX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'ask_x', '=RTD("tos.rtd",,"AX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'open', '=RTD("tos.rtd",,"OPEN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'high', '=RTD("tos.rtd",,"HIGH",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'low', '=RTD("tos.rtd",,"LOW",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'close', '=RTD("tos.rtd",,"CLOSE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'volume', '=RTD("tos.rtd",,"VOLUME",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'delta', '=RTD("tos.rtd",,"DELTA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'gamma', '=RTD("tos.rtd",,"GAMMA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'theta', '=RTD("tos.rtd",,"THETA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'vega', '=RTD("tos.rtd",,"VEGA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'rho', '=RTD("tos.rtd",,"RHO",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_60m', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[CODE])', 1);

CREATE TABLE IF NOT EXISTS tos_option_data_s (
    code varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size smallint NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size smallint NULL,
    ask_size smallint NULL,
    bid_ask_size varchar(50) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume integer NULL,
    open_int integer NULL,
    implied_vol double NULL,
    delta double NULL,
    gamma double NULL,
    theta double NULL,
    vega double NULL,
    rho double NULL,
    extrinsic double NULL,
    intrinsic double NULL,
    probability_itm double NULL,
    probability_otm double NULL,
    probability_touch double NULL,
    covered_return double NULL,
    max_covered_return double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (code, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_option_data_s', 'SELECT code FROM tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_option_data_s', 'code');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'time', '=Time0()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'last', '=RTD("tos.rtd",,"LAST",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'last_x', '=RTD("tos.rtd",,"LX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'mark', '=RTD("tos.rtd",,"MARK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'bid', '=RTD("tos.rtd",,"BID",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'ask', '=RTD("tos.rtd",,"ASK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'bid_x', '=RTD("tos.rtd",,"BX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'ask_x', '=RTD("tos.rtd",,"AX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'open', '=RTD("tos.rtd",,"OPEN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'high', '=RTD("tos.rtd",,"HIGH",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'low', '=RTD("tos.rtd",,"LOW",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'close', '=RTD("tos.rtd",,"CLOSE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'volume', '=RTD("tos.rtd",,"VOLUME",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'delta', '=RTD("tos.rtd",,"DELTA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'gamma', '=RTD("tos.rtd",,"GAMMA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'theta', '=RTD("tos.rtd",,"THETA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'vega', '=RTD("tos.rtd",,"VEGA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'rho', '=RTD("tos.rtd",,"RHO",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_s', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[CODE])', 1);

CREATE TABLE IF NOT EXISTS tos_option_data_ticks (
    id integer NOT NULL PRIMARY KEY AUTOINCREMENT,
    code varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NULL,
    time time NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size smallint NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size smallint NULL,
    ask_size smallint NULL,
    bid_ask_size varchar(50) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume integer NULL,
    open_int integer NULL,
    implied_vol double NULL,
    delta double NULL,
    gamma double NULL,
    theta double NULL,
    vega double NULL,
    rho double NULL,
    extrinsic double NULL,
    intrinsic double NULL,
    probability_itm double NULL,
    probability_otm double NULL,
    probability_touch double NULL,
    covered_return double NULL,
    max_covered_return double NULL
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_option_data_ticks', 'SELECT code FROM tos_option_list', 1, NULL, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_option_data_ticks', 'id');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_option_data_ticks', 'code');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'time', '=Time()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'last', '=RTD("tos.rtd",,"LAST",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'last_x', '=RTD("tos.rtd",,"LX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'mark', '=RTD("tos.rtd",,"MARK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'bid', '=RTD("tos.rtd",,"BID",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'ask', '=RTD("tos.rtd",,"ASK",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'bid_x', '=RTD("tos.rtd",,"BX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'ask_x', '=RTD("tos.rtd",,"AX",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'open', '=RTD("tos.rtd",,"OPEN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'high', '=RTD("tos.rtd",,"HIGH",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'low', '=RTD("tos.rtd",,"LOW",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'close', '=RTD("tos.rtd",,"CLOSE",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'volume', '=RTD("tos.rtd",,"VOLUME",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'delta', '=RTD("tos.rtd",,"DELTA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'gamma', '=RTD("tos.rtd",,"GAMMA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'theta', '=RTD("tos.rtd",,"THETA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'vega', '=RTD("tos.rtd",,"VEGA",[CODE])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'rho', '=RTD("tos.rtd",,"RHO",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[CODE])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_ticks', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[CODE])', 1);

CREATE TABLE IF NOT EXISTS tos_stock_quotes_01m (
    symbol varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size integer NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size integer NULL,
    ask_size integer NULL,
    bid_ask_size varchar(255) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    strength_meter varchar(255) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume bigint NULL,
    open_int integer NULL,
    implied_vol double NULL,
    vol_index double NULL,
    front_vol double NULL,
    back_vol double NULL,
    weighted_back_vol double NULL,
    vol_diff double NULL,
    put_call_ratio double NULL,
    call_volume_index double NULL,
    put_volume_index double NULL,
    option_volume_index double NULL,
    front_expected_move double NULL,
    back_expected_move double NULL,
    expected_move_diff double NULL,
    beta double NULL,
    high52 double NULL,
    low52 double NULL,
    pe double NULL,
    eps double NULL,
    market_cap varchar(255) NULL,
    shares bigint NULL,
    dividend_yield double NULL,
    dividend_share double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (symbol, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_stock_quotes_01m', 'SELECT symbol FROM tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_stock_quotes_01m', 'symbol');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'time', '=Time1()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'last', '=RTD("tos.rtd",,"LAST",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'last_x', '=RTD("tos.rtd",,"LX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'mark', '=RTD("tos.rtd",,"MARK",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'bid', '=RTD("tos.rtd",,"BID",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'ask', '=RTD("tos.rtd",,"ASK",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'bid_x', '=RTD("tos.rtd",,"BX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'ask_x', '=RTD("tos.rtd",,"AX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'open', '=RTD("tos.rtd",,"OPEN",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'high', '=RTD("tos.rtd",,"HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'low', '=RTD("tos.rtd",,"LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'close', '=RTD("tos.rtd",,"CLOSE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'volume', '=RTD("tos.rtd",,"VOLUME",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'beta', '=RTD("tos.rtd",,"BETA",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'high52', '=RTD("tos.rtd",,"52HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'low52', '=RTD("tos.rtd",,"52LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'pe', '=RTD("tos.rtd",,"PE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'eps', '=RTD("tos.rtd",,"EPS",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'shares', '=RTD("tos.rtd",,"SHARES",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_01m', 'dividend_share', '=RTD("tos.rtd",,"DIV",[SYMBOL])', NULL);

CREATE TABLE IF NOT EXISTS tos_stock_quotes_05m (
    symbol varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size integer NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size integer NULL,
    ask_size integer NULL,
    bid_ask_size varchar(255) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    strength_meter varchar(255) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume bigint NULL,
    open_int integer NULL,
    implied_vol double NULL,
    vol_index double NULL,
    front_vol double NULL,
    back_vol double NULL,
    weighted_back_vol double NULL,
    vol_diff double NULL,
    put_call_ratio double NULL,
    call_volume_index double NULL,
    put_volume_index double NULL,
    option_volume_index double NULL,
    front_expected_move double NULL,
    back_expected_move double NULL,
    expected_move_diff double NULL,
    beta double NULL,
    high52 double NULL,
    low52 double NULL,
    pe double NULL,
    eps double NULL,
    market_cap varchar(255) NULL,
    shares bigint NULL,
    dividend_yield double NULL,
    dividend_share double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (symbol, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_stock_quotes_05m', 'SELECT symbol FROM tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_stock_quotes_05m', 'symbol');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'time', '=Time5()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'last', '=RTD("tos.rtd",,"LAST",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'last_x', '=RTD("tos.rtd",,"LX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'mark', '=RTD("tos.rtd",,"MARK",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'bid', '=RTD("tos.rtd",,"BID",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'ask', '=RTD("tos.rtd",,"ASK",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'bid_x', '=RTD("tos.rtd",,"BX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'ask_x', '=RTD("tos.rtd",,"AX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'open', '=RTD("tos.rtd",,"OPEN",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'high', '=RTD("tos.rtd",,"HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'low', '=RTD("tos.rtd",,"LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'close', '=RTD("tos.rtd",,"CLOSE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'volume', '=RTD("tos.rtd",,"VOLUME",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'beta', '=RTD("tos.rtd",,"BETA",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'high52', '=RTD("tos.rtd",,"52HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'low52', '=RTD("tos.rtd",,"52LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'pe', '=RTD("tos.rtd",,"PE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'eps', '=RTD("tos.rtd",,"EPS",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'shares', '=RTD("tos.rtd",,"SHARES",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_05m', 'dividend_share', '=RTD("tos.rtd",,"DIV",[SYMBOL])', NULL);

CREATE TABLE IF NOT EXISTS tos_stock_quotes_10m (
    symbol varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size integer NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size integer NULL,
    ask_size integer NULL,
    bid_ask_size varchar(255) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    strength_meter varchar(255) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume bigint NULL,
    open_int integer NULL,
    implied_vol double NULL,
    vol_index double NULL,
    front_vol double NULL,
    back_vol double NULL,
    weighted_back_vol double NULL,
    vol_diff double NULL,
    put_call_ratio double NULL,
    call_volume_index double NULL,
    put_volume_index double NULL,
    option_volume_index double NULL,
    front_expected_move double NULL,
    back_expected_move double NULL,
    expected_move_diff double NULL,
    beta double NULL,
    high52 double NULL,
    low52 double NULL,
    pe double NULL,
    eps double NULL,
    market_cap varchar(255) NULL,
    shares bigint NULL,
    dividend_yield double NULL,
    dividend_share double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (symbol, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_stock_quotes_10m', 'SELECT symbol FROM tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_stock_quotes_10m', 'symbol');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'time', '=Time10()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'last', '=RTD("tos.rtd",,"LAST",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'last_x', '=RTD("tos.rtd",,"LX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'mark', '=RTD("tos.rtd",,"MARK",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'bid', '=RTD("tos.rtd",,"BID",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'ask', '=RTD("tos.rtd",,"ASK",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'bid_x', '=RTD("tos.rtd",,"BX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'ask_x', '=RTD("tos.rtd",,"AX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'open', '=RTD("tos.rtd",,"OPEN",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'high', '=RTD("tos.rtd",,"HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'low', '=RTD("tos.rtd",,"LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'close', '=RTD("tos.rtd",,"CLOSE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'volume', '=RTD("tos.rtd",,"VOLUME",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'beta', '=RTD("tos.rtd",,"BETA",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'high52', '=RTD("tos.rtd",,"52HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'low52', '=RTD("tos.rtd",,"52LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'pe', '=RTD("tos.rtd",,"PE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'eps', '=RTD("tos.rtd",,"EPS",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'shares', '=RTD("tos.rtd",,"SHARES",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'dividend_share', '=RTD("tos.rtd",,"DIV",[SYMBOL])', NULL);

CREATE TABLE IF NOT EXISTS tos_stock_quotes_15m (
    symbol varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size integer NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size integer NULL,
    ask_size integer NULL,
    bid_ask_size varchar(255) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    strength_meter varchar(255) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume bigint NULL,
    open_int integer NULL,
    implied_vol double NULL,
    vol_index double NULL,
    front_vol double NULL,
    back_vol double NULL,
    weighted_back_vol double NULL,
    vol_diff double NULL,
    put_call_ratio double NULL,
    call_volume_index double NULL,
    put_volume_index double NULL,
    option_volume_index double NULL,
    front_expected_move double NULL,
    back_expected_move double NULL,
    expected_move_diff double NULL,
    beta double NULL,
    high52 double NULL,
    low52 double NULL,
    pe double NULL,
    eps double NULL,
    market_cap varchar(255) NULL,
    shares bigint NULL,
    dividend_yield double NULL,
    dividend_share double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (symbol, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_stock_quotes_15m', 'SELECT symbol FROM tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_stock_quotes_15m', 'symbol');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'time', '=Time15()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'last', '=RTD("tos.rtd",,"LAST",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'last_x', '=RTD("tos.rtd",,"LX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'mark', '=RTD("tos.rtd",,"MARK",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'bid', '=RTD("tos.rtd",,"BID",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'ask', '=RTD("tos.rtd",,"ASK",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'bid_x', '=RTD("tos.rtd",,"BX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'ask_x', '=RTD("tos.rtd",,"AX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'open', '=RTD("tos.rtd",,"OPEN",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'high', '=RTD("tos.rtd",,"HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'low', '=RTD("tos.rtd",,"LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'close', '=RTD("tos.rtd",,"CLOSE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'volume', '=RTD("tos.rtd",,"VOLUME",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'beta', '=RTD("tos.rtd",,"BETA",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'high52', '=RTD("tos.rtd",,"52HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'low52', '=RTD("tos.rtd",,"52LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'pe', '=RTD("tos.rtd",,"PE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'eps', '=RTD("tos.rtd",,"EPS",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'shares', '=RTD("tos.rtd",,"SHARES",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_15m', 'dividend_share', '=RTD("tos.rtd",,"DIV",[SYMBOL])', NULL);

CREATE TABLE IF NOT EXISTS tos_stock_quotes_20m (
    symbol varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size integer NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size integer NULL,
    ask_size integer NULL,
    bid_ask_size varchar(255) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    strength_meter varchar(255) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume bigint NULL,
    open_int integer NULL,
    implied_vol double NULL,
    vol_index double NULL,
    front_vol double NULL,
    back_vol double NULL,
    weighted_back_vol double NULL,
    vol_diff double NULL,
    put_call_ratio double NULL,
    call_volume_index double NULL,
    put_volume_index double NULL,
    option_volume_index double NULL,
    front_expected_move double NULL,
    back_expected_move double NULL,
    expected_move_diff double NULL,
    beta double NULL,
    high52 double NULL,
    low52 double NULL,
    pe double NULL,
    eps double NULL,
    market_cap varchar(255) NULL,
    shares bigint NULL,
    dividend_yield double NULL,
    dividend_share double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (symbol, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_stock_quotes_20m', 'SELECT symbol FROM tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_stock_quotes_20m', 'symbol');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'time', '=Time20()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'last', '=RTD("tos.rtd",,"LAST",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'last_x', '=RTD("tos.rtd",,"LX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'mark', '=RTD("tos.rtd",,"MARK",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'bid', '=RTD("tos.rtd",,"BID",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'ask', '=RTD("tos.rtd",,"ASK",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'bid_x', '=RTD("tos.rtd",,"BX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'ask_x', '=RTD("tos.rtd",,"AX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'open', '=RTD("tos.rtd",,"OPEN",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'high', '=RTD("tos.rtd",,"HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'low', '=RTD("tos.rtd",,"LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'close', '=RTD("tos.rtd",,"CLOSE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'volume', '=RTD("tos.rtd",,"VOLUME",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'beta', '=RTD("tos.rtd",,"BETA",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'high52', '=RTD("tos.rtd",,"52HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'low52', '=RTD("tos.rtd",,"52LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'pe', '=RTD("tos.rtd",,"PE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'eps', '=RTD("tos.rtd",,"EPS",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'shares', '=RTD("tos.rtd",,"SHARES",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_20m', 'dividend_share', '=RTD("tos.rtd",,"DIV",[SYMBOL])', NULL);

CREATE TABLE IF NOT EXISTS tos_stock_quotes_30m (
    symbol varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size integer NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size integer NULL,
    ask_size integer NULL,
    bid_ask_size varchar(255) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    strength_meter varchar(255) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume bigint NULL,
    open_int integer NULL,
    implied_vol double NULL,
    vol_index double NULL,
    front_vol double NULL,
    back_vol double NULL,
    weighted_back_vol double NULL,
    vol_diff double NULL,
    put_call_ratio double NULL,
    call_volume_index double NULL,
    put_volume_index double NULL,
    option_volume_index double NULL,
    front_expected_move double NULL,
    back_expected_move double NULL,
    expected_move_diff double NULL,
    beta double NULL,
    high52 double NULL,
    low52 double NULL,
    pe double NULL,
    eps double NULL,
    market_cap varchar(255) NULL,
    shares bigint NULL,
    dividend_yield double NULL,
    dividend_share double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (symbol, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_stock_quotes_30m', 'SELECT symbol FROM tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_stock_quotes_30m', 'symbol');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'time', '=Time30()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'last', '=RTD("tos.rtd",,"LAST",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'last_x', '=RTD("tos.rtd",,"LX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'mark', '=RTD("tos.rtd",,"MARK",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'bid', '=RTD("tos.rtd",,"BID",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'ask', '=RTD("tos.rtd",,"ASK",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'bid_x', '=RTD("tos.rtd",,"BX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'ask_x', '=RTD("tos.rtd",,"AX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'open', '=RTD("tos.rtd",,"OPEN",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'high', '=RTD("tos.rtd",,"HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'low', '=RTD("tos.rtd",,"LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'close', '=RTD("tos.rtd",,"CLOSE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'volume', '=RTD("tos.rtd",,"VOLUME",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'beta', '=RTD("tos.rtd",,"BETA",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'high52', '=RTD("tos.rtd",,"52HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'low52', '=RTD("tos.rtd",,"52LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'pe', '=RTD("tos.rtd",,"PE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'eps', '=RTD("tos.rtd",,"EPS",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'shares', '=RTD("tos.rtd",,"SHARES",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_30m', 'dividend_share', '=RTD("tos.rtd",,"DIV",[SYMBOL])', NULL);

CREATE TABLE IF NOT EXISTS tos_stock_quotes_60m (
    symbol varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size integer NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size integer NULL,
    ask_size integer NULL,
    bid_ask_size varchar(255) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    strength_meter varchar(255) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume bigint NULL,
    open_int integer NULL,
    implied_vol double NULL,
    vol_index double NULL,
    front_vol double NULL,
    back_vol double NULL,
    weighted_back_vol double NULL,
    vol_diff double NULL,
    put_call_ratio double NULL,
    call_volume_index double NULL,
    put_volume_index double NULL,
    option_volume_index double NULL,
    front_expected_move double NULL,
    back_expected_move double NULL,
    expected_move_diff double NULL,
    beta double NULL,
    high52 double NULL,
    low52 double NULL,
    pe double NULL,
    eps double NULL,
    market_cap varchar(255) NULL,
    shares bigint NULL,
    dividend_yield double NULL,
    dividend_share double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (symbol, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_stock_quotes_60m', 'SELECT symbol FROM tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_stock_quotes_60m', 'symbol');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'time', '=Time60()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'last', '=RTD("tos.rtd",,"LAST",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'last_x', '=RTD("tos.rtd",,"LX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'mark', '=RTD("tos.rtd",,"MARK",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'bid', '=RTD("tos.rtd",,"BID",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'ask', '=RTD("tos.rtd",,"ASK",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'bid_x', '=RTD("tos.rtd",,"BX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'ask_x', '=RTD("tos.rtd",,"AX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'open', '=RTD("tos.rtd",,"OPEN",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'high', '=RTD("tos.rtd",,"HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'low', '=RTD("tos.rtd",,"LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'close', '=RTD("tos.rtd",,"CLOSE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'volume', '=RTD("tos.rtd",,"VOLUME",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'beta', '=RTD("tos.rtd",,"BETA",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'high52', '=RTD("tos.rtd",,"52HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'low52', '=RTD("tos.rtd",,"52LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'pe', '=RTD("tos.rtd",,"PE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'eps', '=RTD("tos.rtd",,"EPS",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'shares', '=RTD("tos.rtd",,"SHARES",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_60m', 'dividend_share', '=RTD("tos.rtd",,"DIV",[SYMBOL])', NULL);

CREATE TABLE IF NOT EXISTS tos_stock_quotes_s (
    symbol varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size integer NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size integer NULL,
    ask_size integer NULL,
    bid_ask_size varchar(255) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    strength_meter varchar(255) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume bigint NULL,
    open_int integer NULL,
    implied_vol double NULL,
    vol_index double NULL,
    front_vol double NULL,
    back_vol double NULL,
    weighted_back_vol double NULL,
    vol_diff double NULL,
    put_call_ratio double NULL,
    call_volume_index double NULL,
    put_volume_index double NULL,
    option_volume_index double NULL,
    front_expected_move double NULL,
    back_expected_move double NULL,
    expected_move_diff double NULL,
    beta double NULL,
    high52 double NULL,
    low52 double NULL,
    pe double NULL,
    eps double NULL,
    market_cap varchar(255) NULL,
    shares bigint NULL,
    dividend_yield double NULL,
    dividend_share double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (symbol, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_stock_quotes_s', 'SELECT symbol FROM tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_stock_quotes_s', 'symbol');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'time', '=Time0()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'last', '=RTD("tos.rtd",,"LAST",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'last_x', '=RTD("tos.rtd",,"LX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'mark', '=RTD("tos.rtd",,"MARK",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'bid', '=RTD("tos.rtd",,"BID",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'ask', '=RTD("tos.rtd",,"ASK",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'bid_x', '=RTD("tos.rtd",,"BX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'ask_x', '=RTD("tos.rtd",,"AX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'open', '=RTD("tos.rtd",,"OPEN",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'high', '=RTD("tos.rtd",,"HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'low', '=RTD("tos.rtd",,"LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'close', '=RTD("tos.rtd",,"CLOSE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'volume', '=RTD("tos.rtd",,"VOLUME",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'beta', '=RTD("tos.rtd",,"BETA",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'high52', '=RTD("tos.rtd",,"52HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'low52', '=RTD("tos.rtd",,"52LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'pe', '=RTD("tos.rtd",,"PE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'eps', '=RTD("tos.rtd",,"EPS",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'shares', '=RTD("tos.rtd",,"SHARES",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_s', 'dividend_share', '=RTD("tos.rtd",,"DIV",[SYMBOL])', NULL);

CREATE TABLE IF NOT EXISTS tos_stock_quotes_ticks (
    id integer NOT NULL PRIMARY KEY AUTOINCREMENT,
    symbol varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NULL,
    time time NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size integer NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size integer NULL,
    ask_size integer NULL,
    bid_ask_size varchar(255) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    strength_meter varchar(255) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume bigint NULL,
    open_int integer NULL,
    implied_vol double NULL,
    vol_index double NULL,
    front_vol double NULL,
    back_vol double NULL,
    weighted_back_vol double NULL,
    vol_diff double NULL,
    put_call_ratio double NULL,
    call_volume_index double NULL,
    put_volume_index double NULL,
    option_volume_index double NULL,
    front_expected_move double NULL,
    back_expected_move double NULL,
    expected_move_diff double NULL,
    beta double NULL,
    high52 double NULL,
    low52 double NULL,
    pe double NULL,
    eps double NULL,
    market_cap varchar(255) NULL,
    shares bigint NULL,
    dividend_yield double NULL,
    dividend_share double NULL
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_stock_quotes_ticks', 'SELECT symbol FROM tos_stock_list', 1, NULL, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_stock_quotes_ticks', 'id');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_stock_quotes_ticks', 'symbol');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'time', '=Time()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'last', '=RTD("tos.rtd",,"LAST",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'last_x', '=RTD("tos.rtd",,"LX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'mark', '=RTD("tos.rtd",,"MARK",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'bid', '=RTD("tos.rtd",,"BID",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'ask', '=RTD("tos.rtd",,"ASK",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'bid_x', '=RTD("tos.rtd",,"BX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'ask_x', '=RTD("tos.rtd",,"AX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'open', '=RTD("tos.rtd",,"OPEN",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'high', '=RTD("tos.rtd",,"HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'low', '=RTD("tos.rtd",,"LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'close', '=RTD("tos.rtd",,"CLOSE",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'volume', '=RTD("tos.rtd",,"VOLUME",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'beta', '=RTD("tos.rtd",,"BETA",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'high52', '=RTD("tos.rtd",,"52HIGH",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'low52', '=RTD("tos.rtd",,"52LOW",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'pe', '=RTD("tos.rtd",,"PE",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'eps', '=RTD("tos.rtd",,"EPS",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'shares', '=RTD("tos.rtd",,"SHARES",[SYMBOL])', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[SYMBOL])', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_ticks', 'dividend_share', '=RTD("tos.rtd",,"DIV",[SYMBOL])', NULL);

