CREATE TABLE IF NOT EXISTS tos_stock_quotes_10m (
    symbol varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size integer NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size integer NULL,
    ask_size integer NULL,
    bid_ask_size varchar(255) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    strength_meter varchar(255) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume bigint NULL,
    open_int integer NULL,
    implied_vol double NULL,
    vol_index double NULL,
    front_vol double NULL,
    back_vol double NULL,
    weighted_back_vol double NULL,
    vol_diff double NULL,
    put_call_ratio double NULL,
    call_volume_index double NULL,
    put_volume_index double NULL,
    option_volume_index double NULL,
    front_expected_move double NULL,
    back_expected_move double NULL,
    expected_move_diff double NULL,
    beta double NULL,
    high52 double NULL,
    low52 double NULL,
    pe double NULL,
    eps double NULL,
    market_cap varchar(255) NULL,
    shares bigint NULL,
    dividend_yield double NULL,
    dividend_share double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (symbol, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_stock_quotes_10m', 'SELECT symbol FROM tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_stock_quotes_10m', 'symbol');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'time', '=Time10()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'description', '=TOS|DESCRIPTION![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'last', '=TOS|LAST![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'change', '=TOS|NET_CHANGE![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'percent_change', '=TOS|PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'last_size', '=TOS|LAST_SIZE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'last_x', '=TOS|LX![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'mark', '=TOS|MARK![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'mark_change', '=TOS|MARK_CHANGE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'bid', '=TOS|BID![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'ask', '=TOS|ASK![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'bid_size', '=TOS|BID_SIZE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'ask_size', '=TOS|ASK_SIZE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'bid_ask_size', '=TOS|BA_SIZE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'bid_x', '=TOS|BX![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'ask_x', '=TOS|AX![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'strength_meter', '=TOS|STRENGTH_METER![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'open', '=TOS|OPEN![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'high', '=TOS|HIGH![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'low', '=TOS|LOW![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'close', '=TOS|CLOSE![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'volume', '=TOS|VOLUME![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'open_int', '=TOS|OPEN_INT![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'implied_vol', '=TOS|IMPL_VOL![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'vol_index', '=TOS|VOL_INDEX![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'front_vol', '=TOS|FRONT_VOL![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'back_vol', '=TOS|BACK_VOL![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'vol_diff', '=TOS|VOL_DIFF![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'front_expected_move', '=TOS|FRONT_EX_MOVE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'back_expected_move', '=TOS|BACK_EX_MOVE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'beta', '=TOS|BETA![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'high52', '=TOS|''52HIGH''![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'low52', '=TOS|''52LOW''![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'pe', '=TOS|PE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'eps', '=TOS|EPS![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'market_cap', '=TOS|MARKET_CAP![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'shares', '=TOS|SHARES![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'dividend_yield', '=TOS|YIELD![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_stock_quotes_10m', 'dividend_share', '=TOS|DIV![SYMBOL]', NULL);

