CREATE TABLE IF NOT EXISTS tos_option_data_10m (
    code varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size smallint NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size smallint NULL,
    ask_size smallint NULL,
    bid_ask_size varchar(50) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume integer NULL,
    open_int integer NULL,
    implied_vol double NULL,
    delta double NULL,
    gamma double NULL,
    theta double NULL,
    vega double NULL,
    rho double NULL,
    extrinsic double NULL,
    intrinsic double NULL,
    probability_itm double NULL,
    probability_otm double NULL,
    probability_touch double NULL,
    covered_return double NULL,
    max_covered_return double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (code, date, time)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_option_data_10m', 'SELECT code FROM tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_option_data_10m', 'code');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'datetime', '=DateTime()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'time', '=Time10()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'description', '=TOS|DESCRIPTION!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'last', '=TOS|LAST!''[CODE]''', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'change', '=TOS|NET_CHANGE!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'percent_change', '=TOS|PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'last_size', '=TOS|LAST_SIZE!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'last_x', '=TOS|LX!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'mark', '=TOS|MARK!''[CODE]''', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'mark_change', '=TOS|MARK_CHANGE!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'bid', '=TOS|BID!''[CODE]''', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'ask', '=TOS|ASK!''[CODE]''', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'bid_size', '=TOS|BID_SIZE!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'ask_size', '=TOS|ASK_SIZE!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'bid_ask_size', '=TOS|BA_SIZE!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'bid_x', '=TOS|BX!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'ask_x', '=TOS|AX!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'open', '=TOS|OPEN!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'high', '=TOS|HIGH!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'low', '=TOS|LOW!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'close', '=TOS|Close!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'volume', '=TOS|VOLUME!''[CODE]''', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'open_int', '=TOS|OPEN_INT!''[CODE]''', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'implied_vol', '=TOS|IMPL_VOL!''[CODE]''', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'delta', '=TOS|DELTA!''[CODE]''', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'gamma', '=TOS|GAMMA!''[CODE]''', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'theta', '=TOS|THETA!''[CODE]''', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'vega', '=TOS|VEGA!''[CODE]''', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'rho', '=TOS|RHO!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'extrinsic', '=TOS|EXTRINSIC!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'intrinsic', '=TOS|INTRINSIC!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'probability_otm', '=TOS|PROB_OTM!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'covered_return', '=TOS|COVERED_RETURN!''[CODE]''', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_option_data_10m', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[CODE]''', 1);

