CREATE TABLE IF NOT EXISTS tos_historical_prices (
    symbol varchar(50) NOT NULL,
    date date NOT NULL,
    time time NULL,
    description varchar(255) NULL,
    last double NULL,
    change double NULL,
    percent_change double NULL,
    last_size integer NULL,
    last_x char(1) NULL,
    mark double NULL,
    mark_change double NULL,
    mark_percent_change double NULL,
    bid double NULL,
    ask double NULL,
    bid_size integer NULL,
    ask_size integer NULL,
    bid_ask_size varchar(255) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    strength_meter varchar(255) NULL,
    open double NULL,
    high double NULL,
    low double NULL,
    close double NULL,
    volume bigint NULL,
    open_int integer NULL,
    implied_vol double NULL,
    vol_index double NULL,
    front_vol double NULL,
    back_vol double NULL,
    weighted_back_vol double NULL,
    vol_diff double NULL,
    put_call_ratio double NULL,
    call_volume_index double NULL,
    put_volume_index double NULL,
    option_volume_index double NULL,
    front_expected_move double NULL,
    back_expected_move double NULL,
    expected_move_diff double NULL,
    beta double NULL,
    high52 double NULL,
    low52 double NULL,
    pe double NULL,
    eps double NULL,
    market_cap varchar(255) NULL,
    shares bigint NULL,
    dividend_yield double NULL,
    dividend_share double NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (symbol, date)
);


INSERT INTO real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES (NULL, 'tos_historical_prices', 'SELECT symbol FROM tos_stock_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES (NULL, 'tos_historical_prices', 'symbol');
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'date', '=Date()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'time', '=Time()', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'description', '=TOS|DESCRIPTION![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'last', '=TOS|LAST![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'change', '=TOS|NET_CHANGE![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'percent_change', '=TOS|PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'last_size', '=TOS|LAST_SIZE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'last_x', '=TOS|LX![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'mark', '=TOS|MARK![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'mark_change', '=TOS|MARK_CHANGE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'bid', '=TOS|BID![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'ask', '=TOS|ASK![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'bid_size', '=TOS|BID_SIZE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'ask_size', '=TOS|ASK_SIZE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'bid_ask_size', '=TOS|BA_SIZE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'bid_x', '=TOS|BX![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'ask_x', '=TOS|AX![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'strength_meter', '=TOS|STRENGTH_METER![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'open', '=TOS|OPEN![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'high', '=TOS|HIGH![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'low', '=TOS|LOW![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'close', '=TOS|CLOSE![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'volume', '=TOS|VOLUME![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'open_int', '=TOS|OPEN_INT![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'implied_vol', '=TOS|IMPL_VOL![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'vol_index', '=TOS|VOL_INDEX![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'front_vol', '=TOS|FRONT_VOL![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'back_vol', '=TOS|BACK_VOL![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'vol_diff', '=TOS|VOL_DIFF![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'front_expected_move', '=TOS|FRONT_EX_MOVE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'back_expected_move', '=TOS|BACK_EX_MOVE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'beta', '=TOS|BETA![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'high52', '=TOS|''52HIGH''![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'low52', '=TOS|''52LOW''![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'pe', '=TOS|PE![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'eps', '=TOS|EPS![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'market_cap', '=TOS|MARKET_CAP![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'shares', '=TOS|SHARES![SYMBOL]', 1);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'dividend_yield', '=TOS|YIELD![SYMBOL]', NULL);
INSERT INTO real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES (NULL, 'tos_historical_prices', 'dividend_share', '=TOS|DIV![SYMBOL]', NULL);

