CREATE TABLE IF NOT EXISTS real_time_formulas (
    id integer NOT NULL PRIMARY KEY AUTOINCREMENT,
    table_schema varchar(128) NULL,
    table_name varchar(128) NOT NULL,
    column_name varchar(128) NOT NULL,
    rtd_formula varchar(255) NULL,
    is_disabled smallint NULL
);

CREATE UNIQUE INDEX ix_real_time_formulas_schema_name_column_name ON real_time_formulas (table_name, column_name);


CREATE TABLE IF NOT EXISTS real_time_tables (
    id integer NOT NULL PRIMARY KEY AUTOINCREMENT,
    table_schema varchar(128) NULL,
    table_name varchar(128) NOT NULL,
    load_code varchar(2000) NULL,
    is_history smallint NULL,
    is_disabled smallint NULL,
    time_zone varchar(50) NULL,
    rtd_instance_name varchar(50) NULL
);

CREATE UNIQUE INDEX ix_realtimetables_schema_name ON real_time_tables (table_name);

