CREATE TABLE IF NOT EXISTS rtd.tos_stock_quotes_ticks (
    id bigserial NOT NULL,
    symbol varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NULL,
    time time NULL,
    description varchar(255) NULL,
    last double precision NULL,
    change double precision NULL,
    percent_change double precision NULL,
    last_size integer NULL,
    last_x char(1) NULL,
    mark double precision NULL,
    mark_change double precision NULL,
    mark_percent_change double precision NULL,
    bid double precision NULL,
    ask double precision NULL,
    bid_size integer NULL,
    ask_size integer NULL,
    bid_ask_size varchar(255) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    strength_meter varchar(255) NULL,
    open double precision NULL,
    high double precision NULL,
    low double precision NULL,
    close double precision NULL,
    volume bigint NULL,
    open_int integer NULL,
    implied_vol double precision NULL,
    vol_index double precision NULL,
    front_vol double precision NULL,
    back_vol double precision NULL,
    weighted_back_vol double precision NULL,
    vol_diff double precision NULL,
    put_call_ratio double precision NULL,
    call_volume_index double precision NULL,
    put_volume_index double precision NULL,
    option_volume_index double precision NULL,
    front_expected_move double precision NULL,
    back_expected_move double precision NULL,
    expected_move_diff double precision NULL,
    beta double precision NULL,
    high52 double precision NULL,
    low52 double precision NULL,
    pe double precision NULL,
    eps double precision NULL,
    market_cap varchar(255) NULL,
    shares bigint NULL,
    dividend_yield double precision NULL,
    dividend_share double precision NULL,
  PRIMARY KEY (id)
);


INSERT INTO rtd.real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_stock_quotes_ticks', 'SELECT symbol FROM rtd.tos_stock_list', 1, NULL, 'Eastern Standard Time', NULL);

INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES ('rtd', 'tos_stock_quotes_ticks', 'id');
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES ('rtd', 'tos_stock_quotes_ticks', 'symbol');
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'datetime', '=DateTime()', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'date', '=Date()', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'time', '=Time()', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'last', '=RTD("tos.rtd",,"LAST",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'last_x', '=RTD("tos.rtd",,"LX",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'mark', '=RTD("tos.rtd",,"MARK",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid', '=RTD("tos.rtd",,"BID",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'ask', '=RTD("tos.rtd",,"ASK",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid_x', '=RTD("tos.rtd",,"BX",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'ask_x', '=RTD("tos.rtd",,"AX",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'open', '=RTD("tos.rtd",,"OPEN",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'high', '=RTD("tos.rtd",,"HIGH",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'low', '=RTD("tos.rtd",,"LOW",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'close', '=RTD("tos.rtd",,"CLOSE",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'volume', '=RTD("tos.rtd",,"VOLUME",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'beta', '=RTD("tos.rtd",,"BETA",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'high52', '=RTD("tos.rtd",,"52HIGH",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'low52', '=RTD("tos.rtd",,"52LOW",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'pe', '=RTD("tos.rtd",,"PE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'eps', '=RTD("tos.rtd",,"EPS",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'shares', '=RTD("tos.rtd",,"SHARES",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'dividend_share', '=RTD("tos.rtd",,"DIV",[SYMBOL])', NULL);

