CREATE TABLE IF NOT EXISTS rtd.tos_stock_quotes_60m (
    symbol varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double precision NULL,
    change double precision NULL,
    percent_change double precision NULL,
    last_size integer NULL,
    last_x char(1) NULL,
    mark double precision NULL,
    mark_change double precision NULL,
    mark_percent_change double precision NULL,
    bid double precision NULL,
    ask double precision NULL,
    bid_size integer NULL,
    ask_size integer NULL,
    bid_ask_size varchar(255) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    strength_meter varchar(255) NULL,
    open double precision NULL,
    high double precision NULL,
    low double precision NULL,
    close double precision NULL,
    volume bigint NULL,
    open_int integer NULL,
    implied_vol double precision NULL,
    vol_index double precision NULL,
    front_vol double precision NULL,
    back_vol double precision NULL,
    weighted_back_vol double precision NULL,
    vol_diff double precision NULL,
    put_call_ratio double precision NULL,
    call_volume_index double precision NULL,
    put_volume_index double precision NULL,
    option_volume_index double precision NULL,
    front_expected_move double precision NULL,
    back_expected_move double precision NULL,
    expected_move_diff double precision NULL,
    beta double precision NULL,
    high52 double precision NULL,
    low52 double precision NULL,
    pe double precision NULL,
    eps double precision NULL,
    market_cap varchar(255) NULL,
    shares bigint NULL,
    dividend_yield double precision NULL,
    dividend_share double precision NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (symbol, date, time)
);


INSERT INTO rtd.real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_stock_quotes_60m', 'SELECT symbol FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES ('rtd', 'tos_stock_quotes_60m', 'symbol');
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'datetime', '=DateTime()', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'date', '=Date()', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'time', '=Time60()', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'last', '=RTD("tos.rtd",,"LAST",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'last_x', '=RTD("tos.rtd",,"LX",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'mark', '=RTD("tos.rtd",,"MARK",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'bid', '=RTD("tos.rtd",,"BID",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'ask', '=RTD("tos.rtd",,"ASK",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'bid_x', '=RTD("tos.rtd",,"BX",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'ask_x', '=RTD("tos.rtd",,"AX",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'open', '=RTD("tos.rtd",,"OPEN",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'high', '=RTD("tos.rtd",,"HIGH",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'low', '=RTD("tos.rtd",,"LOW",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'close', '=RTD("tos.rtd",,"CLOSE",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'volume', '=RTD("tos.rtd",,"VOLUME",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'beta', '=RTD("tos.rtd",,"BETA",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'high52', '=RTD("tos.rtd",,"52HIGH",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'low52', '=RTD("tos.rtd",,"52LOW",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'pe', '=RTD("tos.rtd",,"PE",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'eps', '=RTD("tos.rtd",,"EPS",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'shares', '=RTD("tos.rtd",,"SHARES",[SYMBOL])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[SYMBOL])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_60m', 'dividend_share', '=RTD("tos.rtd",,"DIV",[SYMBOL])', NULL);

