CREATE TABLE IF NOT EXISTS rtd.tos_option_data_30m (
    code varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NOT NULL,
    time time NOT NULL,
    description varchar(255) NULL,
    last double precision NULL,
    change double precision NULL,
    percent_change double precision NULL,
    last_size smallint NULL,
    last_x char(1) NULL,
    mark double precision NULL,
    mark_change double precision NULL,
    mark_percent_change double precision NULL,
    bid double precision NULL,
    ask double precision NULL,
    bid_size smallint NULL,
    ask_size smallint NULL,
    bid_ask_size varchar(50) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    open double precision NULL,
    high double precision NULL,
    low double precision NULL,
    close double precision NULL,
    volume integer NULL,
    open_int integer NULL,
    implied_vol double precision NULL,
    delta double precision NULL,
    gamma double precision NULL,
    theta double precision NULL,
    vega double precision NULL,
    rho double precision NULL,
    extrinsic double precision NULL,
    intrinsic double precision NULL,
    probability_itm double precision NULL,
    probability_otm double precision NULL,
    probability_touch double precision NULL,
    covered_return double precision NULL,
    max_covered_return double precision NULL,
    last_update_timestamp timestamp default current_timestamp,
  PRIMARY KEY (code, date, time)
);


INSERT INTO rtd.real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_option_data_30m', 'SELECT code FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES ('rtd', 'tos_option_data_30m', 'code');
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'datetime', '=DateTime()', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'date', '=Date()', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'time', '=Time30()', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'last', '=RTD("tos.rtd",,"LAST",[CODE])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'last_x', '=RTD("tos.rtd",,"LX",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'mark', '=RTD("tos.rtd",,"MARK",[CODE])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'bid', '=RTD("tos.rtd",,"BID",[CODE])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'ask', '=RTD("tos.rtd",,"ASK",[CODE])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'bid_x', '=RTD("tos.rtd",,"BX",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'ask_x', '=RTD("tos.rtd",,"AX",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'open', '=RTD("tos.rtd",,"OPEN",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'high', '=RTD("tos.rtd",,"HIGH",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'low', '=RTD("tos.rtd",,"LOW",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'close', '=RTD("tos.rtd",,"CLOSE",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'volume', '=RTD("tos.rtd",,"VOLUME",[CODE])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[CODE])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[CODE])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'delta', '=RTD("tos.rtd",,"DELTA",[CODE])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'gamma', '=RTD("tos.rtd",,"GAMMA",[CODE])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'theta', '=RTD("tos.rtd",,"THETA",[CODE])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'vega', '=RTD("tos.rtd",,"VEGA",[CODE])', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'rho', '=RTD("tos.rtd",,"RHO",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[CODE])', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_30m', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[CODE])', 1);

