CREATE TABLE IF NOT EXISTS rtd.tos_stock_quotes_ticks (
    id bigserial NOT NULL,
    symbol varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NULL,
    time time NULL,
    description varchar(255) NULL,
    last double precision NULL,
    change double precision NULL,
    percent_change double precision NULL,
    last_size integer NULL,
    last_x char(1) NULL,
    mark double precision NULL,
    mark_change double precision NULL,
    mark_percent_change double precision NULL,
    bid double precision NULL,
    ask double precision NULL,
    bid_size integer NULL,
    ask_size integer NULL,
    bid_ask_size varchar(255) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    strength_meter varchar(255) NULL,
    open double precision NULL,
    high double precision NULL,
    low double precision NULL,
    close double precision NULL,
    volume bigint NULL,
    open_int integer NULL,
    implied_vol double precision NULL,
    vol_index double precision NULL,
    front_vol double precision NULL,
    back_vol double precision NULL,
    weighted_back_vol double precision NULL,
    vol_diff double precision NULL,
    put_call_ratio double precision NULL,
    call_volume_index double precision NULL,
    put_volume_index double precision NULL,
    option_volume_index double precision NULL,
    front_expected_move double precision NULL,
    back_expected_move double precision NULL,
    expected_move_diff double precision NULL,
    beta double precision NULL,
    high52 double precision NULL,
    low52 double precision NULL,
    pe double precision NULL,
    eps double precision NULL,
    market_cap varchar(255) NULL,
    shares bigint NULL,
    dividend_yield double precision NULL,
    dividend_share double precision NULL,
  PRIMARY KEY (id)
);


INSERT INTO rtd.real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_stock_quotes_ticks', 'SELECT symbol FROM rtd.tos_stock_list', 1, NULL, 'Eastern Standard Time', NULL);

INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES ('rtd', 'tos_stock_quotes_ticks', 'id');
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES ('rtd', 'tos_stock_quotes_ticks', 'symbol');
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'datetime', '=DateTime()', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'date', '=Date()', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'time', '=Time()', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'description', '=TOS|DESCRIPTION![SYMBOL]', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'last', '=TOS|LAST![SYMBOL]', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'change', '=TOS|NET_CHANGE![SYMBOL]', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'percent_change', '=TOS|PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'last_size', '=TOS|LAST_SIZE![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'last_x', '=TOS|LX![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'mark', '=TOS|MARK![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'mark_change', '=TOS|MARK_CHANGE![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid', '=TOS|BID![SYMBOL]', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'ask', '=TOS|ASK![SYMBOL]', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid_size', '=TOS|BID_SIZE![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'ask_size', '=TOS|ASK_SIZE![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid_ask_size', '=TOS|BA_SIZE![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid_x', '=TOS|BX![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'ask_x', '=TOS|AX![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'strength_meter', '=TOS|STRENGTH_METER![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'open', '=TOS|OPEN![SYMBOL]', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'high', '=TOS|HIGH![SYMBOL]', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'low', '=TOS|LOW![SYMBOL]', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'close', '=TOS|CLOSE![SYMBOL]', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'volume', '=TOS|VOLUME![SYMBOL]', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'open_int', '=TOS|OPEN_INT![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'implied_vol', '=TOS|IMPL_VOL![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'vol_index', '=TOS|VOL_INDEX![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'front_vol', '=TOS|FRONT_VOL![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'back_vol', '=TOS|BACK_VOL![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'vol_diff', '=TOS|VOL_DIFF![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'front_expected_move', '=TOS|FRONT_EX_MOVE![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'back_expected_move', '=TOS|BACK_EX_MOVE![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'beta', '=TOS|BETA![SYMBOL]', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'high52', '=TOS|''52HIGH''![SYMBOL]', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'low52', '=TOS|''52LOW''![SYMBOL]', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'pe', '=TOS|PE![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'eps', '=TOS|EPS![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'market_cap', '=TOS|MARKET_CAP![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'shares', '=TOS|SHARES![SYMBOL]', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'dividend_yield', '=TOS|YIELD![SYMBOL]', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_stock_quotes_ticks', 'dividend_share', '=TOS|DIV![SYMBOL]', NULL);

