CREATE TABLE IF NOT EXISTS rtd.tos_option_data_ticks (
    id serial NOT NULL,
    code varchar(50) NOT NULL,
    datetime timestamp NULL,
    date date NULL,
    time time NULL,
    description varchar(255) NULL,
    last double precision NULL,
    change double precision NULL,
    percent_change double precision NULL,
    last_size smallint NULL,
    last_x char(1) NULL,
    mark double precision NULL,
    mark_change double precision NULL,
    mark_percent_change double precision NULL,
    bid double precision NULL,
    ask double precision NULL,
    bid_size smallint NULL,
    ask_size smallint NULL,
    bid_ask_size varchar(50) NULL,
    bid_x char(1) NULL,
    ask_x char(1) NULL,
    open double precision NULL,
    high double precision NULL,
    low double precision NULL,
    close double precision NULL,
    volume integer NULL,
    open_int integer NULL,
    implied_vol double precision NULL,
    delta double precision NULL,
    gamma double precision NULL,
    theta double precision NULL,
    vega double precision NULL,
    rho double precision NULL,
    extrinsic double precision NULL,
    intrinsic double precision NULL,
    probability_itm double precision NULL,
    probability_otm double precision NULL,
    probability_touch double precision NULL,
    covered_return double precision NULL,
    max_covered_return double precision NULL,
  PRIMARY KEY (id)
);


INSERT INTO rtd.real_time_tables (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_option_data_ticks', 'SELECT code FROM rtd.tos_option_list', 1, NULL, 'Eastern Standard Time', NULL);

INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES ('rtd', 'tos_option_data_ticks', 'id');
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME) VALUES ('rtd', 'tos_option_data_ticks', 'code');
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'datetime', '=DateTime()', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'date', '=Date()', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'time', '=Time()', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'description', '=TOS|DESCRIPTION!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'last', '=TOS|LAST!''[CODE]''', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'change', '=TOS|NET_CHANGE!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'percent_change', '=TOS|PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'last_size', '=TOS|LAST_SIZE!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'last_x', '=TOS|LX!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'mark', '=TOS|MARK!''[CODE]''', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'mark_change', '=TOS|MARK_CHANGE!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'bid', '=TOS|BID!''[CODE]''', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'ask', '=TOS|ASK!''[CODE]''', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'bid_size', '=TOS|BID_SIZE!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'ask_size', '=TOS|ASK_SIZE!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'bid_ask_size', '=TOS|BA_SIZE!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'bid_x', '=TOS|BX!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'ask_x', '=TOS|AX!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'open', '=TOS|OPEN!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'high', '=TOS|HIGH!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'low', '=TOS|LOW!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'close', '=TOS|Close!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'volume', '=TOS|VOLUME!''[CODE]''', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'open_int', '=TOS|OPEN_INT!''[CODE]''', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'implied_vol', '=TOS|IMPL_VOL!''[CODE]''', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'delta', '=TOS|DELTA!''[CODE]''', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'gamma', '=TOS|GAMMA!''[CODE]''', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'theta', '=TOS|THETA!''[CODE]''', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'vega', '=TOS|VEGA!''[CODE]''', NULL);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'rho', '=TOS|RHO!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'extrinsic', '=TOS|EXTRINSIC!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'intrinsic', '=TOS|INTRINSIC!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'probability_otm', '=TOS|PROB_OTM!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'covered_return', '=TOS|COVERED_RETURN!''[CODE]''', 1);
INSERT INTO rtd.real_time_formulas (TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, RTD_FORMULA, IS_DISABLED) VALUES ('rtd', 'tos_option_data_ticks', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[CODE]''', 1);

