CREATE SCHEMA IF NOT EXISTS rtd;

CREATE TABLE IF NOT EXISTS rtd.real_time_formulas (
    id serial NOT NULL,
    table_schema varchar(128) NOT NULL,
    table_name varchar(128) NOT NULL,
    column_name varchar(128) NOT NULL,
    rtd_formula varchar(255) NULL,
    is_disabled smallint NULL,
  PRIMARY KEY (id)
);

CREATE UNIQUE INDEX IF NOT EXISTS ix_real_time_formulas_schema_name_column_name ON rtd.real_time_formulas
    USING BTREE (
       table_schema,
       table_name,
       column_name
    );


CREATE TABLE IF NOT EXISTS rtd.real_time_tables (
    id serial NOT NULL,
    table_schema varchar(128) NOT NULL,
    table_name varchar(128) NOT NULL,
    load_code varchar(2000) NULL,
    is_history smallint NULL,
    is_disabled smallint NULL,
    time_zone varchar(50) NULL,
    rtd_instance_name varchar(50) NULL,
  PRIMARY KEY (id)
);

CREATE UNIQUE INDEX IF NOT EXISTS ix_realtimetables_schema_name ON rtd.real_time_tables
    USING BTREE (
       table_schema,
       table_name
    );
    
