CREATE TABLE IF NOT EXISTS `rtd`.`tos_stock_quotes_10m` (
    `symbol` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` INTEGER NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` INTEGER NULL,
    `ask_size` INTEGER NULL,
    `bid_ask_size` VARCHAR(255) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `strength_meter` VARCHAR(255) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` BIGINT NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `vol_index` DOUBLE NULL,
    `front_vol` DOUBLE NULL,
    `back_vol` DOUBLE NULL,
    `weighted_back_vol` DOUBLE NULL,
    `vol_diff` DOUBLE NULL,
    `put_call_ratio` DOUBLE NULL,
    `call_volume_index` DOUBLE NULL,
    `put_volume_index` DOUBLE NULL,
    `option_volume_index` DOUBLE NULL,
    `front_expected_move` DOUBLE NULL,
    `back_expected_move` DOUBLE NULL,
    `expected_move_diff` DOUBLE NULL,
    `beta` DOUBLE NULL,
    `high52` DOUBLE NULL,
    `low52` DOUBLE NULL,
    `pe` DOUBLE NULL,
    `eps` DOUBLE NULL,
    `market_cap` VARCHAR(255) NULL,
    `shares` BIGINT NULL,
    `dividend_yield` DOUBLE NULL,
    `dividend_share` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`symbol`, `date`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_stock_quotes_10m', 'SELECT SYMBOL FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_stock_quotes_10m', 'symbol');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'time', '=Time10()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[SYMBOL])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'last', '=RTD("tos.rtd",,"LAST",[SYMBOL])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[SYMBOL])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'last_x', '=RTD("tos.rtd",,"LX",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'mark', '=RTD("tos.rtd",,"MARK",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'bid', '=RTD("tos.rtd",,"BID",[SYMBOL])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'ask', '=RTD("tos.rtd",,"ASK",[SYMBOL])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'bid_x', '=RTD("tos.rtd",,"BX",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'ask_x', '=RTD("tos.rtd",,"AX",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'strength_meter', '=RTD("tos.rtd",,"STRENGTH_METER",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'open', '=RTD("tos.rtd",,"OPEN",[SYMBOL])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'high', '=RTD("tos.rtd",,"HIGH",[SYMBOL])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'low', '=RTD("tos.rtd",,"LOW",[SYMBOL])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'close', '=RTD("tos.rtd",,"CLOSE",[SYMBOL])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'volume', '=RTD("tos.rtd",,"VOLUME",[SYMBOL])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'vol_index', '=RTD("tos.rtd",,"VOL_INDEX",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'front_vol', '=RTD("tos.rtd",,"FRONT_VOL",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'back_vol', '=RTD("tos.rtd",,"BACK_VOL",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'weighted_back_vol', '=RTD("tos.rtd",,"WEIGHTED_BACK_VOL",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'vol_diff', '=RTD("tos.rtd",,"VOL_DIFF",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'put_call_ratio', '=RTD("tos.rtd",,"PUT_CALL_RATIO",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'call_volume_index', '=RTD("tos.rtd",,"CALL_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'put_volume_index', '=RTD("tos.rtd",,"PUT_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'option_volume_index', '=RTD("tos.rtd",,"OPTION_VOLUME_INDEX",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'front_expected_move', '=RTD("tos.rtd",,"FRONT_EX_MOVE",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'back_expected_move', '=RTD("tos.rtd",,"BACK_EX_MOVE",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'expected_move_diff', '=RTD("tos.rtd",,"EX_MOVE_DIFF",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'beta', '=RTD("tos.rtd",,"BETA",[SYMBOL])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'high52', '=RTD("tos.rtd",,"52HIGH",[SYMBOL])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'low52', '=RTD("tos.rtd",,"52LOW",[SYMBOL])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'pe', '=RTD("tos.rtd",,"PE",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'eps', '=RTD("tos.rtd",,"EPS",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'market_cap', '=RTD("tos.rtd",,"MARKET_CAP",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'shares', '=RTD("tos.rtd",,"SHARES",[SYMBOL])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'dividend_yield', '=RTD("tos.rtd",,"YIELD",[SYMBOL])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'dividend_share', '=RTD("tos.rtd",,"DIV",[SYMBOL])', NULL);

