CREATE TABLE IF NOT EXISTS `rtd`.`tos_option_data_ticks` (
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `code` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NULL,
    `date` DATE NULL,
    `time` TIME NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` SMALLINT NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` SMALLINT NULL,
    `ask_size` SMALLINT NULL,
    `bid_ask_size` VARCHAR(50) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` INTEGER NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `delta` DOUBLE NULL,
    `gamma` DOUBLE NULL,
    `theta` DOUBLE NULL,
    `vega` DOUBLE NULL,
    `rho` DOUBLE NULL,
    `extrinsic` DOUBLE NULL,
    `intrinsic` DOUBLE NULL,
    `probability_itm` DOUBLE NULL,
    `probability_otm` DOUBLE NULL,
    `probability_touch` DOUBLE NULL,
    `covered_return` DOUBLE NULL,
    `max_covered_return` DOUBLE NULL,
  PRIMARY KEY (`id`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_option_data_ticks', 'SELECT CODE FROM rtd.tos_option_list', 1, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_option_data_ticks', 'id');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_option_data_ticks', 'code');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'time', '=Time()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'last', '=RTD("tos.rtd",,"LAST",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'last_x', '=RTD("tos.rtd",,"LX",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'mark', '=RTD("tos.rtd",,"MARK",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'bid', '=RTD("tos.rtd",,"BID",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'ask', '=RTD("tos.rtd",,"ASK",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'bid_x', '=RTD("tos.rtd",,"BX",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'ask_x', '=RTD("tos.rtd",,"AX",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'open', '=RTD("tos.rtd",,"OPEN",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'high', '=RTD("tos.rtd",,"HIGH",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'low', '=RTD("tos.rtd",,"LOW",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'close', '=RTD("tos.rtd",,"CLOSE",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'volume', '=RTD("tos.rtd",,"VOLUME",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'delta', '=RTD("tos.rtd",,"DELTA",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'gamma', '=RTD("tos.rtd",,"GAMMA",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'theta', '=RTD("tos.rtd",,"THETA",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'vega', '=RTD("tos.rtd",,"VEGA",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'rho', '=RTD("tos.rtd",,"RHO",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[CODE])', 1);

