CREATE TABLE IF NOT EXISTS `rtd`.`tos_option_data_s` (
    `code` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` SMALLINT NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` SMALLINT NULL,
    `ask_size` SMALLINT NULL,
    `bid_ask_size` VARCHAR(50) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` INTEGER NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `delta` DOUBLE NULL,
    `gamma` DOUBLE NULL,
    `theta` DOUBLE NULL,
    `vega` DOUBLE NULL,
    `rho` DOUBLE NULL,
    `extrinsic` DOUBLE NULL,
    `intrinsic` DOUBLE NULL,
    `probability_itm` DOUBLE NULL,
    `probability_otm` DOUBLE NULL,
    `probability_touch` DOUBLE NULL,
    `covered_return` DOUBLE NULL,
    `max_covered_return` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`code`, `date`, `time`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_option_data_s', 'SELECT CODE FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_option_data_s', 'code');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'time', '=Time0()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'description', '=RTD("tos.rtd",,"DESCRIPTION",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'last', '=RTD("tos.rtd",,"LAST",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'change', '=RTD("tos.rtd",,"NET_CHANGE",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'percent_change', '=RTD("tos.rtd",,"PERCENT_CHANGE",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'last_size', '=RTD("tos.rtd",,"LAST_SIZE",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'last_x', '=RTD("tos.rtd",,"LX",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'mark', '=RTD("tos.rtd",,"MARK",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'mark_change', '=RTD("tos.rtd",,"MARK_CHANGE",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'mark_percent_change', '=RTD("tos.rtd",,"MARK_PERCENT_CHANGE",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'bid', '=RTD("tos.rtd",,"BID",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'ask', '=RTD("tos.rtd",,"ASK",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'bid_size', '=RTD("tos.rtd",,"BID_SIZE",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'ask_size', '=RTD("tos.rtd",,"ASK_SIZE",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'bid_ask_size', '=RTD("tos.rtd",,"BA_SIZE",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'bid_x', '=RTD("tos.rtd",,"BX",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'ask_x', '=RTD("tos.rtd",,"AX",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'open', '=RTD("tos.rtd",,"OPEN",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'high', '=RTD("tos.rtd",,"HIGH",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'low', '=RTD("tos.rtd",,"LOW",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'close', '=RTD("tos.rtd",,"CLOSE",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'volume', '=RTD("tos.rtd",,"VOLUME",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'open_int', '=RTD("tos.rtd",,"OPEN_INT",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'implied_vol', '=RTD("tos.rtd",,"IMPL_VOL",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'delta', '=RTD("tos.rtd",,"DELTA",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'gamma', '=RTD("tos.rtd",,"GAMMA",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'theta', '=RTD("tos.rtd",,"THETA",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'vega', '=RTD("tos.rtd",,"VEGA",[CODE])', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'rho', '=RTD("tos.rtd",,"RHO",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'extrinsic', '=RTD("tos.rtd",,"EXTRINSIC",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'intrinsic', '=RTD("tos.rtd",,"INTRINSIC",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'probability_itm', '=RTD("tos.rtd",,"PROB_OF_EXPIRING",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'probability_otm', '=RTD("tos.rtd",,"PROB_OTM",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'probability_touch', '=RTD("tos.rtd",,"PROB_OF_TOUCHING",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'covered_return', '=RTD("tos.rtd",,"COVERED_RETURN",[CODE])', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'max_covered_return', '=RTD("tos.rtd",,"MAX_COVERED_RETURN",[CODE])', 1);

