CREATE TABLE IF NOT EXISTS `rtd`.`tos_option_data_ticks` (
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `code` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NULL,
    `date` DATE NULL,
    `time` TIME NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` SMALLINT NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` SMALLINT NULL,
    `ask_size` SMALLINT NULL,
    `bid_ask_size` VARCHAR(50) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` INTEGER NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `delta` DOUBLE NULL,
    `gamma` DOUBLE NULL,
    `theta` DOUBLE NULL,
    `vega` DOUBLE NULL,
    `rho` DOUBLE NULL,
    `extrinsic` DOUBLE NULL,
    `intrinsic` DOUBLE NULL,
    `probability_itm` DOUBLE NULL,
    `probability_otm` DOUBLE NULL,
    `probability_touch` DOUBLE NULL,
    `covered_return` DOUBLE NULL,
    `max_covered_return` DOUBLE NULL,
  PRIMARY KEY (`id`)
);


INSERT INTO `rtd`.`real_time_tables` (TABLE_SCHEMA, TABLE_NAME, LOAD_CODE, IS_HISTORY, IS_DISABLED, TIME_ZONE, RTD_INSTANCE_NAME) VALUES ('rtd', 'tos_option_data_ticks', 'SELECT CODE FROM rtd.tos_option_list', 1, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`) VALUES ('rtd', 'tos_option_data_ticks', 'id');
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`) VALUES ('rtd', 'tos_option_data_ticks', 'code');
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'time', '=Time()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'description', '=TOS|DESCRIPTION!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'last', '=TOS|LAST!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'change', '=TOS|NET_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'percent_change', '=TOS|PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'last_size', '=TOS|LAST_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'last_x', '=TOS|LX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'mark', '=TOS|MARK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'mark_change', '=TOS|MARK_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'bid', '=TOS|BID!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'ask', '=TOS|ASK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'bid_size', '=TOS|BID_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'ask_size', '=TOS|ASK_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'bid_ask_size', '=TOS|BA_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'bid_x', '=TOS|BX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'ask_x', '=TOS|AX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'open', '=TOS|OPEN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'high', '=TOS|HIGH!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'low', '=TOS|LOW!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'close', '=TOS|Close!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'volume', '=TOS|VOLUME!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'open_int', '=TOS|OPEN_INT!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'implied_vol', '=TOS|IMPL_VOL!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'delta', '=TOS|DELTA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'gamma', '=TOS|GAMMA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'theta', '=TOS|THETA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'vega', '=TOS|VEGA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'rho', '=TOS|RHO!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'extrinsic', '=TOS|EXTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'intrinsic', '=TOS|INTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'probability_otm', '=TOS|PROB_OTM!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'covered_return', '=TOS|COVERED_RETURN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_ticks', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[CODE]''', 1);

