CREATE TABLE IF NOT EXISTS `rtd`.`tos_option_data_01m` (
    `code` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` SMALLINT NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` SMALLINT NULL,
    `ask_size` SMALLINT NULL,
    `bid_ask_size` VARCHAR(50) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` INTEGER NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `delta` DOUBLE NULL,
    `gamma` DOUBLE NULL,
    `theta` DOUBLE NULL,
    `vega` DOUBLE NULL,
    `rho` DOUBLE NULL,
    `extrinsic` DOUBLE NULL,
    `intrinsic` DOUBLE NULL,
    `probability_itm` DOUBLE NULL,
    `probability_otm` DOUBLE NULL,
    `probability_touch` DOUBLE NULL,
    `covered_return` DOUBLE NULL,
    `max_covered_return` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`code`, `date`, `time`)
);


INSERT INTO `rtd`.`real_time_tables` (TABLE_SCHEMA, TABLE_NAME, LOAD_CODE, IS_HISTORY, IS_DISABLED, TIME_ZONE, RTD_INSTANCE_NAME) VALUES ('rtd', 'tos_option_data_01m', 'SELECT CODE FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`) VALUES ('rtd', 'tos_option_data_01m', 'code');
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'time', '=Time1()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'description', '=TOS|DESCRIPTION!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'last', '=TOS|LAST!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'change', '=TOS|NET_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'percent_change', '=TOS|PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'last_size', '=TOS|LAST_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'last_x', '=TOS|LX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'mark', '=TOS|MARK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'mark_change', '=TOS|MARK_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'bid', '=TOS|BID!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'ask', '=TOS|ASK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'bid_size', '=TOS|BID_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'ask_size', '=TOS|ASK_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'bid_ask_size', '=TOS|BA_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'bid_x', '=TOS|BX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'ask_x', '=TOS|AX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'open', '=TOS|OPEN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'high', '=TOS|HIGH!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'low', '=TOS|LOW!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'close', '=TOS|Close!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'volume', '=TOS|VOLUME!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'open_int', '=TOS|OPEN_INT!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'implied_vol', '=TOS|IMPL_VOL!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'delta', '=TOS|DELTA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'gamma', '=TOS|GAMMA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'theta', '=TOS|THETA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'vega', '=TOS|VEGA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'rho', '=TOS|RHO!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'extrinsic', '=TOS|EXTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'intrinsic', '=TOS|INTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'probability_otm', '=TOS|PROB_OTM!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'covered_return', '=TOS|COVERED_RETURN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_option_data_01m', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[CODE]''', 1);

