CREATE TABLE IF NOT EXISTS `rtd`.`tos_historical_prices` (
    `symbol` VARCHAR(50) NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` INTEGER NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` INTEGER NULL,
    `ask_size` INTEGER NULL,
    `bid_ask_size` VARCHAR(255) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `strength_meter` VARCHAR(255) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` BIGINT NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `vol_index` DOUBLE NULL,
    `front_vol` DOUBLE NULL,
    `back_vol` DOUBLE NULL,
    `weighted_back_vol` DOUBLE NULL,
    `vol_diff` DOUBLE NULL,
    `put_call_ratio` DOUBLE NULL,
    `call_volume_index` DOUBLE NULL,
    `put_volume_index` DOUBLE NULL,
    `option_volume_index` DOUBLE NULL,
    `front_expected_move` DOUBLE NULL,
    `back_expected_move` DOUBLE NULL,
    `expected_move_diff` DOUBLE NULL,
    `beta` DOUBLE NULL,
    `high52` DOUBLE NULL,
    `low52` DOUBLE NULL,
    `pe` DOUBLE NULL,
    `eps` DOUBLE NULL,
    `market_cap` VARCHAR(255) NULL,
    `shares` BIGINT NULL,
    `dividend_yield` DOUBLE NULL,
    `dividend_share` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`symbol`, `date`)
);


INSERT INTO `rtd`.`real_time_tables` (TABLE_SCHEMA, TABLE_NAME, LOAD_CODE, IS_HISTORY, IS_DISABLED, TIME_ZONE, RTD_INSTANCE_NAME) VALUES ('rtd', 'tos_historical_prices', 'SELECT SYMBOL FROM rtd.tos_stock_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`) VALUES ('rtd', 'tos_historical_prices', 'symbol');
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'time', '=Time()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'description', '=TOS|DESCRIPTION![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'last', '=TOS|LAST![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'change', '=TOS|NET_CHANGE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'percent_change', '=TOS|PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'last_size', '=TOS|LAST_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'last_x', '=TOS|LX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'mark', '=TOS|MARK![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'mark_change', '=TOS|MARK_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'bid', '=TOS|BID![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'ask', '=TOS|ASK![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'bid_size', '=TOS|BID_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'ask_size', '=TOS|ASK_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'bid_ask_size', '=TOS|BA_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'bid_x', '=TOS|BX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'ask_x', '=TOS|AX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'strength_meter', '=TOS|STRENGTH_METER![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'open', '=TOS|OPEN![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'high', '=TOS|HIGH![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'low', '=TOS|LOW![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'close', '=TOS|CLOSE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'volume', '=TOS|VOLUME![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'open_int', '=TOS|OPEN_INT![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'implied_vol', '=TOS|IMPL_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'vol_index', '=TOS|VOL_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'front_vol', '=TOS|FRONT_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'back_vol', '=TOS|BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'vol_diff', '=TOS|VOL_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'front_expected_move', '=TOS|FRONT_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'back_expected_move', '=TOS|BACK_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'beta', '=TOS|BETA![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'high52', '=TOS|''52HIGH''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'low52', '=TOS|''52LOW''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'pe', '=TOS|PE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'eps', '=TOS|EPS![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'market_cap', '=TOS|MARKET_CAP![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'shares', '=TOS|SHARES![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'dividend_yield', '=TOS|YIELD![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`TABLE_SCHEMA`, `TABLE_NAME`, `COLUMN_NAME`, `RTD_FORMULA`, `IS_DISABLED`) VALUES ('rtd', 'tos_historical_prices', 'dividend_share', '=TOS|DIV![SYMBOL]', NULL);

