CREATE SCHEMA IF NOT EXISTS `rtd`;

CREATE TABLE IF NOT EXISTS `rtd`.`real_time_formulas` (
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `table_schema` VARCHAR(128) NOT NULL,
    `table_name` VARCHAR(128) NOT NULL,
    `column_name` VARCHAR(128) NOT NULL,
    `rtd_formula` VARCHAR(255) NULL,
    `is_disabled` TINYINT NULL,
  PRIMARY KEY (`id`)
);

ALTER TABLE `rtd`.`real_time_formulas`
    ADD UNIQUE INDEX `ix_real_time_formulas_schema_name_column_name`
    USING BTREE (
       `table_schema`,
       `table_name`,
       `column_name`
    );


CREATE TABLE IF NOT EXISTS `rtd`.`real_time_tables` (
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `table_schema` VARCHAR(128) NOT NULL,
    `table_name` VARCHAR(128) NOT NULL,
    `load_code` VARCHAR(2000) NULL,
    `is_history` TINYINT NULL,
    `is_disabled` TINYINT NULL,
    `time_zone` VARCHAR(50) NULL,
    `rtd_instance_name` VARCHAR(50) NULL,
  PRIMARY KEY (`id`)
);

ALTER TABLE `rtd`.`real_time_tables`
    ADD UNIQUE INDEX `ix_realtimetables_schema_name`
    USING BTREE (
       `table_schema`,
       `table_name`
    );
    
CREATE TABLE IF NOT EXISTS `rtd`.`tos_stock_list` (
    `symbol` VARCHAR(50) NOT NULL,
  PRIMARY KEY (`symbol`)
);

INSERT INTO `rtd`.`tos_stock_list` (`symbol`) VALUES ('SPY');

CREATE TABLE IF NOT EXISTS `rtd`.`tos_option_list` (
    `code` VARCHAR(50) NOT NULL,
  PRIMARY KEY (`code`)
);


CREATE TABLE IF NOT EXISTS `rtd`.`tos_historical_option_data` (
    `code` VARCHAR(50) NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` SMALLINT NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` SMALLINT NULL,
    `ask_size` SMALLINT NULL,
    `bid_ask_size` VARCHAR(50) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` INTEGER NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `delta` DOUBLE NULL,
    `gamma` DOUBLE NULL,
    `theta` DOUBLE NULL,
    `vega` DOUBLE NULL,
    `rho` DOUBLE NULL,
    `extrinsic` DOUBLE NULL,
    `intrinsic` DOUBLE NULL,
    `probability_itm` DOUBLE NULL,
    `probability_otm` DOUBLE NULL,
    `probability_touch` DOUBLE NULL,
    `covered_return` DOUBLE NULL,
    `max_covered_return` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`code`, `date`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_historical_option_data', 'SELECT CODE FROM rtd.tos_option_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_historical_option_data', 'code');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'time', '=Time()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'description', '=TOS|DESCRIPTION!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'last', '=TOS|LAST!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'change', '=TOS|NET_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'percent_change', '=TOS|PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'last_size', '=TOS|LAST_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'last_x', '=TOS|LX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'mark', '=TOS|MARK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'mark_change', '=TOS|MARK_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'bid', '=TOS|BID!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'ask', '=TOS|ASK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'bid_size', '=TOS|BID_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'ask_size', '=TOS|ASK_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'bid_ask_size', '=TOS|BA_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'bid_x', '=TOS|BX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'ask_x', '=TOS|AX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'open', '=TOS|OPEN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'high', '=TOS|HIGH!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'low', '=TOS|LOW!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'close', '=TOS|Close!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'volume', '=TOS|VOLUME!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'open_int', '=TOS|OPEN_INT!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'implied_vol', '=TOS|IMPL_VOL!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'delta', '=TOS|DELTA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'gamma', '=TOS|GAMMA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'theta', '=TOS|THETA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'vega', '=TOS|VEGA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'rho', '=TOS|RHO!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'extrinsic', '=TOS|EXTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'intrinsic', '=TOS|INTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'probability_otm', '=TOS|PROB_OTM!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'covered_return', '=TOS|COVERED_RETURN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[CODE]''', 1);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_historical_prices` (
    `symbol` VARCHAR(50) NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` INTEGER NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` INTEGER NULL,
    `ask_size` INTEGER NULL,
    `bid_ask_size` VARCHAR(255) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `strength_meter` VARCHAR(255) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` BIGINT NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `vol_index` DOUBLE NULL,
    `front_vol` DOUBLE NULL,
    `back_vol` DOUBLE NULL,
    `weighted_back_vol` DOUBLE NULL,
    `vol_diff` DOUBLE NULL,
    `put_call_ratio` DOUBLE NULL,
    `call_volume_index` DOUBLE NULL,
    `put_volume_index` DOUBLE NULL,
    `option_volume_index` DOUBLE NULL,
    `front_expected_move` DOUBLE NULL,
    `back_expected_move` DOUBLE NULL,
    `expected_move_diff` DOUBLE NULL,
    `beta` DOUBLE NULL,
    `high52` DOUBLE NULL,
    `low52` DOUBLE NULL,
    `pe` DOUBLE NULL,
    `eps` DOUBLE NULL,
    `market_cap` VARCHAR(255) NULL,
    `shares` BIGINT NULL,
    `dividend_yield` DOUBLE NULL,
    `dividend_share` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`symbol`, `date`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_historical_prices', 'SELECT SYMBOL FROM rtd.tos_stock_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_historical_prices', 'symbol');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'time', '=Time()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'description', '=TOS|DESCRIPTION![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'last', '=TOS|LAST![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'change', '=TOS|NET_CHANGE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'percent_change', '=TOS|PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'last_size', '=TOS|LAST_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'last_x', '=TOS|LX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'mark', '=TOS|MARK![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'mark_change', '=TOS|MARK_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'bid', '=TOS|BID![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'ask', '=TOS|ASK![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'bid_size', '=TOS|BID_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'ask_size', '=TOS|ASK_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'bid_ask_size', '=TOS|BA_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'bid_x', '=TOS|BX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'ask_x', '=TOS|AX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'strength_meter', '=TOS|STRENGTH_METER![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'open', '=TOS|OPEN![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'high', '=TOS|HIGH![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'low', '=TOS|LOW![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'close', '=TOS|CLOSE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'volume', '=TOS|VOLUME![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'open_int', '=TOS|OPEN_INT![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'implied_vol', '=TOS|IMPL_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'vol_index', '=TOS|VOL_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'front_vol', '=TOS|FRONT_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'back_vol', '=TOS|BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'vol_diff', '=TOS|VOL_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'front_expected_move', '=TOS|FRONT_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'back_expected_move', '=TOS|BACK_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'beta', '=TOS|BETA![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'high52', '=TOS|''52HIGH''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'low52', '=TOS|''52LOW''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'pe', '=TOS|PE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'eps', '=TOS|EPS![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'market_cap', '=TOS|MARKET_CAP![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'shares', '=TOS|SHARES![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'dividend_yield', '=TOS|YIELD![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'dividend_share', '=TOS|DIV![SYMBOL]', NULL);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_last_option_data` (
    `code` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NULL,
    `date` DATE NULL,
    `time` TIME NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` SMALLINT NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` SMALLINT NULL,
    `ask_size` SMALLINT NULL,
    `bid_ask_size` VARCHAR(50) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` INTEGER NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `delta` DOUBLE NULL,
    `gamma` DOUBLE NULL,
    `theta` DOUBLE NULL,
    `vega` DOUBLE NULL,
    `rho` DOUBLE NULL,
    `extrinsic` DOUBLE NULL,
    `intrinsic` DOUBLE NULL,
    `probability_itm` DOUBLE NULL,
    `probability_otm` DOUBLE NULL,
    `probability_touch` DOUBLE NULL,
    `covered_return` DOUBLE NULL,
    `max_covered_return` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`code`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_last_option_data', 'SELECT CODE FROM rtd.tos_option_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_last_option_data', 'code');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'time', '=Time()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'description', '=TOS|DESCRIPTION!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'last', '=TOS|LAST!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'change', '=TOS|NET_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'percent_change', '=TOS|PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'last_size', '=TOS|LAST_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'last_x', '=TOS|LX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'mark', '=TOS|MARK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'mark_change', '=TOS|MARK_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'bid', '=TOS|BID!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'ask', '=TOS|ASK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'bid_size', '=TOS|BID_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'ask_size', '=TOS|ASK_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'bid_ask_size', '=TOS|BA_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'bid_x', '=TOS|BX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'ask_x', '=TOS|AX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'open', '=TOS|OPEN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'high', '=TOS|HIGH!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'low', '=TOS|LOW!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'close', '=TOS|Close!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'volume', '=TOS|VOLUME!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'open_int', '=TOS|OPEN_INT!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'implied_vol', '=TOS|IMPL_VOL!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'delta', '=TOS|DELTA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'gamma', '=TOS|GAMMA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'theta', '=TOS|THETA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'vega', '=TOS|VEGA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'rho', '=TOS|RHO!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'extrinsic', '=TOS|EXTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'intrinsic', '=TOS|INTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'probability_otm', '=TOS|PROB_OTM!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'covered_return', '=TOS|COVERED_RETURN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[CODE]''', 1);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_last_stock_quotes` (
    `symbol` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NULL,
    `time` TIME NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` INTEGER NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` INTEGER NULL,
    `ask_size` INTEGER NULL,
    `bid_ask_size` VARCHAR(255) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `strength_meter` VARCHAR(255) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` BIGINT NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `vol_index` DOUBLE NULL,
    `front_vol` DOUBLE NULL,
    `back_vol` DOUBLE NULL,
    `weighted_back_vol` DOUBLE NULL,
    `vol_diff` DOUBLE NULL,
    `put_call_ratio` DOUBLE NULL,
    `call_volume_index` DOUBLE NULL,
    `put_volume_index` DOUBLE NULL,
    `option_volume_index` DOUBLE NULL,
    `front_expected_move` DOUBLE NULL,
    `back_expected_move` DOUBLE NULL,
    `expected_move_diff` DOUBLE NULL,
    `beta` DOUBLE NULL,
    `high52` DOUBLE NULL,
    `low52` DOUBLE NULL,
    `pe` DOUBLE NULL,
    `eps` DOUBLE NULL,
    `market_cap` VARCHAR(255) NULL,
    `shares` BIGINT NULL,
    `dividend_yield` DOUBLE NULL,
    `dividend_share` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`symbol`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_last_stock_quotes', 'SELECT SYMBOL FROM rtd.tos_stock_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_last_stock_quotes', 'symbol');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'time', '=Time()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'description', '=TOS|DESCRIPTION![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'last', '=TOS|LAST![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'change', '=TOS|NET_CHANGE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'percent_change', '=TOS|PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'last_size', '=TOS|LAST_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'last_x', '=TOS|LX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'mark', '=TOS|MARK![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'mark_change', '=TOS|MARK_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'bid', '=TOS|BID![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'ask', '=TOS|ASK![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'bid_size', '=TOS|BID_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'ask_size', '=TOS|ASK_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'bid_ask_size', '=TOS|BA_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'bid_x', '=TOS|BX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'ask_x', '=TOS|AX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'strength_meter', '=TOS|STRENGTH_METER![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'open', '=TOS|OPEN![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'high', '=TOS|HIGH![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'low', '=TOS|LOW![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'close', '=TOS|CLOSE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'volume', '=TOS|VOLUME![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'open_int', '=TOS|OPEN_INT![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'implied_vol', '=TOS|IMPL_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'vol_index', '=TOS|VOL_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'front_vol', '=TOS|FRONT_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'back_vol', '=TOS|BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'vol_diff', '=TOS|VOL_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'front_expected_move', '=TOS|FRONT_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'back_expected_move', '=TOS|BACK_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'beta', '=TOS|BETA![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'high52', '=TOS|''52HIGH''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'low52', '=TOS|''52LOW''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'pe', '=TOS|PE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'eps', '=TOS|EPS![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'market_cap', '=TOS|MARKET_CAP![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'shares', '=TOS|SHARES![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'dividend_yield', '=TOS|YIELD![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'dividend_share', '=TOS|DIV![SYMBOL]', NULL);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_option_data_s` (
    `code` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` SMALLINT NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` SMALLINT NULL,
    `ask_size` SMALLINT NULL,
    `bid_ask_size` VARCHAR(50) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` INTEGER NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `delta` DOUBLE NULL,
    `gamma` DOUBLE NULL,
    `theta` DOUBLE NULL,
    `vega` DOUBLE NULL,
    `rho` DOUBLE NULL,
    `extrinsic` DOUBLE NULL,
    `intrinsic` DOUBLE NULL,
    `probability_itm` DOUBLE NULL,
    `probability_otm` DOUBLE NULL,
    `probability_touch` DOUBLE NULL,
    `covered_return` DOUBLE NULL,
    `max_covered_return` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`code`, `date`, `time`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_option_data_s', 'SELECT CODE FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_option_data_s', 'code');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'time', '=Time0()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'description', '=TOS|DESCRIPTION!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'last', '=TOS|LAST!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'change', '=TOS|NET_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'percent_change', '=TOS|PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'last_size', '=TOS|LAST_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'last_x', '=TOS|LX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'mark', '=TOS|MARK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'mark_change', '=TOS|MARK_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'bid', '=TOS|BID!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'ask', '=TOS|ASK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'bid_size', '=TOS|BID_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'ask_size', '=TOS|ASK_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'bid_ask_size', '=TOS|BA_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'bid_x', '=TOS|BX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'ask_x', '=TOS|AX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'open', '=TOS|OPEN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'high', '=TOS|HIGH!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'low', '=TOS|LOW!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'close', '=TOS|Close!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'volume', '=TOS|VOLUME!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'open_int', '=TOS|OPEN_INT!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'implied_vol', '=TOS|IMPL_VOL!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'delta', '=TOS|DELTA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'gamma', '=TOS|GAMMA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'theta', '=TOS|THETA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'vega', '=TOS|VEGA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'rho', '=TOS|RHO!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'extrinsic', '=TOS|EXTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'intrinsic', '=TOS|INTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'probability_otm', '=TOS|PROB_OTM!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'covered_return', '=TOS|COVERED_RETURN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[CODE]''', 1);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_stock_quotes_s` (
    `symbol` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` INTEGER NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` INTEGER NULL,
    `ask_size` INTEGER NULL,
    `bid_ask_size` VARCHAR(255) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `strength_meter` VARCHAR(255) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` BIGINT NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `vol_index` DOUBLE NULL,
    `front_vol` DOUBLE NULL,
    `back_vol` DOUBLE NULL,
    `weighted_back_vol` DOUBLE NULL,
    `vol_diff` DOUBLE NULL,
    `put_call_ratio` DOUBLE NULL,
    `call_volume_index` DOUBLE NULL,
    `put_volume_index` DOUBLE NULL,
    `option_volume_index` DOUBLE NULL,
    `front_expected_move` DOUBLE NULL,
    `back_expected_move` DOUBLE NULL,
    `expected_move_diff` DOUBLE NULL,
    `beta` DOUBLE NULL,
    `high52` DOUBLE NULL,
    `low52` DOUBLE NULL,
    `pe` DOUBLE NULL,
    `eps` DOUBLE NULL,
    `market_cap` VARCHAR(255) NULL,
    `shares` BIGINT NULL,
    `dividend_yield` DOUBLE NULL,
    `dividend_share` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`symbol`, `date`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_stock_quotes_s', 'SELECT SYMBOL FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_stock_quotes_s', 'symbol');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'time', '=Time0()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'description', '=TOS|DESCRIPTION![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'last', '=TOS|LAST![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'change', '=TOS|NET_CHANGE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'percent_change', '=TOS|PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'last_size', '=TOS|LAST_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'last_x', '=TOS|LX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'mark', '=TOS|MARK![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'mark_change', '=TOS|MARK_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'bid', '=TOS|BID![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'ask', '=TOS|ASK![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'bid_size', '=TOS|BID_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'ask_size', '=TOS|ASK_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'bid_ask_size', '=TOS|BA_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'bid_x', '=TOS|BX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'ask_x', '=TOS|AX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'strength_meter', '=TOS|STRENGTH_METER![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'open', '=TOS|OPEN![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'high', '=TOS|HIGH![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'low', '=TOS|LOW![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'close', '=TOS|CLOSE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'volume', '=TOS|VOLUME![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'open_int', '=TOS|OPEN_INT![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'implied_vol', '=TOS|IMPL_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'vol_index', '=TOS|VOL_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'front_vol', '=TOS|FRONT_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'back_vol', '=TOS|BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'vol_diff', '=TOS|VOL_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'front_expected_move', '=TOS|FRONT_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'back_expected_move', '=TOS|BACK_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'beta', '=TOS|BETA![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'high52', '=TOS|''52HIGH''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'low52', '=TOS|''52LOW''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'pe', '=TOS|PE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'eps', '=TOS|EPS![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'market_cap', '=TOS|MARKET_CAP![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'shares', '=TOS|SHARES![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'dividend_yield', '=TOS|YIELD![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'dividend_share', '=TOS|DIV![SYMBOL]', NULL);

