CREATE SCHEMA IF NOT EXISTS `rtd`;

CREATE TABLE IF NOT EXISTS `rtd`.`real_time_formulas` (
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `table_schema` VARCHAR(128) NOT NULL,
    `table_name` VARCHAR(128) NOT NULL,
    `column_name` VARCHAR(128) NOT NULL,
    `rtd_formula` VARCHAR(255) NULL,
    `is_disabled` TINYINT NULL,
  PRIMARY KEY (`id`)
);

ALTER TABLE `rtd`.`real_time_formulas`
    ADD UNIQUE INDEX `ix_real_time_formulas_schema_name_column_name`
    USING BTREE (
       `table_schema`,
       `table_name`,
       `column_name`
    );


CREATE TABLE IF NOT EXISTS `rtd`.`real_time_tables` (
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `table_schema` VARCHAR(128) NOT NULL,
    `table_name` VARCHAR(128) NOT NULL,
    `load_code` VARCHAR(2000) NULL,
    `is_history` TINYINT NULL,
    `is_disabled` TINYINT NULL,
    `time_zone` VARCHAR(50) NULL,
    `rtd_instance_name` VARCHAR(50) NULL,
  PRIMARY KEY (`id`)
);

ALTER TABLE `rtd`.`real_time_tables`
    ADD UNIQUE INDEX `ix_realtimetables_schema_name`
    USING BTREE (
       `table_schema`,
       `table_name`
    );
    
CREATE TABLE IF NOT EXISTS `rtd`.`tos_stock_list` (
    `symbol` VARCHAR(50) NOT NULL,
  PRIMARY KEY (`symbol`)
);

INSERT INTO `rtd`.`tos_stock_list` (`symbol`) VALUES ('SPY');

CREATE TABLE IF NOT EXISTS `rtd`.`tos_option_list` (
    `code` VARCHAR(50) NOT NULL,
  PRIMARY KEY (`code`)
);


CREATE TABLE IF NOT EXISTS `rtd`.`tos_historical_option_data` (
    `code` VARCHAR(50) NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` SMALLINT NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` SMALLINT NULL,
    `ask_size` SMALLINT NULL,
    `bid_ask_size` VARCHAR(50) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` INTEGER NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `delta` DOUBLE NULL,
    `gamma` DOUBLE NULL,
    `theta` DOUBLE NULL,
    `vega` DOUBLE NULL,
    `rho` DOUBLE NULL,
    `extrinsic` DOUBLE NULL,
    `intrinsic` DOUBLE NULL,
    `probability_itm` DOUBLE NULL,
    `probability_otm` DOUBLE NULL,
    `probability_touch` DOUBLE NULL,
    `covered_return` DOUBLE NULL,
    `max_covered_return` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`code`, `date`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_historical_option_data', 'SELECT CODE FROM rtd.tos_option_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_historical_option_data', 'code');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'time', '=Time()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'description', '=TOS|DESCRIPTION!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'last', '=TOS|LAST!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'change', '=TOS|NET_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'percent_change', '=TOS|PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'last_size', '=TOS|LAST_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'last_x', '=TOS|LX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'mark', '=TOS|MARK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'mark_change', '=TOS|MARK_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'bid', '=TOS|BID!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'ask', '=TOS|ASK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'bid_size', '=TOS|BID_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'ask_size', '=TOS|ASK_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'bid_ask_size', '=TOS|BA_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'bid_x', '=TOS|BX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'ask_x', '=TOS|AX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'open', '=TOS|OPEN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'high', '=TOS|HIGH!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'low', '=TOS|LOW!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'close', '=TOS|Close!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'volume', '=TOS|VOLUME!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'open_int', '=TOS|OPEN_INT!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'implied_vol', '=TOS|IMPL_VOL!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'delta', '=TOS|DELTA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'gamma', '=TOS|GAMMA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'theta', '=TOS|THETA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'vega', '=TOS|VEGA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'rho', '=TOS|RHO!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'extrinsic', '=TOS|EXTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'intrinsic', '=TOS|INTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'probability_otm', '=TOS|PROB_OTM!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'covered_return', '=TOS|COVERED_RETURN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_option_data', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[CODE]''', 1);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_historical_prices` (
    `symbol` VARCHAR(50) NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` INTEGER NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` INTEGER NULL,
    `ask_size` INTEGER NULL,
    `bid_ask_size` VARCHAR(255) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `strength_meter` VARCHAR(255) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` BIGINT NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `vol_index` DOUBLE NULL,
    `front_vol` DOUBLE NULL,
    `back_vol` DOUBLE NULL,
    `weighted_back_vol` DOUBLE NULL,
    `vol_diff` DOUBLE NULL,
    `put_call_ratio` DOUBLE NULL,
    `call_volume_index` DOUBLE NULL,
    `put_volume_index` DOUBLE NULL,
    `option_volume_index` DOUBLE NULL,
    `front_expected_move` DOUBLE NULL,
    `back_expected_move` DOUBLE NULL,
    `expected_move_diff` DOUBLE NULL,
    `beta` DOUBLE NULL,
    `high52` DOUBLE NULL,
    `low52` DOUBLE NULL,
    `pe` DOUBLE NULL,
    `eps` DOUBLE NULL,
    `market_cap` VARCHAR(255) NULL,
    `shares` BIGINT NULL,
    `dividend_yield` DOUBLE NULL,
    `dividend_share` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`symbol`, `date`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_historical_prices', 'SELECT SYMBOL FROM rtd.tos_stock_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_historical_prices', 'symbol');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'time', '=Time()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'description', '=TOS|DESCRIPTION![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'last', '=TOS|LAST![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'change', '=TOS|NET_CHANGE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'percent_change', '=TOS|PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'last_size', '=TOS|LAST_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'last_x', '=TOS|LX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'mark', '=TOS|MARK![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'mark_change', '=TOS|MARK_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'bid', '=TOS|BID![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'ask', '=TOS|ASK![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'bid_size', '=TOS|BID_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'ask_size', '=TOS|ASK_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'bid_ask_size', '=TOS|BA_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'bid_x', '=TOS|BX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'ask_x', '=TOS|AX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'strength_meter', '=TOS|STRENGTH_METER![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'open', '=TOS|OPEN![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'high', '=TOS|HIGH![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'low', '=TOS|LOW![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'close', '=TOS|CLOSE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'volume', '=TOS|VOLUME![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'open_int', '=TOS|OPEN_INT![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'implied_vol', '=TOS|IMPL_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'vol_index', '=TOS|VOL_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'front_vol', '=TOS|FRONT_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'back_vol', '=TOS|BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'vol_diff', '=TOS|VOL_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'front_expected_move', '=TOS|FRONT_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'back_expected_move', '=TOS|BACK_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'beta', '=TOS|BETA![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'high52', '=TOS|''52HIGH''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'low52', '=TOS|''52LOW''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'pe', '=TOS|PE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'eps', '=TOS|EPS![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'market_cap', '=TOS|MARKET_CAP![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'shares', '=TOS|SHARES![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'dividend_yield', '=TOS|YIELD![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_historical_prices', 'dividend_share', '=TOS|DIV![SYMBOL]', NULL);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_last_option_data` (
    `code` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NULL,
    `date` DATE NULL,
    `time` TIME NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` SMALLINT NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` SMALLINT NULL,
    `ask_size` SMALLINT NULL,
    `bid_ask_size` VARCHAR(50) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` INTEGER NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `delta` DOUBLE NULL,
    `gamma` DOUBLE NULL,
    `theta` DOUBLE NULL,
    `vega` DOUBLE NULL,
    `rho` DOUBLE NULL,
    `extrinsic` DOUBLE NULL,
    `intrinsic` DOUBLE NULL,
    `probability_itm` DOUBLE NULL,
    `probability_otm` DOUBLE NULL,
    `probability_touch` DOUBLE NULL,
    `covered_return` DOUBLE NULL,
    `max_covered_return` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`code`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_last_option_data', 'SELECT CODE FROM rtd.tos_option_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_last_option_data', 'code');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'time', '=Time()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'description', '=TOS|DESCRIPTION!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'last', '=TOS|LAST!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'change', '=TOS|NET_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'percent_change', '=TOS|PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'last_size', '=TOS|LAST_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'last_x', '=TOS|LX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'mark', '=TOS|MARK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'mark_change', '=TOS|MARK_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'bid', '=TOS|BID!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'ask', '=TOS|ASK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'bid_size', '=TOS|BID_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'ask_size', '=TOS|ASK_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'bid_ask_size', '=TOS|BA_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'bid_x', '=TOS|BX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'ask_x', '=TOS|AX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'open', '=TOS|OPEN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'high', '=TOS|HIGH!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'low', '=TOS|LOW!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'close', '=TOS|Close!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'volume', '=TOS|VOLUME!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'open_int', '=TOS|OPEN_INT!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'implied_vol', '=TOS|IMPL_VOL!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'delta', '=TOS|DELTA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'gamma', '=TOS|GAMMA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'theta', '=TOS|THETA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'vega', '=TOS|VEGA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'rho', '=TOS|RHO!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'extrinsic', '=TOS|EXTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'intrinsic', '=TOS|INTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'probability_otm', '=TOS|PROB_OTM!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'covered_return', '=TOS|COVERED_RETURN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_option_data', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[CODE]''', 1);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_last_stock_quotes` (
    `symbol` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NULL,
    `time` TIME NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` INTEGER NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` INTEGER NULL,
    `ask_size` INTEGER NULL,
    `bid_ask_size` VARCHAR(255) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `strength_meter` VARCHAR(255) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` BIGINT NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `vol_index` DOUBLE NULL,
    `front_vol` DOUBLE NULL,
    `back_vol` DOUBLE NULL,
    `weighted_back_vol` DOUBLE NULL,
    `vol_diff` DOUBLE NULL,
    `put_call_ratio` DOUBLE NULL,
    `call_volume_index` DOUBLE NULL,
    `put_volume_index` DOUBLE NULL,
    `option_volume_index` DOUBLE NULL,
    `front_expected_move` DOUBLE NULL,
    `back_expected_move` DOUBLE NULL,
    `expected_move_diff` DOUBLE NULL,
    `beta` DOUBLE NULL,
    `high52` DOUBLE NULL,
    `low52` DOUBLE NULL,
    `pe` DOUBLE NULL,
    `eps` DOUBLE NULL,
    `market_cap` VARCHAR(255) NULL,
    `shares` BIGINT NULL,
    `dividend_yield` DOUBLE NULL,
    `dividend_share` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`symbol`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_last_stock_quotes', 'SELECT SYMBOL FROM rtd.tos_stock_list', NULL, NULL, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_last_stock_quotes', 'symbol');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'time', '=Time()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'description', '=TOS|DESCRIPTION![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'last', '=TOS|LAST![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'change', '=TOS|NET_CHANGE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'percent_change', '=TOS|PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'last_size', '=TOS|LAST_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'last_x', '=TOS|LX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'mark', '=TOS|MARK![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'mark_change', '=TOS|MARK_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'bid', '=TOS|BID![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'ask', '=TOS|ASK![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'bid_size', '=TOS|BID_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'ask_size', '=TOS|ASK_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'bid_ask_size', '=TOS|BA_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'bid_x', '=TOS|BX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'ask_x', '=TOS|AX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'strength_meter', '=TOS|STRENGTH_METER![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'open', '=TOS|OPEN![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'high', '=TOS|HIGH![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'low', '=TOS|LOW![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'close', '=TOS|CLOSE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'volume', '=TOS|VOLUME![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'open_int', '=TOS|OPEN_INT![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'implied_vol', '=TOS|IMPL_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'vol_index', '=TOS|VOL_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'front_vol', '=TOS|FRONT_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'back_vol', '=TOS|BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'vol_diff', '=TOS|VOL_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'front_expected_move', '=TOS|FRONT_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'back_expected_move', '=TOS|BACK_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'beta', '=TOS|BETA![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'high52', '=TOS|''52HIGH''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'low52', '=TOS|''52LOW''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'pe', '=TOS|PE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'eps', '=TOS|EPS![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'market_cap', '=TOS|MARKET_CAP![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'shares', '=TOS|SHARES![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'dividend_yield', '=TOS|YIELD![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_last_stock_quotes', 'dividend_share', '=TOS|DIV![SYMBOL]', NULL);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_option_data_01m` (
    `code` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` SMALLINT NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` SMALLINT NULL,
    `ask_size` SMALLINT NULL,
    `bid_ask_size` VARCHAR(50) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` INTEGER NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `delta` DOUBLE NULL,
    `gamma` DOUBLE NULL,
    `theta` DOUBLE NULL,
    `vega` DOUBLE NULL,
    `rho` DOUBLE NULL,
    `extrinsic` DOUBLE NULL,
    `intrinsic` DOUBLE NULL,
    `probability_itm` DOUBLE NULL,
    `probability_otm` DOUBLE NULL,
    `probability_touch` DOUBLE NULL,
    `covered_return` DOUBLE NULL,
    `max_covered_return` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`code`, `date`, `time`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_option_data_01m', 'SELECT CODE FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_option_data_01m', 'code');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'time', '=Time1()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'description', '=TOS|DESCRIPTION!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'last', '=TOS|LAST!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'change', '=TOS|NET_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'percent_change', '=TOS|PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'last_size', '=TOS|LAST_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'last_x', '=TOS|LX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'mark', '=TOS|MARK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'mark_change', '=TOS|MARK_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'bid', '=TOS|BID!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'ask', '=TOS|ASK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'bid_size', '=TOS|BID_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'ask_size', '=TOS|ASK_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'bid_ask_size', '=TOS|BA_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'bid_x', '=TOS|BX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'ask_x', '=TOS|AX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'open', '=TOS|OPEN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'high', '=TOS|HIGH!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'low', '=TOS|LOW!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'close', '=TOS|Close!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'volume', '=TOS|VOLUME!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'open_int', '=TOS|OPEN_INT!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'implied_vol', '=TOS|IMPL_VOL!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'delta', '=TOS|DELTA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'gamma', '=TOS|GAMMA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'theta', '=TOS|THETA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'vega', '=TOS|VEGA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'rho', '=TOS|RHO!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'extrinsic', '=TOS|EXTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'intrinsic', '=TOS|INTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'probability_otm', '=TOS|PROB_OTM!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'covered_return', '=TOS|COVERED_RETURN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_01m', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[CODE]''', 1);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_option_data_05m` (
    `code` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` SMALLINT NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` SMALLINT NULL,
    `ask_size` SMALLINT NULL,
    `bid_ask_size` VARCHAR(50) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` INTEGER NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `delta` DOUBLE NULL,
    `gamma` DOUBLE NULL,
    `theta` DOUBLE NULL,
    `vega` DOUBLE NULL,
    `rho` DOUBLE NULL,
    `extrinsic` DOUBLE NULL,
    `intrinsic` DOUBLE NULL,
    `probability_itm` DOUBLE NULL,
    `probability_otm` DOUBLE NULL,
    `probability_touch` DOUBLE NULL,
    `covered_return` DOUBLE NULL,
    `max_covered_return` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`code`, `date`, `time`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_option_data_05m', 'SELECT CODE FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_option_data_05m', 'code');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'time', '=Time5()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'description', '=TOS|DESCRIPTION!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'last', '=TOS|LAST!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'change', '=TOS|NET_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'percent_change', '=TOS|PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'last_size', '=TOS|LAST_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'last_x', '=TOS|LX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'mark', '=TOS|MARK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'mark_change', '=TOS|MARK_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'bid', '=TOS|BID!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'ask', '=TOS|ASK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'bid_size', '=TOS|BID_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'ask_size', '=TOS|ASK_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'bid_ask_size', '=TOS|BA_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'bid_x', '=TOS|BX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'ask_x', '=TOS|AX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'open', '=TOS|OPEN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'high', '=TOS|HIGH!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'low', '=TOS|LOW!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'close', '=TOS|Close!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'volume', '=TOS|VOLUME!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'open_int', '=TOS|OPEN_INT!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'implied_vol', '=TOS|IMPL_VOL!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'delta', '=TOS|DELTA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'gamma', '=TOS|GAMMA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'theta', '=TOS|THETA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'vega', '=TOS|VEGA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'rho', '=TOS|RHO!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'extrinsic', '=TOS|EXTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'intrinsic', '=TOS|INTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'probability_otm', '=TOS|PROB_OTM!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'covered_return', '=TOS|COVERED_RETURN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_05m', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[CODE]''', 1);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_option_data_10m` (
    `code` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` SMALLINT NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` SMALLINT NULL,
    `ask_size` SMALLINT NULL,
    `bid_ask_size` VARCHAR(50) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` INTEGER NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `delta` DOUBLE NULL,
    `gamma` DOUBLE NULL,
    `theta` DOUBLE NULL,
    `vega` DOUBLE NULL,
    `rho` DOUBLE NULL,
    `extrinsic` DOUBLE NULL,
    `intrinsic` DOUBLE NULL,
    `probability_itm` DOUBLE NULL,
    `probability_otm` DOUBLE NULL,
    `probability_touch` DOUBLE NULL,
    `covered_return` DOUBLE NULL,
    `max_covered_return` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`code`, `date`, `time`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_option_data_10m', 'SELECT CODE FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_option_data_10m', 'code');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'time', '=Time10()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'description', '=TOS|DESCRIPTION!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'last', '=TOS|LAST!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'change', '=TOS|NET_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'percent_change', '=TOS|PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'last_size', '=TOS|LAST_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'last_x', '=TOS|LX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'mark', '=TOS|MARK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'mark_change', '=TOS|MARK_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'bid', '=TOS|BID!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'ask', '=TOS|ASK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'bid_size', '=TOS|BID_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'ask_size', '=TOS|ASK_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'bid_ask_size', '=TOS|BA_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'bid_x', '=TOS|BX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'ask_x', '=TOS|AX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'open', '=TOS|OPEN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'high', '=TOS|HIGH!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'low', '=TOS|LOW!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'close', '=TOS|Close!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'volume', '=TOS|VOLUME!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'open_int', '=TOS|OPEN_INT!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'implied_vol', '=TOS|IMPL_VOL!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'delta', '=TOS|DELTA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'gamma', '=TOS|GAMMA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'theta', '=TOS|THETA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'vega', '=TOS|VEGA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'rho', '=TOS|RHO!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'extrinsic', '=TOS|EXTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'intrinsic', '=TOS|INTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'probability_otm', '=TOS|PROB_OTM!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'covered_return', '=TOS|COVERED_RETURN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_10m', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[CODE]''', 1);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_option_data_15m` (
    `code` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` SMALLINT NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` SMALLINT NULL,
    `ask_size` SMALLINT NULL,
    `bid_ask_size` VARCHAR(50) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` INTEGER NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `delta` DOUBLE NULL,
    `gamma` DOUBLE NULL,
    `theta` DOUBLE NULL,
    `vega` DOUBLE NULL,
    `rho` DOUBLE NULL,
    `extrinsic` DOUBLE NULL,
    `intrinsic` DOUBLE NULL,
    `probability_itm` DOUBLE NULL,
    `probability_otm` DOUBLE NULL,
    `probability_touch` DOUBLE NULL,
    `covered_return` DOUBLE NULL,
    `max_covered_return` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`code`, `date`, `time`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_option_data_15m', 'SELECT CODE FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_option_data_15m', 'code');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'time', '=Time15()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'description', '=TOS|DESCRIPTION!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'last', '=TOS|LAST!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'change', '=TOS|NET_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'percent_change', '=TOS|PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'last_size', '=TOS|LAST_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'last_x', '=TOS|LX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'mark', '=TOS|MARK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'mark_change', '=TOS|MARK_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'bid', '=TOS|BID!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'ask', '=TOS|ASK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'bid_size', '=TOS|BID_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'ask_size', '=TOS|ASK_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'bid_ask_size', '=TOS|BA_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'bid_x', '=TOS|BX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'ask_x', '=TOS|AX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'open', '=TOS|OPEN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'high', '=TOS|HIGH!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'low', '=TOS|LOW!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'close', '=TOS|Close!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'volume', '=TOS|VOLUME!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'open_int', '=TOS|OPEN_INT!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'implied_vol', '=TOS|IMPL_VOL!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'delta', '=TOS|DELTA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'gamma', '=TOS|GAMMA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'theta', '=TOS|THETA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'vega', '=TOS|VEGA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'rho', '=TOS|RHO!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'extrinsic', '=TOS|EXTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'intrinsic', '=TOS|INTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'probability_otm', '=TOS|PROB_OTM!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'covered_return', '=TOS|COVERED_RETURN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_15m', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[CODE]''', 1);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_option_data_20m` (
    `code` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` SMALLINT NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` SMALLINT NULL,
    `ask_size` SMALLINT NULL,
    `bid_ask_size` VARCHAR(50) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` INTEGER NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `delta` DOUBLE NULL,
    `gamma` DOUBLE NULL,
    `theta` DOUBLE NULL,
    `vega` DOUBLE NULL,
    `rho` DOUBLE NULL,
    `extrinsic` DOUBLE NULL,
    `intrinsic` DOUBLE NULL,
    `probability_itm` DOUBLE NULL,
    `probability_otm` DOUBLE NULL,
    `probability_touch` DOUBLE NULL,
    `covered_return` DOUBLE NULL,
    `max_covered_return` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`code`, `date`, `time`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_option_data_20m', 'SELECT CODE FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_option_data_20m', 'code');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'time', '=Time20()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'description', '=TOS|DESCRIPTION!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'last', '=TOS|LAST!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'change', '=TOS|NET_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'percent_change', '=TOS|PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'last_size', '=TOS|LAST_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'last_x', '=TOS|LX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'mark', '=TOS|MARK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'mark_change', '=TOS|MARK_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'bid', '=TOS|BID!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'ask', '=TOS|ASK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'bid_size', '=TOS|BID_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'ask_size', '=TOS|ASK_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'bid_ask_size', '=TOS|BA_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'bid_x', '=TOS|BX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'ask_x', '=TOS|AX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'open', '=TOS|OPEN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'high', '=TOS|HIGH!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'low', '=TOS|LOW!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'close', '=TOS|Close!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'volume', '=TOS|VOLUME!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'open_int', '=TOS|OPEN_INT!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'implied_vol', '=TOS|IMPL_VOL!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'delta', '=TOS|DELTA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'gamma', '=TOS|GAMMA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'theta', '=TOS|THETA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'vega', '=TOS|VEGA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'rho', '=TOS|RHO!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'extrinsic', '=TOS|EXTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'intrinsic', '=TOS|INTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'probability_otm', '=TOS|PROB_OTM!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'covered_return', '=TOS|COVERED_RETURN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_20m', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[CODE]''', 1);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_option_data_30m` (
    `code` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` SMALLINT NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` SMALLINT NULL,
    `ask_size` SMALLINT NULL,
    `bid_ask_size` VARCHAR(50) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` INTEGER NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `delta` DOUBLE NULL,
    `gamma` DOUBLE NULL,
    `theta` DOUBLE NULL,
    `vega` DOUBLE NULL,
    `rho` DOUBLE NULL,
    `extrinsic` DOUBLE NULL,
    `intrinsic` DOUBLE NULL,
    `probability_itm` DOUBLE NULL,
    `probability_otm` DOUBLE NULL,
    `probability_touch` DOUBLE NULL,
    `covered_return` DOUBLE NULL,
    `max_covered_return` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`code`, `date`, `time`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_option_data_30m', 'SELECT CODE FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_option_data_30m', 'code');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'time', '=Time30()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'description', '=TOS|DESCRIPTION!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'last', '=TOS|LAST!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'change', '=TOS|NET_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'percent_change', '=TOS|PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'last_size', '=TOS|LAST_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'last_x', '=TOS|LX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'mark', '=TOS|MARK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'mark_change', '=TOS|MARK_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'bid', '=TOS|BID!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'ask', '=TOS|ASK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'bid_size', '=TOS|BID_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'ask_size', '=TOS|ASK_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'bid_ask_size', '=TOS|BA_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'bid_x', '=TOS|BX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'ask_x', '=TOS|AX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'open', '=TOS|OPEN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'high', '=TOS|HIGH!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'low', '=TOS|LOW!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'close', '=TOS|Close!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'volume', '=TOS|VOLUME!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'open_int', '=TOS|OPEN_INT!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'implied_vol', '=TOS|IMPL_VOL!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'delta', '=TOS|DELTA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'gamma', '=TOS|GAMMA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'theta', '=TOS|THETA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'vega', '=TOS|VEGA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'rho', '=TOS|RHO!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'extrinsic', '=TOS|EXTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'intrinsic', '=TOS|INTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'probability_otm', '=TOS|PROB_OTM!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'covered_return', '=TOS|COVERED_RETURN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_30m', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[CODE]''', 1);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_option_data_60m` (
    `code` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` SMALLINT NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` SMALLINT NULL,
    `ask_size` SMALLINT NULL,
    `bid_ask_size` VARCHAR(50) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` INTEGER NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `delta` DOUBLE NULL,
    `gamma` DOUBLE NULL,
    `theta` DOUBLE NULL,
    `vega` DOUBLE NULL,
    `rho` DOUBLE NULL,
    `extrinsic` DOUBLE NULL,
    `intrinsic` DOUBLE NULL,
    `probability_itm` DOUBLE NULL,
    `probability_otm` DOUBLE NULL,
    `probability_touch` DOUBLE NULL,
    `covered_return` DOUBLE NULL,
    `max_covered_return` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`code`, `date`, `time`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_option_data_60m', 'SELECT CODE FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_option_data_60m', 'code');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'time', '=Time60()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'description', '=TOS|DESCRIPTION!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'last', '=TOS|LAST!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'change', '=TOS|NET_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'percent_change', '=TOS|PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'last_size', '=TOS|LAST_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'last_x', '=TOS|LX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'mark', '=TOS|MARK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'mark_change', '=TOS|MARK_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'bid', '=TOS|BID!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'ask', '=TOS|ASK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'bid_size', '=TOS|BID_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'ask_size', '=TOS|ASK_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'bid_ask_size', '=TOS|BA_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'bid_x', '=TOS|BX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'ask_x', '=TOS|AX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'open', '=TOS|OPEN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'high', '=TOS|HIGH!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'low', '=TOS|LOW!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'close', '=TOS|Close!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'volume', '=TOS|VOLUME!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'open_int', '=TOS|OPEN_INT!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'implied_vol', '=TOS|IMPL_VOL!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'delta', '=TOS|DELTA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'gamma', '=TOS|GAMMA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'theta', '=TOS|THETA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'vega', '=TOS|VEGA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'rho', '=TOS|RHO!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'extrinsic', '=TOS|EXTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'intrinsic', '=TOS|INTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'probability_otm', '=TOS|PROB_OTM!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'covered_return', '=TOS|COVERED_RETURN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_60m', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[CODE]''', 1);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_option_data_s` (
    `code` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` SMALLINT NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` SMALLINT NULL,
    `ask_size` SMALLINT NULL,
    `bid_ask_size` VARCHAR(50) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` INTEGER NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `delta` DOUBLE NULL,
    `gamma` DOUBLE NULL,
    `theta` DOUBLE NULL,
    `vega` DOUBLE NULL,
    `rho` DOUBLE NULL,
    `extrinsic` DOUBLE NULL,
    `intrinsic` DOUBLE NULL,
    `probability_itm` DOUBLE NULL,
    `probability_otm` DOUBLE NULL,
    `probability_touch` DOUBLE NULL,
    `covered_return` DOUBLE NULL,
    `max_covered_return` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`code`, `date`, `time`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_option_data_s', 'SELECT CODE FROM rtd.tos_option_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_option_data_s', 'code');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'time', '=Time0()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'description', '=TOS|DESCRIPTION!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'last', '=TOS|LAST!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'change', '=TOS|NET_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'percent_change', '=TOS|PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'last_size', '=TOS|LAST_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'last_x', '=TOS|LX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'mark', '=TOS|MARK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'mark_change', '=TOS|MARK_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'bid', '=TOS|BID!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'ask', '=TOS|ASK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'bid_size', '=TOS|BID_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'ask_size', '=TOS|ASK_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'bid_ask_size', '=TOS|BA_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'bid_x', '=TOS|BX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'ask_x', '=TOS|AX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'open', '=TOS|OPEN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'high', '=TOS|HIGH!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'low', '=TOS|LOW!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'close', '=TOS|Close!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'volume', '=TOS|VOLUME!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'open_int', '=TOS|OPEN_INT!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'implied_vol', '=TOS|IMPL_VOL!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'delta', '=TOS|DELTA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'gamma', '=TOS|GAMMA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'theta', '=TOS|THETA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'vega', '=TOS|VEGA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'rho', '=TOS|RHO!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'extrinsic', '=TOS|EXTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'intrinsic', '=TOS|INTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'probability_otm', '=TOS|PROB_OTM!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'covered_return', '=TOS|COVERED_RETURN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_s', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[CODE]''', 1);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_option_data_ticks` (
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `code` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NULL,
    `date` DATE NULL,
    `time` TIME NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` SMALLINT NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` SMALLINT NULL,
    `ask_size` SMALLINT NULL,
    `bid_ask_size` VARCHAR(50) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` INTEGER NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `delta` DOUBLE NULL,
    `gamma` DOUBLE NULL,
    `theta` DOUBLE NULL,
    `vega` DOUBLE NULL,
    `rho` DOUBLE NULL,
    `extrinsic` DOUBLE NULL,
    `intrinsic` DOUBLE NULL,
    `probability_itm` DOUBLE NULL,
    `probability_otm` DOUBLE NULL,
    `probability_touch` DOUBLE NULL,
    `covered_return` DOUBLE NULL,
    `max_covered_return` DOUBLE NULL,
  PRIMARY KEY (`id`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_option_data_ticks', 'SELECT CODE FROM rtd.tos_option_list', 1, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_option_data_ticks', 'id');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_option_data_ticks', 'code');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'time', '=Time()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'description', '=TOS|DESCRIPTION!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'last', '=TOS|LAST!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'change', '=TOS|NET_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'percent_change', '=TOS|PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'last_size', '=TOS|LAST_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'last_x', '=TOS|LX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'mark', '=TOS|MARK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'mark_change', '=TOS|MARK_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'bid', '=TOS|BID!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'ask', '=TOS|ASK!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'bid_size', '=TOS|BID_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'ask_size', '=TOS|ASK_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'bid_ask_size', '=TOS|BA_SIZE!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'bid_x', '=TOS|BX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'ask_x', '=TOS|AX!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'open', '=TOS|OPEN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'high', '=TOS|HIGH!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'low', '=TOS|LOW!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'close', '=TOS|Close!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'volume', '=TOS|VOLUME!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'open_int', '=TOS|OPEN_INT!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'implied_vol', '=TOS|IMPL_VOL!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'delta', '=TOS|DELTA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'gamma', '=TOS|GAMMA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'theta', '=TOS|THETA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'vega', '=TOS|VEGA!''[CODE]''', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'rho', '=TOS|RHO!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'extrinsic', '=TOS|EXTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'intrinsic', '=TOS|INTRINSIC!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'probability_itm', '=TOS|PROB_OF_EXPIRING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'probability_otm', '=TOS|PROB_OTM!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'probability_touch', '=TOS|PROB_OF_TOUCHING!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'covered_return', '=TOS|COVERED_RETURN!''[CODE]''', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_option_data_ticks', 'max_covered_return', '=TOS|MAX_COVERED_RETURN!''[CODE]''', 1);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_stock_quotes_01m` (
    `symbol` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` INTEGER NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` INTEGER NULL,
    `ask_size` INTEGER NULL,
    `bid_ask_size` VARCHAR(255) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `strength_meter` VARCHAR(255) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` BIGINT NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `vol_index` DOUBLE NULL,
    `front_vol` DOUBLE NULL,
    `back_vol` DOUBLE NULL,
    `weighted_back_vol` DOUBLE NULL,
    `vol_diff` DOUBLE NULL,
    `put_call_ratio` DOUBLE NULL,
    `call_volume_index` DOUBLE NULL,
    `put_volume_index` DOUBLE NULL,
    `option_volume_index` DOUBLE NULL,
    `front_expected_move` DOUBLE NULL,
    `back_expected_move` DOUBLE NULL,
    `expected_move_diff` DOUBLE NULL,
    `beta` DOUBLE NULL,
    `high52` DOUBLE NULL,
    `low52` DOUBLE NULL,
    `pe` DOUBLE NULL,
    `eps` DOUBLE NULL,
    `market_cap` VARCHAR(255) NULL,
    `shares` BIGINT NULL,
    `dividend_yield` DOUBLE NULL,
    `dividend_share` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`symbol`, `date`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_stock_quotes_01m', 'SELECT SYMBOL FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_stock_quotes_01m', 'symbol');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'time', '=Time1()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'description', '=TOS|DESCRIPTION![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'last', '=TOS|LAST![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'change', '=TOS|NET_CHANGE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'percent_change', '=TOS|PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'last_size', '=TOS|LAST_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'last_x', '=TOS|LX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'mark', '=TOS|MARK![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'mark_change', '=TOS|MARK_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'bid', '=TOS|BID![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'ask', '=TOS|ASK![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'bid_size', '=TOS|BID_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'ask_size', '=TOS|ASK_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'bid_ask_size', '=TOS|BA_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'bid_x', '=TOS|BX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'ask_x', '=TOS|AX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'strength_meter', '=TOS|STRENGTH_METER![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'open', '=TOS|OPEN![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'high', '=TOS|HIGH![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'low', '=TOS|LOW![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'close', '=TOS|CLOSE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'volume', '=TOS|VOLUME![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'open_int', '=TOS|OPEN_INT![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'implied_vol', '=TOS|IMPL_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'vol_index', '=TOS|VOL_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'front_vol', '=TOS|FRONT_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'back_vol', '=TOS|BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'vol_diff', '=TOS|VOL_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'front_expected_move', '=TOS|FRONT_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'back_expected_move', '=TOS|BACK_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'beta', '=TOS|BETA![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'high52', '=TOS|''52HIGH''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'low52', '=TOS|''52LOW''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'pe', '=TOS|PE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'eps', '=TOS|EPS![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'market_cap', '=TOS|MARKET_CAP![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'shares', '=TOS|SHARES![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'dividend_yield', '=TOS|YIELD![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_01m', 'dividend_share', '=TOS|DIV![SYMBOL]', NULL);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_stock_quotes_05m` (
    `symbol` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` INTEGER NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` INTEGER NULL,
    `ask_size` INTEGER NULL,
    `bid_ask_size` VARCHAR(255) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `strength_meter` VARCHAR(255) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` BIGINT NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `vol_index` DOUBLE NULL,
    `front_vol` DOUBLE NULL,
    `back_vol` DOUBLE NULL,
    `weighted_back_vol` DOUBLE NULL,
    `vol_diff` DOUBLE NULL,
    `put_call_ratio` DOUBLE NULL,
    `call_volume_index` DOUBLE NULL,
    `put_volume_index` DOUBLE NULL,
    `option_volume_index` DOUBLE NULL,
    `front_expected_move` DOUBLE NULL,
    `back_expected_move` DOUBLE NULL,
    `expected_move_diff` DOUBLE NULL,
    `beta` DOUBLE NULL,
    `high52` DOUBLE NULL,
    `low52` DOUBLE NULL,
    `pe` DOUBLE NULL,
    `eps` DOUBLE NULL,
    `market_cap` VARCHAR(255) NULL,
    `shares` BIGINT NULL,
    `dividend_yield` DOUBLE NULL,
    `dividend_share` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`symbol`, `date`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_stock_quotes_05m', 'SELECT SYMBOL FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_stock_quotes_05m', 'symbol');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'time', '=Time5()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'description', '=TOS|DESCRIPTION![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'last', '=TOS|LAST![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'change', '=TOS|NET_CHANGE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'percent_change', '=TOS|PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'last_size', '=TOS|LAST_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'last_x', '=TOS|LX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'mark', '=TOS|MARK![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'mark_change', '=TOS|MARK_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'bid', '=TOS|BID![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'ask', '=TOS|ASK![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'bid_size', '=TOS|BID_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'ask_size', '=TOS|ASK_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'bid_ask_size', '=TOS|BA_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'bid_x', '=TOS|BX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'ask_x', '=TOS|AX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'strength_meter', '=TOS|STRENGTH_METER![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'open', '=TOS|OPEN![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'high', '=TOS|HIGH![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'low', '=TOS|LOW![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'close', '=TOS|CLOSE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'volume', '=TOS|VOLUME![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'open_int', '=TOS|OPEN_INT![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'implied_vol', '=TOS|IMPL_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'vol_index', '=TOS|VOL_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'front_vol', '=TOS|FRONT_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'back_vol', '=TOS|BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'vol_diff', '=TOS|VOL_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'front_expected_move', '=TOS|FRONT_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'back_expected_move', '=TOS|BACK_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'beta', '=TOS|BETA![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'high52', '=TOS|''52HIGH''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'low52', '=TOS|''52LOW''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'pe', '=TOS|PE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'eps', '=TOS|EPS![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'market_cap', '=TOS|MARKET_CAP![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'shares', '=TOS|SHARES![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'dividend_yield', '=TOS|YIELD![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_05m', 'dividend_share', '=TOS|DIV![SYMBOL]', NULL);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_stock_quotes_10m` (
    `symbol` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` INTEGER NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` INTEGER NULL,
    `ask_size` INTEGER NULL,
    `bid_ask_size` VARCHAR(255) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `strength_meter` VARCHAR(255) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` BIGINT NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `vol_index` DOUBLE NULL,
    `front_vol` DOUBLE NULL,
    `back_vol` DOUBLE NULL,
    `weighted_back_vol` DOUBLE NULL,
    `vol_diff` DOUBLE NULL,
    `put_call_ratio` DOUBLE NULL,
    `call_volume_index` DOUBLE NULL,
    `put_volume_index` DOUBLE NULL,
    `option_volume_index` DOUBLE NULL,
    `front_expected_move` DOUBLE NULL,
    `back_expected_move` DOUBLE NULL,
    `expected_move_diff` DOUBLE NULL,
    `beta` DOUBLE NULL,
    `high52` DOUBLE NULL,
    `low52` DOUBLE NULL,
    `pe` DOUBLE NULL,
    `eps` DOUBLE NULL,
    `market_cap` VARCHAR(255) NULL,
    `shares` BIGINT NULL,
    `dividend_yield` DOUBLE NULL,
    `dividend_share` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`symbol`, `date`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_stock_quotes_10m', 'SELECT SYMBOL FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_stock_quotes_10m', 'symbol');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'time', '=Time10()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'description', '=TOS|DESCRIPTION![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'last', '=TOS|LAST![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'change', '=TOS|NET_CHANGE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'percent_change', '=TOS|PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'last_size', '=TOS|LAST_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'last_x', '=TOS|LX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'mark', '=TOS|MARK![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'mark_change', '=TOS|MARK_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'bid', '=TOS|BID![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'ask', '=TOS|ASK![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'bid_size', '=TOS|BID_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'ask_size', '=TOS|ASK_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'bid_ask_size', '=TOS|BA_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'bid_x', '=TOS|BX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'ask_x', '=TOS|AX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'strength_meter', '=TOS|STRENGTH_METER![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'open', '=TOS|OPEN![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'high', '=TOS|HIGH![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'low', '=TOS|LOW![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'close', '=TOS|CLOSE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'volume', '=TOS|VOLUME![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'open_int', '=TOS|OPEN_INT![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'implied_vol', '=TOS|IMPL_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'vol_index', '=TOS|VOL_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'front_vol', '=TOS|FRONT_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'back_vol', '=TOS|BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'vol_diff', '=TOS|VOL_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'front_expected_move', '=TOS|FRONT_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'back_expected_move', '=TOS|BACK_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'beta', '=TOS|BETA![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'high52', '=TOS|''52HIGH''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'low52', '=TOS|''52LOW''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'pe', '=TOS|PE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'eps', '=TOS|EPS![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'market_cap', '=TOS|MARKET_CAP![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'shares', '=TOS|SHARES![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'dividend_yield', '=TOS|YIELD![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_10m', 'dividend_share', '=TOS|DIV![SYMBOL]', NULL);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_stock_quotes_15m` (
    `symbol` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` INTEGER NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` INTEGER NULL,
    `ask_size` INTEGER NULL,
    `bid_ask_size` VARCHAR(255) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `strength_meter` VARCHAR(255) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` BIGINT NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `vol_index` DOUBLE NULL,
    `front_vol` DOUBLE NULL,
    `back_vol` DOUBLE NULL,
    `weighted_back_vol` DOUBLE NULL,
    `vol_diff` DOUBLE NULL,
    `put_call_ratio` DOUBLE NULL,
    `call_volume_index` DOUBLE NULL,
    `put_volume_index` DOUBLE NULL,
    `option_volume_index` DOUBLE NULL,
    `front_expected_move` DOUBLE NULL,
    `back_expected_move` DOUBLE NULL,
    `expected_move_diff` DOUBLE NULL,
    `beta` DOUBLE NULL,
    `high52` DOUBLE NULL,
    `low52` DOUBLE NULL,
    `pe` DOUBLE NULL,
    `eps` DOUBLE NULL,
    `market_cap` VARCHAR(255) NULL,
    `shares` BIGINT NULL,
    `dividend_yield` DOUBLE NULL,
    `dividend_share` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`symbol`, `date`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_stock_quotes_15m', 'SELECT SYMBOL FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_stock_quotes_15m', 'symbol');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'time', '=Time15()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'description', '=TOS|DESCRIPTION![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'last', '=TOS|LAST![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'change', '=TOS|NET_CHANGE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'percent_change', '=TOS|PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'last_size', '=TOS|LAST_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'last_x', '=TOS|LX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'mark', '=TOS|MARK![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'mark_change', '=TOS|MARK_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'bid', '=TOS|BID![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'ask', '=TOS|ASK![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'bid_size', '=TOS|BID_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'ask_size', '=TOS|ASK_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'bid_ask_size', '=TOS|BA_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'bid_x', '=TOS|BX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'ask_x', '=TOS|AX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'strength_meter', '=TOS|STRENGTH_METER![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'open', '=TOS|OPEN![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'high', '=TOS|HIGH![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'low', '=TOS|LOW![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'close', '=TOS|CLOSE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'volume', '=TOS|VOLUME![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'open_int', '=TOS|OPEN_INT![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'implied_vol', '=TOS|IMPL_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'vol_index', '=TOS|VOL_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'front_vol', '=TOS|FRONT_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'back_vol', '=TOS|BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'vol_diff', '=TOS|VOL_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'front_expected_move', '=TOS|FRONT_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'back_expected_move', '=TOS|BACK_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'beta', '=TOS|BETA![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'high52', '=TOS|''52HIGH''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'low52', '=TOS|''52LOW''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'pe', '=TOS|PE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'eps', '=TOS|EPS![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'market_cap', '=TOS|MARKET_CAP![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'shares', '=TOS|SHARES![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'dividend_yield', '=TOS|YIELD![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_15m', 'dividend_share', '=TOS|DIV![SYMBOL]', NULL);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_stock_quotes_20m` (
    `symbol` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` INTEGER NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` INTEGER NULL,
    `ask_size` INTEGER NULL,
    `bid_ask_size` VARCHAR(255) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `strength_meter` VARCHAR(255) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` BIGINT NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `vol_index` DOUBLE NULL,
    `front_vol` DOUBLE NULL,
    `back_vol` DOUBLE NULL,
    `weighted_back_vol` DOUBLE NULL,
    `vol_diff` DOUBLE NULL,
    `put_call_ratio` DOUBLE NULL,
    `call_volume_index` DOUBLE NULL,
    `put_volume_index` DOUBLE NULL,
    `option_volume_index` DOUBLE NULL,
    `front_expected_move` DOUBLE NULL,
    `back_expected_move` DOUBLE NULL,
    `expected_move_diff` DOUBLE NULL,
    `beta` DOUBLE NULL,
    `high52` DOUBLE NULL,
    `low52` DOUBLE NULL,
    `pe` DOUBLE NULL,
    `eps` DOUBLE NULL,
    `market_cap` VARCHAR(255) NULL,
    `shares` BIGINT NULL,
    `dividend_yield` DOUBLE NULL,
    `dividend_share` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`symbol`, `date`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_stock_quotes_20m', 'SELECT SYMBOL FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_stock_quotes_20m', 'symbol');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'time', '=Time20()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'description', '=TOS|DESCRIPTION![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'last', '=TOS|LAST![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'change', '=TOS|NET_CHANGE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'percent_change', '=TOS|PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'last_size', '=TOS|LAST_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'last_x', '=TOS|LX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'mark', '=TOS|MARK![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'mark_change', '=TOS|MARK_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'bid', '=TOS|BID![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'ask', '=TOS|ASK![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'bid_size', '=TOS|BID_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'ask_size', '=TOS|ASK_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'bid_ask_size', '=TOS|BA_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'bid_x', '=TOS|BX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'ask_x', '=TOS|AX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'strength_meter', '=TOS|STRENGTH_METER![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'open', '=TOS|OPEN![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'high', '=TOS|HIGH![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'low', '=TOS|LOW![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'close', '=TOS|CLOSE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'volume', '=TOS|VOLUME![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'open_int', '=TOS|OPEN_INT![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'implied_vol', '=TOS|IMPL_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'vol_index', '=TOS|VOL_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'front_vol', '=TOS|FRONT_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'back_vol', '=TOS|BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'vol_diff', '=TOS|VOL_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'front_expected_move', '=TOS|FRONT_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'back_expected_move', '=TOS|BACK_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'beta', '=TOS|BETA![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'high52', '=TOS|''52HIGH''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'low52', '=TOS|''52LOW''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'pe', '=TOS|PE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'eps', '=TOS|EPS![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'market_cap', '=TOS|MARKET_CAP![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'shares', '=TOS|SHARES![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'dividend_yield', '=TOS|YIELD![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_20m', 'dividend_share', '=TOS|DIV![SYMBOL]', NULL);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_stock_quotes_30m` (
    `symbol` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` INTEGER NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` INTEGER NULL,
    `ask_size` INTEGER NULL,
    `bid_ask_size` VARCHAR(255) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `strength_meter` VARCHAR(255) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` BIGINT NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `vol_index` DOUBLE NULL,
    `front_vol` DOUBLE NULL,
    `back_vol` DOUBLE NULL,
    `weighted_back_vol` DOUBLE NULL,
    `vol_diff` DOUBLE NULL,
    `put_call_ratio` DOUBLE NULL,
    `call_volume_index` DOUBLE NULL,
    `put_volume_index` DOUBLE NULL,
    `option_volume_index` DOUBLE NULL,
    `front_expected_move` DOUBLE NULL,
    `back_expected_move` DOUBLE NULL,
    `expected_move_diff` DOUBLE NULL,
    `beta` DOUBLE NULL,
    `high52` DOUBLE NULL,
    `low52` DOUBLE NULL,
    `pe` DOUBLE NULL,
    `eps` DOUBLE NULL,
    `market_cap` VARCHAR(255) NULL,
    `shares` BIGINT NULL,
    `dividend_yield` DOUBLE NULL,
    `dividend_share` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`symbol`, `date`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_stock_quotes_30m', 'SELECT SYMBOL FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_stock_quotes_30m', 'symbol');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'time', '=Time30()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'description', '=TOS|DESCRIPTION![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'last', '=TOS|LAST![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'change', '=TOS|NET_CHANGE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'percent_change', '=TOS|PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'last_size', '=TOS|LAST_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'last_x', '=TOS|LX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'mark', '=TOS|MARK![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'mark_change', '=TOS|MARK_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'bid', '=TOS|BID![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'ask', '=TOS|ASK![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'bid_size', '=TOS|BID_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'ask_size', '=TOS|ASK_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'bid_ask_size', '=TOS|BA_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'bid_x', '=TOS|BX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'ask_x', '=TOS|AX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'strength_meter', '=TOS|STRENGTH_METER![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'open', '=TOS|OPEN![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'high', '=TOS|HIGH![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'low', '=TOS|LOW![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'close', '=TOS|CLOSE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'volume', '=TOS|VOLUME![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'open_int', '=TOS|OPEN_INT![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'implied_vol', '=TOS|IMPL_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'vol_index', '=TOS|VOL_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'front_vol', '=TOS|FRONT_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'back_vol', '=TOS|BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'vol_diff', '=TOS|VOL_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'front_expected_move', '=TOS|FRONT_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'back_expected_move', '=TOS|BACK_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'beta', '=TOS|BETA![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'high52', '=TOS|''52HIGH''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'low52', '=TOS|''52LOW''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'pe', '=TOS|PE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'eps', '=TOS|EPS![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'market_cap', '=TOS|MARKET_CAP![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'shares', '=TOS|SHARES![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'dividend_yield', '=TOS|YIELD![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_30m', 'dividend_share', '=TOS|DIV![SYMBOL]', NULL);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_stock_quotes_60m` (
    `symbol` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` INTEGER NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` INTEGER NULL,
    `ask_size` INTEGER NULL,
    `bid_ask_size` VARCHAR(255) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `strength_meter` VARCHAR(255) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` BIGINT NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `vol_index` DOUBLE NULL,
    `front_vol` DOUBLE NULL,
    `back_vol` DOUBLE NULL,
    `weighted_back_vol` DOUBLE NULL,
    `vol_diff` DOUBLE NULL,
    `put_call_ratio` DOUBLE NULL,
    `call_volume_index` DOUBLE NULL,
    `put_volume_index` DOUBLE NULL,
    `option_volume_index` DOUBLE NULL,
    `front_expected_move` DOUBLE NULL,
    `back_expected_move` DOUBLE NULL,
    `expected_move_diff` DOUBLE NULL,
    `beta` DOUBLE NULL,
    `high52` DOUBLE NULL,
    `low52` DOUBLE NULL,
    `pe` DOUBLE NULL,
    `eps` DOUBLE NULL,
    `market_cap` VARCHAR(255) NULL,
    `shares` BIGINT NULL,
    `dividend_yield` DOUBLE NULL,
    `dividend_share` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`symbol`, `date`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_stock_quotes_60m', 'SELECT SYMBOL FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_stock_quotes_60m', 'symbol');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'time', '=Time60()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'description', '=TOS|DESCRIPTION![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'last', '=TOS|LAST![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'change', '=TOS|NET_CHANGE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'percent_change', '=TOS|PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'last_size', '=TOS|LAST_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'last_x', '=TOS|LX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'mark', '=TOS|MARK![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'mark_change', '=TOS|MARK_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'bid', '=TOS|BID![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'ask', '=TOS|ASK![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'bid_size', '=TOS|BID_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'ask_size', '=TOS|ASK_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'bid_ask_size', '=TOS|BA_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'bid_x', '=TOS|BX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'ask_x', '=TOS|AX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'strength_meter', '=TOS|STRENGTH_METER![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'open', '=TOS|OPEN![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'high', '=TOS|HIGH![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'low', '=TOS|LOW![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'close', '=TOS|CLOSE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'volume', '=TOS|VOLUME![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'open_int', '=TOS|OPEN_INT![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'implied_vol', '=TOS|IMPL_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'vol_index', '=TOS|VOL_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'front_vol', '=TOS|FRONT_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'back_vol', '=TOS|BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'vol_diff', '=TOS|VOL_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'front_expected_move', '=TOS|FRONT_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'back_expected_move', '=TOS|BACK_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'beta', '=TOS|BETA![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'high52', '=TOS|''52HIGH''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'low52', '=TOS|''52LOW''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'pe', '=TOS|PE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'eps', '=TOS|EPS![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'market_cap', '=TOS|MARKET_CAP![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'shares', '=TOS|SHARES![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'dividend_yield', '=TOS|YIELD![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_60m', 'dividend_share', '=TOS|DIV![SYMBOL]', NULL);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_stock_quotes_s` (
    `symbol` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NOT NULL,
    `date` DATE NOT NULL,
    `time` TIME NOT NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` INTEGER NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` INTEGER NULL,
    `ask_size` INTEGER NULL,
    `bid_ask_size` VARCHAR(255) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `strength_meter` VARCHAR(255) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` BIGINT NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `vol_index` DOUBLE NULL,
    `front_vol` DOUBLE NULL,
    `back_vol` DOUBLE NULL,
    `weighted_back_vol` DOUBLE NULL,
    `vol_diff` DOUBLE NULL,
    `put_call_ratio` DOUBLE NULL,
    `call_volume_index` DOUBLE NULL,
    `put_volume_index` DOUBLE NULL,
    `option_volume_index` DOUBLE NULL,
    `front_expected_move` DOUBLE NULL,
    `back_expected_move` DOUBLE NULL,
    `expected_move_diff` DOUBLE NULL,
    `beta` DOUBLE NULL,
    `high52` DOUBLE NULL,
    `low52` DOUBLE NULL,
    `pe` DOUBLE NULL,
    `eps` DOUBLE NULL,
    `market_cap` VARCHAR(255) NULL,
    `shares` BIGINT NULL,
    `dividend_yield` DOUBLE NULL,
    `dividend_share` DOUBLE NULL,
    `last_update_timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`symbol`, `date`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_stock_quotes_s', 'SELECT SYMBOL FROM rtd.tos_stock_list', NULL, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_stock_quotes_s', 'symbol');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'time', '=Time0()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'description', '=TOS|DESCRIPTION![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'last', '=TOS|LAST![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'change', '=TOS|NET_CHANGE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'percent_change', '=TOS|PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'last_size', '=TOS|LAST_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'last_x', '=TOS|LX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'mark', '=TOS|MARK![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'mark_change', '=TOS|MARK_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'bid', '=TOS|BID![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'ask', '=TOS|ASK![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'bid_size', '=TOS|BID_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'ask_size', '=TOS|ASK_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'bid_ask_size', '=TOS|BA_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'bid_x', '=TOS|BX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'ask_x', '=TOS|AX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'strength_meter', '=TOS|STRENGTH_METER![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'open', '=TOS|OPEN![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'high', '=TOS|HIGH![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'low', '=TOS|LOW![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'close', '=TOS|CLOSE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'volume', '=TOS|VOLUME![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'open_int', '=TOS|OPEN_INT![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'implied_vol', '=TOS|IMPL_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'vol_index', '=TOS|VOL_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'front_vol', '=TOS|FRONT_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'back_vol', '=TOS|BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'vol_diff', '=TOS|VOL_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'front_expected_move', '=TOS|FRONT_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'back_expected_move', '=TOS|BACK_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'beta', '=TOS|BETA![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'high52', '=TOS|''52HIGH''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'low52', '=TOS|''52LOW''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'pe', '=TOS|PE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'eps', '=TOS|EPS![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'market_cap', '=TOS|MARKET_CAP![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'shares', '=TOS|SHARES![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'dividend_yield', '=TOS|YIELD![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_s', 'dividend_share', '=TOS|DIV![SYMBOL]', NULL);

CREATE TABLE IF NOT EXISTS `rtd`.`tos_stock_quotes_ticks` (
    `id` BIGINT NOT NULL AUTO_INCREMENT,
    `symbol` VARCHAR(50) NOT NULL,
    `datetime` DATETIME NULL,
    `date` DATE NULL,
    `time` TIME NULL,
    `description` VARCHAR(255) NULL,
    `last` DOUBLE NULL,
    `change` DOUBLE NULL,
    `percent_change` DOUBLE NULL,
    `last_size` INTEGER NULL,
    `last_x` CHAR(1) NULL,
    `mark` DOUBLE NULL,
    `mark_change` DOUBLE NULL,
    `mark_percent_change` DOUBLE NULL,
    `bid` DOUBLE NULL,
    `ask` DOUBLE NULL,
    `bid_size` INTEGER NULL,
    `ask_size` INTEGER NULL,
    `bid_ask_size` VARCHAR(255) NULL,
    `bid_x` CHAR(1) NULL,
    `ask_x` CHAR(1) NULL,
    `strength_meter` VARCHAR(255) NULL,
    `open` DOUBLE NULL,
    `high` DOUBLE NULL,
    `low` DOUBLE NULL,
    `close` DOUBLE NULL,
    `volume` BIGINT NULL,
    `open_int` INTEGER NULL,
    `implied_vol` DOUBLE NULL,
    `vol_index` DOUBLE NULL,
    `front_vol` DOUBLE NULL,
    `back_vol` DOUBLE NULL,
    `weighted_back_vol` DOUBLE NULL,
    `vol_diff` DOUBLE NULL,
    `put_call_ratio` DOUBLE NULL,
    `call_volume_index` DOUBLE NULL,
    `put_volume_index` DOUBLE NULL,
    `option_volume_index` DOUBLE NULL,
    `front_expected_move` DOUBLE NULL,
    `back_expected_move` DOUBLE NULL,
    `expected_move_diff` DOUBLE NULL,
    `beta` DOUBLE NULL,
    `high52` DOUBLE NULL,
    `low52` DOUBLE NULL,
    `pe` DOUBLE NULL,
    `eps` DOUBLE NULL,
    `market_cap` VARCHAR(255) NULL,
    `shares` BIGINT NULL,
    `dividend_yield` DOUBLE NULL,
    `dividend_share` DOUBLE NULL,
  PRIMARY KEY (`id`)
);


INSERT INTO `rtd`.`real_time_tables` (table_schema, table_name, load_code, is_history, is_disabled, time_zone, rtd_instance_name) VALUES ('rtd', 'tos_stock_quotes_ticks', 'SELECT SYMBOL FROM rtd.tos_stock_list', 1, 1, 'Eastern Standard Time', NULL);

INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'id');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'symbol');
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'datetime', '=DateTime()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'date', '=Date()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'time', '=Time()', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'description', '=TOS|DESCRIPTION![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'last', '=TOS|LAST![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'change', '=TOS|NET_CHANGE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'percent_change', '=TOS|PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'last_size', '=TOS|LAST_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'last_x', '=TOS|LX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'mark', '=TOS|MARK![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'mark_change', '=TOS|MARK_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'mark_percent_change', '=TOS|MARK_PERCENT_CHANGE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid', '=TOS|BID![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'ask', '=TOS|ASK![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid_size', '=TOS|BID_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'ask_size', '=TOS|ASK_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid_ask_size', '=TOS|BA_SIZE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'bid_x', '=TOS|BX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'ask_x', '=TOS|AX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'strength_meter', '=TOS|STRENGTH_METER![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'open', '=TOS|OPEN![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'high', '=TOS|HIGH![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'low', '=TOS|LOW![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'close', '=TOS|CLOSE![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'volume', '=TOS|VOLUME![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'open_int', '=TOS|OPEN_INT![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'implied_vol', '=TOS|IMPL_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'vol_index', '=TOS|VOL_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'front_vol', '=TOS|FRONT_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'back_vol', '=TOS|BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'weighted_back_vol', '=TOS|WEIGHTED_BACK_VOL![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'vol_diff', '=TOS|VOL_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'put_call_ratio', '=TOS|PUT_CALL_RATIO![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'call_volume_index', '=TOS|CALL_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'put_volume_index', '=TOS|PUT_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'option_volume_index', '=TOS|OPTION_VOLUME_INDEX![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'front_expected_move', '=TOS|FRONT_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'back_expected_move', '=TOS|BACK_EX_MOVE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'expected_move_diff', '=TOS|EX_MOVE_DIFF![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'beta', '=TOS|BETA![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'high52', '=TOS|''52HIGH''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'low52', '=TOS|''52LOW''![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'pe', '=TOS|PE![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'eps', '=TOS|EPS![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'market_cap', '=TOS|MARKET_CAP![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'shares', '=TOS|SHARES![SYMBOL]', 1);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'dividend_yield', '=TOS|YIELD![SYMBOL]', NULL);
INSERT INTO `rtd`.`real_time_formulas` (`table_schema`, `table_name`, `column_name`, `rtd_formula`, `is_disabled`) VALUES ('rtd', 'tos_stock_quotes_ticks', 'dividend_share', '=TOS|DIV![SYMBOL]', NULL);

