CREATE SCHEMA IF NOT EXISTS `rtd`;

CREATE TABLE IF NOT EXISTS `rtd`.`real_time_formulas` (
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `table_schema` VARCHAR(128) NOT NULL,
    `table_name` VARCHAR(128) NOT NULL,
    `column_name` VARCHAR(128) NOT NULL,
    `rtd_formula` VARCHAR(255) NULL,
    `is_disabled` TINYINT NULL,
  PRIMARY KEY (`id`)
);

ALTER TABLE `rtd`.`real_time_formulas`
    ADD UNIQUE INDEX `ix_real_time_formulas_schema_name_column_name`
    USING BTREE (
       `table_schema`,
       `table_name`,
       `column_name`
    );


CREATE TABLE IF NOT EXISTS `rtd`.`real_time_tables` (
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `table_schema` VARCHAR(128) NOT NULL,
    `table_name` VARCHAR(128) NOT NULL,
    `load_code` VARCHAR(2000) NULL,
    `is_history` TINYINT NULL,
    `is_disabled` TINYINT NULL,
    `time_zone` VARCHAR(50) NULL,
    `rtd_instance_name` VARCHAR(50) NULL,
  PRIMARY KEY (`id`)
);

ALTER TABLE `rtd`.`real_time_tables`
    ADD UNIQUE INDEX `ix_realtimetables_schema_name`
    USING BTREE (
       `table_schema`,
       `table_name`
    );
    
